/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.TizenLaunchMessages;

public class LoadLibraryConfirmDialog
extends IconAndMessageDialog {
    private Button checkButton = null;
    private boolean selectedYes = false;
    private boolean dialogShowAgain = false;
    private ILaunchConfiguration configuration = null;
    private boolean canceled = false;

    public LoadLibraryConfirmDialog(ILaunchConfiguration config, Shell parent) {
        super(parent);
        this.configuration = config;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TizenLaunchMessages.LOAD_SYMBOL_DIALOG_TITLE);
    }

    public boolean close() {
        return super.close();
    }

    protected Control createMessageArea(Composite composite) {
        String message = null;
        try {
            message = NLS.bind((String)TizenLaunchMessages.LOAD_SYMBOL_DIALOG_COMMENTS, (Object)ProjectUtil.getProject(this.configuration).getName());
        }
        catch (CoreException coreException) {
            message = NLS.bind((String)TizenLaunchMessages.LOAD_SYMBOL_DIALOG_COMMENTS, (Object)"");
        }
        Link launchDialog = new Link(composite, this.getMessageLabelStyle());
        launchDialog.setText(message);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)launchDialog);
        launchDialog.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LoadLibraryConfirmDialog.this.canceled = true;
                LoadLibraryConfirmDialog.this.close();
                ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)LoadLibraryConfirmDialog.this.configuration, (String)"debug");
                if (group != null) {
                    DebugUITools.openLaunchConfigurationDialog((Shell)LoadLibraryConfirmDialog.this.getShell(), (ILaunchConfiguration)LoadLibraryConfirmDialog.this.configuration, (String)group.getIdentifier(), null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)new FillLayout());
        this.checkButton = new Button(parent, 32);
        this.checkButton.setText(TizenLaunchMessages.LOAD_SYMBOL_DIALOG_DO_NOT_SHOW);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
        this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.dialogShowAgain = !this.checkButton.getSelection();
        this.selectedYes = buttonId == 2;
        this.close();
    }

    public boolean selectedYes() {
        return this.selectedYes;
    }

    public boolean openDialogAgain() {
        return this.dialogShowAgain;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected Image getImage() {
        return null;
    }
}

