/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.core.gputil;

import java.io.File;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.tizen.core.gputil.PathUtil;

public class MarkupUtil {
    public static final char DEFAULT_FIRST_LITER = '?';
    public static final char DEFAULT_START_LITER = '(';
    public static final char DEFAULT_END_LITER = ')';
    private static Runner defaultMarkupRunner = null;

    public static String runMarkup(String source, char firstLiter, char startLiter, char endLiter, Runner[] runners) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        if (source.indexOf(firstLiter, 0) < 0) {
            return source;
        }
        String str = "";
        String tempStr = "";
        int stackIdx = 0;
        int len = source.length();
        FuncToken[] stack = new FuncToken[len];
        FuncToken func = null;
        int idx = 0;
        int mode = 0;
        while (idx < len) {
            char ch = source.charAt(idx);
            ++idx;
            switch (mode) {
                case 0: {
                    if (ch == firstLiter) {
                        func = new FuncToken();
                        mode = 1;
                        break;
                    }
                    str = str + ch;
                    break;
                }
                case 1: {
                    tempStr = tempStr + ch;
                    if (ch == startLiter) {
                        mode = 2;
                        break;
                    }
                    func.name = func.name + ch;
                    break;
                }
                case 2: {
                    tempStr = tempStr + ch;
                    if (ch == endLiter) {
                        Runner runner;
                        String[] params = func.param.split(",");
                        String runStr = null;
                        Runner[] runnerArray = runners;
                        int n = runnerArray.length;
                        for (int i = 0; i < n && (runStr = (runner = runnerArray[i]).run(func.name, params)) == null; ++i) {
                        }
                        if (stackIdx > 0) {
                            func = stack[--stackIdx];
                            if (runStr != null) {
                                func.param = func.param + runStr;
                            }
                            mode = 2;
                            break;
                        }
                        if (runStr != null) {
                            str = str + runStr;
                        }
                        mode = 0;
                        func = null;
                        tempStr = "";
                        break;
                    }
                    if (ch == firstLiter) {
                        stack[stackIdx++] = func;
                        func = new FuncToken();
                        mode = 1;
                        break;
                    }
                    func.param = func.param + ch;
                }
            }
        }
        if (!tempStr.isEmpty()) {
            str = str + tempStr;
        }
        return str;
    }

    public static String runMarkup(String source, char firstLiter, char startLiter, char endLiter, Runner runner) {
        return MarkupUtil.runMarkup(source, firstLiter, startLiter, endLiter, new Runner[]{runner});
    }

    public static Runner getDefaultMarkupRunner() {
        if (defaultMarkupRunner == null) {
            defaultMarkupRunner = new Runner(){

                @Override
                public String run(String func, String[] param) {
                    String value;
                    block6: {
                        block8: {
                            block7: {
                                block5: {
                                    value = null;
                                    if (func.equals("if")) {
                                        if (param[0] != null && !param[0].isEmpty() && param.length >= 2) {
                                            return param[1];
                                        }
                                        return param.length >= 3 ? param[2] : null;
                                    }
                                    if (!func.equals("dir")) break block5;
                                    File file = new File(param[0]);
                                    if (!file.exists()) break block6;
                                    value = file.getParent();
                                    break block6;
                                }
                                if (!func.equals("file")) break block7;
                                File file = new File(param[0]);
                                if (!file.exists()) break block6;
                                value = file.toString();
                                break block6;
                            }
                            if (!func.equals("filename")) break block8;
                            File file = new File(param[0]);
                            if (!file.exists()) break block6;
                            value = file.getName();
                            break block6;
                        }
                        if (func.equals("relative")) {
                            return PathUtil.getRelativePath(param[0], param[1]);
                        }
                        if (func.equals("select")) {
                            for (String p : param) {
                                if (p == null || p.isEmpty()) continue;
                                value = p;
                                break;
                            }
                        }
                    }
                    return value;
                }
            };
        }
        return defaultMarkupRunner;
    }

    public static String processDefaultMarkup(String source) {
        return MarkupUtil.runMarkup(source, '?', '(', ')', MarkupUtil.getDefaultMarkupRunner());
    }

    public static Runner getJavaScriptMarkupRunner(String script) {
        ScriptEngine js = new ScriptEngineManager().getEngineByName("javascript");
        try {
            js.eval(script);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        final Invocable invocableEngine = (Invocable)((Object)js);
        Runner runner = new Runner(){

            @Override
            public String run(String func, String[] param) {
                String ret = null;
                try {
                    ret = (String)invocableEngine.invokeFunction(func, param);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
                return ret;
            }
        };
        return runner;
    }

    public static String processMarkupByJavaScript(String source, String javaScript) {
        return MarkupUtil.runMarkup(source, '?', '(', ')', MarkupUtil.getJavaScriptMarkupRunner(javaScript));
    }

    public static String processDefaultMarkup2(String source, Runner[] extRunners) {
        Runner[] runners = new Runner[1 + extRunners.length];
        runners[0] = MarkupUtil.getDefaultMarkupRunner();
        int idx = 1;
        for (Runner runner : extRunners) {
            runners[idx++] = runner;
        }
        return MarkupUtil.runMarkup(source, '?', '(', ')', runners);
    }

    private static class FuncToken {
        public String name = "";
        public String param = "";

        private FuncToken() {
        }
    }

    public static interface Runner {
        public String run(String var1, String[] var2);
    }
}

