/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IComparator;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;

public class ProjectDirtyChecker {
    IProject project;
    List<String> deltaFilterDataList;

    public ProjectDirtyChecker(IProject project) {
        this.project = project;
    }

    public void setDeltaFilter(List<String> deltaFilterDataList) {
        this.deltaFilterDataList = deltaFilterDataList;
    }

    public boolean isDirtyProject() {
        if (this.getOldTree(this.project, this.getBuilder(this.project)) == null) {
            return true;
        }
        AbstractDataTreeNode deltaNode = this.getDeltaTreeNode();
        if (deltaNode != null) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray = deltaNode.getChildren();
            int n = abstractDataTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractDataTreeNode node = abstractDataTreeNodeArray[n2];
                if (!this.isContainDeltaFilterDataList(node)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return false;
    }

    public AbstractDataTreeNode getDeltaTreeNode() {
        ElementTree oldTree = this.getOldTree(this.project, this.getBuilder(this.project));
        ElementTree currentTree = ((Workspace)this.project.getWorkspace()).getElementTree();
        AbstractDataTreeNode deltaNode = null;
        if (oldTree != null) {
            DeltaDataTree currentDelta = currentTree.getDataTree().forwardDeltaWith(oldTree.getDataTree(), (IComparator)ResourceComparator.getBuildComparator());
            deltaNode = currentDelta.findNodeAt(this.project.getFullPath());
        }
        return deltaNode;
    }

    private boolean isContainDeltaFilterDataList(AbstractDataTreeNode deltaNode) {
        String[] splitData = null;
        String deltaName = deltaNode.getName();
        for (String deltaFilterData : this.deltaFilterDataList) {
            splitData = deltaFilterData.split("/");
            if (!(splitData.length == 1 ? deltaName.equals(splitData[0]) : splitData.length > 1 && this.multiDepthChecker(splitData, deltaNode))) continue;
            return true;
        }
        return false;
    }

    private boolean multiDepthChecker(String[] splitData, AbstractDataTreeNode deltaNode) {
        String deltaName = deltaNode.getName();
        AbstractDataTreeNode[] childrenNode = null;
        if (deltaName.equals(splitData[0])) {
            int i = 1;
            while (i < splitData.length) {
                childrenNode = deltaNode.getChildren();
                int j = 0;
                while (j < childrenNode.length) {
                    if (childrenNode[j].getName().equals(splitData[i])) {
                        deltaNode = childrenNode[j];
                        break;
                    }
                    if (j == childrenNode.length - 1) {
                        return false;
                    }
                    ++j;
                }
                if (i == splitData.length - 1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private IncrementalProjectBuilder getBuilder(IProject targetProj) {
        ICommand[] commands = ((Project)targetProj).internalGetDescription().getBuildSpec(false);
        IncrementalProjectBuilder targetBuilder = (IncrementalProjectBuilder)((BuildCommand)commands[0]).getBuilders();
        return targetBuilder;
    }

    private ElementTree getOldTree(IProject targetProj, IncrementalProjectBuilder builder) {
        ElementTree oldTree = null;
        if (builder != null) {
            try {
                Class<?> c = Class.forName("org.eclipse.core.internal.events.InternalBuilder");
                Method m = c.getDeclaredMethod("getLastBuiltTree", new Class[0]);
                m.setAccessible(true);
                oldTree = (ElementTree)m.invoke((Object)builder, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ArrayList infos = null;
            try {
                infos = (ArrayList)targetProj.getSessionProperty(ICoreConstants.K_BUILD_LIST);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            BuilderPersistentInfo nameMatch = null;
            if (infos != null) {
                for (BuilderPersistentInfo info : infos) {
                    String builderName = null;
                    try {
                        builderName = targetProj.getDescription().getBuildSpec()[0].getBuilderName();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (!info.getBuilderName().equals(builderName) || nameMatch != null) continue;
                    nameMatch = info;
                }
                if (nameMatch != null) {
                    oldTree = nameMatch.getLastBuiltTree();
                }
            }
        }
        return oldTree;
    }
}

