/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.templateengine.build;

import java.util.List;
import java.util.Map;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.exception.TizenProcessFailureException;
import org.tizen.nativecommon.templateengine.build.model.BuildProperty;
import org.tizen.nativecommon.templateengine.build.model.DevPackageModel;
import org.tizen.nativecommon.templateengine.build.model.RootstrapModel;
import org.tizen.nativecommon.templateengine.build.model.TargetModel;
import org.tizen.nativecommon.templateengine.build.model.ToolchainModel;
import org.tizen.nativecommon.templateengine.build.util.BuildPluginUtil;
import org.tizen.nativecommon.templateengine.model.TizenTemplate;
import org.tizen.nativecommon.templateengine.process.TizenProcessRunner;

public abstract class AbstractProjectGenerator {
    protected BuildProperty buildProperty;
    protected TizenTemplate template;
    private static final String PATH_ROOTSTRAP = "${SBI_SYSROOT}";
    private static final String NEW_TOOLS_TARGET_PATH = "/home/owner/share/tmp/sdk_tools";

    protected abstract String getQuotedString(String var1);

    public abstract void pressPostValueStoreFromDevPkg(Map<String, String> var1, TizenTemplate var2);

    public abstract void createBuildFiles(Map<String, String> var1, TizenTemplate var2) throws TizenProcessFailureException;

    public abstract TizenProcessRunner getTemplateProcess(String var1, TizenTemplate var2) throws TizenProcessFailureException;

    public AbstractProjectGenerator() {
        this(new BuildProperty());
    }

    public void setTemplate(TizenTemplate template) {
        this.template = template;
    }

    protected AbstractProjectGenerator(BuildProperty buildProperty) {
        this.buildProperty = buildProperty;
    }

    protected String getDefaultCfTc(ToolchainModel tc) {
        return tc.getDefaultCf();
    }

    protected String getDefaultCfRs(RootstrapModel rootstrap) {
        return rootstrap.getDefaultCf();
    }

    protected String getDefaultLfTc(ToolchainModel toolchain) {
        return toolchain.getDefaultLf();
    }

    protected String getRootstrapPath(String rootstrapId) {
        return PATH_ROOTSTRAP;
    }

    protected String getSDKPath() {
        return InstallPathConfig.getSDKPath();
    }

    protected String getDefaultLfRs(RootstrapModel rootstrap) {
        return rootstrap.getDefaultLf();
    }

    protected String getManifestAppId() {
        return (String)this.template.getProperty("app_id");
    }

    protected void addDefaultIncludePaths(TizenTemplate template, TargetModel target) {
        String rootstrapPath = this.getRootstrapPath(target.getRootstrap().getId());
        String includePath2 = FileUtil.appendPath((String)rootstrapPath, (String)"usr/include/libxml2", (boolean)false);
        this.buildProperty.addIncludePath(this.getQuotedString(includePath2));
        String libPath = FileUtil.appendPath((String)this.getSDKPath(), (String)"library", (boolean)false);
        this.buildProperty.addIncludePath(this.getQuotedString(libPath));
    }

    protected void addDefaultCFlags(TizenTemplate template, TargetModel target) {
        ToolchainModel toolchain = target.getToolchain();
        RootstrapModel rootstrap = target.getRootstrap();
        String tc_compilerMiscOpt = this.getDefaultCfTc(toolchain);
        String rs_compilerMiscOpt = this.getDefaultCfRs(rootstrap);
        String projectType = toolchain.getProjectType();
        if (!StringUtil.isEmpty((CharSequence)tc_compilerMiscOpt)) {
            this.buildProperty.addCFlags(tc_compilerMiscOpt);
        }
        if (!StringUtil.isEmpty((CharSequence)rs_compilerMiscOpt)) {
            this.buildProperty.addCFlags(rs_compilerMiscOpt);
        }
        if (projectType.equals("org.tizen.nativecore.buildArtefactType.sharedLib") || projectType.equals("org.tizen.nativecore.buildArtefactType.staticLib")) {
            this.buildProperty.addCFlags(" -fPIC");
        } else {
            this.buildProperty.addCFlags(" -fPIE");
        }
        if (!rootstrap.isProvideVirEnv()) {
            String rootStrapPath = this.getRootstrapPath(target.getRootstrap().getId());
            rootStrapPath = FileUtil.convertToOSPath((String)rootStrapPath, (boolean)false);
            this.buildProperty.addCFlags("--sysroot=" + this.getQuotedString(rootStrapPath));
        }
    }

    protected void addDefaultLFlags(TizenTemplate template, TargetModel target) {
        ToolchainModel toolchain = target.getToolchain();
        RootstrapModel rootstrap = target.getRootstrap();
        String tc_linkerMiscOpt = this.getDefaultLfTc(toolchain);
        String rs_linkerMiscOpt = this.getDefaultLfRs(rootstrap);
        String projectType = toolchain.getProjectType();
        if (!StringUtil.isEmpty((CharSequence)tc_linkerMiscOpt)) {
            this.buildProperty.addLFlags(tc_linkerMiscOpt);
        }
        if (!StringUtil.isEmpty((CharSequence)rs_linkerMiscOpt)) {
            this.buildProperty.addLFlags(rs_linkerMiscOpt);
        }
        if (projectType.equals("org.tizen.nativecore.buildArtefactType.app")) {
            this.buildProperty.addLFlags("-pie -lpthread ");
            String appPath = "";
            String rpathTemplate = "";
            String toolPath = "";
            String toolsTargetPath = NEW_TOOLS_TARGET_PATH;
            if (OSChecker.isWindows() && target.getToolchain().getMakePath().endsWith("/msys2/usr/bin/make.exe")) {
                appPath = "//opt\\\\usr\\\\apps\\\\";
                rpathTemplate = BuildPluginUtil.OSP_LIB_RPATH_OPTION_MSYS;
                toolPath = "//" + toolsTargetPath.replace("/", "\\\\").substring(2);
            } else {
                appPath = "/opt/usr/apps/";
                rpathTemplate = BuildPluginUtil.OSP_LIB_RPATH_OPTION_NOT_MSYS;
                toolPath = toolsTargetPath;
            }
            String rpathAppId = rpathTemplate.replace("$(rpath)", String.valueOf(appPath) + this.getManifestAppId());
            String rpathToolLib = rpathTemplate.replace("$(rpath)", toolPath);
            this.buildProperty.addLFlags(rpathAppId);
            this.buildProperty.addLFlags(rpathToolLib);
        } else if (projectType.equals("org.tizen.nativecore.buildArtefactType.sharedLib")) {
            this.buildProperty.addLFlags("-lpthread ");
        }
        if (!rootstrap.isProvideVirEnv()) {
            String rootStrapPath = this.getRootstrapPath(target.getRootstrap().getId());
            rootStrapPath = FileUtil.convertToOSPath((String)rootStrapPath, (boolean)false);
            this.buildProperty.addLFlags("--sysroot=" + this.getQuotedString(rootStrapPath));
        }
    }

    protected void addIncludePathFromDevPkg(TizenTemplate template, TargetModel target, List<DevPackageModel> devPackageList) {
        String rootStrapPath = this.getRootstrapPath(target.getRootstrap().getId());
        for (DevPackageModel devPkg : devPackageList) {
            for (String includePath : devPkg.getIncludePathList()) {
                includePath = FileUtil.appendPath((String)rootStrapPath, (String)includePath, (boolean)false);
                this.buildProperty.addIncludePath(this.getQuotedString(includePath));
            }
        }
    }

    protected void addCFlagFromDevPkg(TizenTemplate template, TargetModel target, List<DevPackageModel> devPackageList) {
        for (DevPackageModel devPkg : devPackageList) {
            List<String> otherCFlags = devPkg.getOtherCFlagList();
            for (String otherCFlag : otherCFlags) {
                this.buildProperty.addCFlags(otherCFlag);
            }
        }
    }

    protected void addLFlagFromDevPkg(TizenTemplate template, TargetModel target, List<DevPackageModel> devPackageList) {
        String rootStrapPath = this.getRootstrapPath(target.getRootstrap().getId());
        for (DevPackageModel devPkg : devPackageList) {
            List<String> libraryPaths = devPkg.getLibraryPathList();
            for (String libraryPath : libraryPaths) {
                libraryPath = FileUtil.appendPath((String)rootStrapPath, (String)libraryPath, (boolean)false);
                this.buildProperty.addLFlags("-L" + this.getQuotedString(libraryPath));
            }
            List<String> libraries = devPkg.getLibraryList();
            for (String library : libraries) {
                String libraryFlag = "";
                libraryFlag = library.startsWith("lib") ? (library.endsWith(".so") ? String.format("-l%s", library.substring(3, library.length() - 3)) : (library.endsWith(".a") ? String.format("-l%s", library.substring(3, library.length() - 2)) : String.format("-l:%s", library))) : String.format("-l:%s", library);
                this.buildProperty.addLFlags(libraryFlag);
            }
            List<String> otherLFlags = devPkg.getOtherLFlagList();
            if (target.getToolchain().getId().contains("llvm")) {
                otherLFlags.remove("--export-dynamic");
            }
            for (String otherLFlag : otherLFlags) {
                this.buildProperty.addLFlags(otherLFlag);
            }
        }
    }

    public void pressDefaultPostValueStore(Map<String, String> valueStore, TizenTemplate template) throws TizenProcessFailureException {
        TargetModel emulTarget = (TargetModel)template.getProperty("emulator_target");
        String emulTargetId = emulTarget.getId();
        valueStore.put("projectName", template.getProjectName());
        valueStore.put("emulTarget", emulTargetId);
    }

    public BuildProperty getBuildProperty() {
        return this.buildProperty;
    }

    public void doRemainingJob(List<DevPackageModel> emulDevPackageModelList, TizenTemplate template, TargetModel emulTarget) {
    }
}

