# C/C++ build script


_FUNC_EXT2O = $(patsubst %.$(3),$(1)/%.o,$(2))
_FUNC_C2O = $(call _FUNC_EXT2O,$(1),$(2),c)
_FUNC_CPP2O = $(call _FUNC_EXT2O,$(1),$(2),cpp)


# parameter :
#  $(1) - C/C++ soruce file
#  $(2) - output path
#  $(3) - .ext
CONVERT_ESC_EXT_TO_O = $(addprefix $(2)/,$(call CONVERT_4MAKE_TO_OUT,$(patsubst %.$(3),%.o,$(1))))

CONVERT_ESC_C_TO_O = $(call CONVERT_ESC_EXT_TO_O,$(1),$(2),c)
CONVERT_ESC_CPP_TO_O = $(call CONVERT_ESC_EXT_TO_O,$(1),$(2),cpp)


# parameter :
#  $(1) - encoded one C/C++ soruce file
#  $(2) - output path
#  $(3) - proj path
#  $(4) - ext title (C/C++)
#  $(5) - ext (c/cpp)
#  $(6) - compiler ($(CC)/$(CXX))
#  $(7) - build opt
#  $(8) - build opt file
# output :
#  $(9) - output files list
define C_BUILD_PROC_RAW
ifneq ($(3),)
$(call CONVERT_ESC_EXT_TO_O,$(1),$(2),$(5)) : $(3)/$(call DECODE_4MAKE,$(1)) $(8)
else
$(call CONVERT_ESC_EXT_TO_O,$(1),$(2),$(5)) : $(call DECODE_4MAKE,$(1)) $(8)
endif
	@echo '  Building file: $$<'
	@echo '  Invoking: $(4) Compiler'
#	$$(call MAKEDIRS,$$(@D))
	$$(call MAKEDIRS,$$(dir $$(subst $$(SPACE),\ ,$$@)))
	$(6) -c "$$<" -o "$$@" $(7) -Wp,@$(8)
	@echo '  Finished building: $$<'
$(9) += $(call CONVERT_ESC_EXT_TO_O,$(1),$(2),$(5))

endef


# parameter :
#  $(1) - output paths
#  $(2) - proj root paths
#  $(3) - src root paths
#  $(4) - src paths
#  $(5) - inc paths
#  $(6) - inc files
#  $(7) - Defs
#  $(8) - UnDefs
#  $(9) - compiler opt
#  $(10) - compiler opt file
#  $(11) - ext title (C/C++)
#  $(12) - ext (c/cpp)
#  $(13) - compiler ($(CC)/$(CXX))
# output :
#  $(14) - OBJS
# return :
#  none
define C_PROC_RAW

_OUTPUT_DIR := $$(strip $(1))#
_PROJ_DIR := $$(strip $(2))#
_SRC_HOME := $$(strip $(3))#
_SRCS := $(4)#
_INCS := $(5)#
_INC_FILES := $(6)#
_DEFS := $(7)#
_UNDEFS := $(8)#

_OPT := $(9)
_OPT_FILE := $(10)

_EXT_TITLE := $(11)
_EXT := $(12)
_COMPILER := $(13)

#_OUTPUT_FILES := $(14)

#_ENC_SRCS := $$(foreach var,$$(_SRCS),$$(call ENCODE_4MAKE,$$(var)))
#_ENC_SRCS := $$(call ENCODE_4MAKE,$$(_SRCS))
_ENC_SRCS := $$(subst $(BSLASH) ,\&sp\;,$$(_SRCS))
_ENC_SRCS := $$(filter %.$$(_EXT),$$(_ENC_SRCS))

ifneq ($$(strip $$(_SRCS)),)

_NORMAL_SRCS := $$(filter-out %*.$$(_EXT),$$(_ENC_SRCS))
_WIDLCARD_SRCS0 := $$(filter %*.$$(_EXT),$$(_ENC_SRCS))

_WIDLCARD_SRCS0 := $$(foreach var,$$(_WIDLCARD_SRCS0),$$(call CHECK_NO_ABS,$$(var)))
_WIDLCARD_ABS_SRCS0 := $$(foreach var,$$(_WIDLCARD_SRCS0),$$(call CHECK_ABS,$$(var)))

_WIDLCARD_SRCS := $$(foreach var,$$(_WIDLCARD_SRCS0),$$(call FIND_FILES_4MAKE2,$$(_PROJ_DIR),$$(subst \&sp\;,$(BSLASH) ,$$(var))))
_WIDLCARD_ABS_SRCS := $$(foreach var,$$(_WIDLCARD_ABS_SRCS0),$$(call FIND_FILES_4MAKE2,$$(_PROJ_DIR),$$(subst \&sp\;,$(BSLASH) ,$$(var))))

_ALL_SRCS := $$(_NORMAL_SRCS) $$(_WIDLCARD_SRCS) $$(_WIDLCARD_ABS_SRCS)

ifneq ($$(strip $$(_ALL_SRCS)),)

#_ENC_SRCS := $$(call ENCODE_4MAKE,$$(_ALL_SRCS))
_ENC_SRCS := $$(_ALL_SRCS)

_CDEFS := $$(CDEFS)
_CDEFS += $$(addprefix -D,$$(_DEFS))
_CDEFS += $$(addprefix -U,$$(_UNDEFS))

#_ENC_C_INCS := $$(call ENCODE_4MAKE,$$(_INCS))
_ENC_C_INCS := $$(subst $(BSLASH) ,&sp;,$$(_INCS))
_ENC_C_INCS := $$(addprefix -I,$$(_ENC_C_INCS))
 
#_ENC_INC_FILES := $$(call ENCODE_4MAKE,$$(_INC_FILES))
_ENC_INC_FILES := $$(subst $(BSLASH) ,&sp;,$$(_INC_FILES))
_ENC_INC_FILES += $$(addprefix -include,$$(_ENC_INC_FILES))

//_C_INCS := $$(call DECODE_4MAKE,$$(_ENC_C_INCS) $$(_ENC_C_INC_FILES))
_C_INCS := $$(subst &sp;,$(BSLASH) ,$$(_ENC_C_INCS) $$(_ENC_C_INC_FILES))

_DEFS := $$(_CDEFS) $$(_C_INCS) -I"pch" $$(_OPT)

$$(foreach var,$$(_ENC_SRCS),$$(eval $$(call C_BUILD_PROC_RAW,$$(var),$$(_OUTPUT_DIR),$$(_PROJ_DIR),$$(_EXT_TITLE),$$(_EXT),$$(_COMPILER),$$(_DEFS),$$(_OPT_FILE),$(14))))

$$(foreach var,$$(_ENC_SRCS_ABS),$$(eval $$(call C_BUILD_PROC_RAW,$$(var),$$(_OUTPUT_DIR),,$$(_EXT_TITLE),$$(_EXT),$$(_COMPILER),$$(_DEFS),$$(_OPT_FILE),$(14))))

endif  # (_(strip _(_ALL_SRCS)),)

endif  # (_(strip _(_SRCS)),)

endef
