# EDC build script


FUNC_EDC2EDJ = $(patsubst %.edc,%.edj,$(1))

# parameter :
#  $(1) - C/C++ soruce file
#  $(2) - output path
CONVERT_ESC_EDC_TO_EDJ = $(2)/$(call CONVERT_4MAKE_TO_OUT,$(call FUNC_EDC2EDJ,$(1)))


# parameter :
#  $(1) - encoded one C/C++ soruce file
#  $(2) - output path
#  $(3) - proj path
#  $(4) - build opt
# output :
#  $(5) - output files list
define EDJ_BUILD_PROC_RAW
ifneq ($(3),)
$(call CONVERT_ESC_EDC_TO_EDJ,$(1),$(2)) : $(3)/$(call DECODE_4MAKE,$(1))
else
$(call CONVERT_ESC_EDC_TO_EDJ,$(1),$(2)) : $(call DECODE_4MAKE,$(1))
endif
	@echo '  Building file: $$<'
	@echo '  Invoking: EDC Resource Compiler'
#	$$(call MAKEDIRS,$$(@D))
	$$(call MAKEDIRS,$$(dir $$(subst $$(SPACE),\ ,$$@)))
	$$(EDJE_CC) $(4) "$$<" "$$@"
	@echo '  Finished building: $$<'
$(5) += $(call CONVERT_ESC_EDC_TO_EDJ,$(1),$(2))
endef


# parameter :
#  $(1) - output paths
#  $(2) - src paths
#  $(3) - proj path
#  $(4) - image inc paths
#  $(5) - sound inc paths
#  $(6) - font inc paths
# output :
#  $(7) - OBJS
# return :
#  none
define EDJ_PROC_RAW

_OUTPUT_DIR := $$(strip $(1))#
_SRCS := $(2)#
_PROJ_DIR := $(3)#
_IMAGE_DIRS := $(4)#
_SOUND_DIRS := $(5)#
_FONT_DIRS := $(6)#

ifneq ($$(strip $$(_SRCS)),)

#_ENC_SRCS := $$(call ENCODE_4MAKE,$$(_SRCS))
_ENC_SRCS := $$(subst $(BSLASH) ,\&sp\;,$$(_SRCS))

_NORMAL_SRCS := $$(filter-out %*.edc,$$(_ENC_SRCS))
_WIDLCARD_SRCS0 := $$(filter %*.edc,$$(_ENC_SRCS))

_WIDLCARD_SRCS0 := $$(foreach var,$$(_WIDLCARD_SRCS0),$$(call CHECK_NO_ABS,$$(var)))
_WIDLCARD_ABS_SRCS0 := $$(foreach var,$$(_WIDLCARD_SRCS0),$$(call CHECK_ABS,$$(var)))


_WIDLCARD_SRCS := $$(foreach var,$$(_WIDLCARD_SRCS0),$$(call FIND_FILES_4MAKE2,$$(_PROJ_DIR),$$(subst \&sp\;,$(BSLASH) ,$$(var))))
_WIDLCARD_ABS_SRCS := $$(foreach var,$$(_WIDLCARD_ABS_SRCS0),$$(call FIND_FILES_4MAKE2,$$(_PROJ_DIR),$$(subst \&sp\;,$(BSLASH) ,$$(var))))

_ALL_SRCS := $$(_NORMAL_SRCS) $$(_WIDLCARD_SRCS) $$(_WIDLCARD_ABS_SRCS)

_ALL_SRCS := $$(_NORMAL_SRCS) $$(_WIDLCARD_SRCS) $$(_WIDLCARD_ABS_SRCS)

ifneq ($$(strip $$(_ALL_SRCS)),)

#_ENC_SRCS := $$(call ENCODE_4MAKE,$$(_ALL_SRCS))
_ENC_SRCS := $$(subst $(BSLASH) ,\&sp\;,$$(_ALL_SRCS))

_COMPILER_FLAGS := -id "$$(ENVENTOR_PATH)/share/enventor/images"
_COMPILER_FLAGS += -sd "$$(ENVENTOR_PATH)/share/enventor/sounds"
_COMPILER_FLAGS += -fd "$$(ENVENTOR_PATH)/share/enventor/fonts"

ifneq ($$(strip $$(_IMAGE_DIRS)),)
_COMPILER_FLAGS += $$(addprefix -id ,$$(_IMAGE_DIRS))
endif
ifneq ($$(strip $$(_SOUND_DIRS)),)
_COMPILER_FLAGS += $$(addprefix -sd ,$$(_SOUND_DIRS))
endif
ifneq ($$(strip $$(_FONT_DIRS)),)
_COMPILER_FLAGS += $$(addprefix -fd ,$$(_FONT_DIRS))
endif

$$(foreach var,$$(_ENC_SRCS),$$(eval $$(call EDJ_BUILD_PROC_RAW,$$(var),$$(_OUTPUT_DIR),$$(_PROJ_DIR),$$(_COMPILER_FLAGS),$(7))))

endif  # (_(strip _(_ALL_SRCS)),)

endif  # (_(strip _(_SRCS)),)

endef
