/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecommon.build.PackageInfo;
import org.tizen.nativecommon.build.PackageListener;
import org.tizen.nativecore.build.NativeCoreProjectDependentPackager;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.xmlstore.CoreXMLStore;
import org.tizen.nativecore.misc.core.ManifestManager;

public class NativeCorePackageListener
implements PackageListener {
    public void installListener() {
        NativeCoreProjectDependentPackager.getInstance().addListener((PackageListener)this);
    }

    public void uninstallListener() {
        NativeCoreProjectDependentPackager.getInstance().removeListener((PackageListener)this);
    }

    public void preCreated(PackageInfo info) throws CoreException {
        if (info.isLaunchMode()) {
            return;
        }
        IProject project = info.getProject();
        ManifestManager.verifyExecutableName(project);
        CoreXMLStore manifest = new CoreXMLStore(project);
        if (manifest.loadXml()) {
            Manifest model = manifest.getCoreManifest();
            boolean hasScreenKey = false;
            for (String key : model.getFeature_map().keySet()) {
                if (!key.contains("screen.size")) continue;
                hasScreenKey = true;
                break;
            }
            if (!hasScreenKey) {
                SWTUtil.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog dlg = new MessageDialog(SWTUtil.getActiveShell(), "Warning", null, "Since the screen size feature is not specified, the Tizen Store can reject the application. In the features tab of the manifest editor, add at least 1 applicable screen size feature for the application.", 4, new String[]{"OK"}, 0){

                            protected Control createCustomArea(Composite parent) {
                                Link link = new Link(parent, 0);
                                link.setText("For more information, please see  <a href=\"http://developer.tizen.org/development/training/native-application/understanding-tizen-programming/application-filtering\">here.</a> ");
                                link.addListener(13, new Listener(){

                                    public void handleEvent(Event event) {
                                        System.out.println(event.text);
                                        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(event.text);
                                    }
                                });
                                return super.createCustomArea(parent);
                            }
                        };
                        dlg.open();
                    }
                });
            }
        }
    }
}

