/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.core.LanguageData;
import org.tizen.nativecore.misc.core.LanguageListXmlStore;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttribute;

public class UiAttrLocaledName
extends UiAttribute {
    Label fTabelDes;
    Button fAddBtn;
    Button fRemoveBtn;
    Button fImportBtn;
    TableViewer fTable;
    List<LocaledValue> fInput;
    private Button fEditBtn;
    private boolean fDefaultLocaleRequired = true;
    Composite titleComposite;
    Composite tableGridComposite;

    public UiAttrLocaledName(TizenFormPage page, boolean mandatory) {
        super(page, mandatory);
    }

    public void setVisible(boolean visible) {
        if (this.titleComposite != null) {
            this.titleComposite.setVisible(visible);
        }
        if (this.tableGridComposite != null) {
            this.tableGridComposite.setVisible(visible);
        }
    }

    public void setInput(List<LocaledValue> input) {
        this.fInput = input;
        this.fTable.setInput((Object)this.fInput.toArray());
        if (!this.fInput.isEmpty()) {
            this.updateRemoveButtonStatus();
        }
        this.validate();
    }

    public List<LocaledValue> getInput() {
        if (this.fInput != null) {
            return this.fInput;
        }
        return new ArrayList<LocaledValue>();
    }

    public void setDefaultLocaleRequired(boolean defaultLocaleRequired) {
        this.fDefaultLocaleRequired = defaultLocaleRequired;
    }

    private Font getBoldFont(Control label, int fontSize) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    public void createUi(Composite parent, FormToolkit toolkit, final String labelText, boolean isTextBold) {
        GridData tableGridData = new GridData(4, 1025, true, false);
        this.titleComposite = toolkit.createComposite(parent);
        this.titleComposite.setLayout((Layout)new GridLayout(2, true));
        this.titleComposite.setLayoutData((Object)tableGridData);
        this.fTabelDes = new Label(this.titleComposite, 1024);
        this.fTabelDes.setText(labelText);
        if (isTextBold) {
            this.fTabelDes.setFont(this.getBoldFont((Control)this.fTabelDes, 10));
            this.fTabelDes.setForeground(new Color(null, 51, 51, 51));
        }
        this.fTabelDes.setBackground(new Color(null, 255, 255, 255));
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 3;
        buttonGridData.grabExcessHorizontalSpace = true;
        Composite buttonsComposite = new Composite(this.titleComposite, 131072);
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        buttonsComposite.setLayoutData((Object)buttonGridData);
        buttonsComposite.setBackground(new Color(null, 255, 255, 255));
        this.fAddBtn = new Button(buttonsComposite, 0x2000000);
        String fAddBtnEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_add_over.png").getFile();
        this.fAddBtn.setBackgroundImage(new Image(null, new ImageData(fAddBtnEnabled)));
        this.fAddBtn.setLayoutData((Object)buttonGridData);
        this.fAddBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LocaleNameDialog dlg = new LocaleNameDialog(Display.getDefault().getActiveShell(), labelText, UiAttrLocaledName.this.fInput);
                dlg.setValueLabel(labelText);
                if (dlg.open() == 0) {
                    LocaledValue created = new LocaledValue(dlg.getLocale(), dlg.getName());
                    if (UiAttrLocaledName.this.fInput != null) {
                        UiAttrLocaledName.this.fInput.add(created);
                    }
                    UiAttrLocaledName.this.fTable.add((Object)created);
                    UiAttrLocaledName.this.getPage().setDirty(true);
                    UiAttrLocaledName.this.validate();
                }
            }
        });
        this.fEditBtn = new Button(buttonsComposite, 0x2000000);
        String fEditBtnEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_edit_over.png").getFile();
        this.fEditBtn.setBackgroundImage(new Image(null, new ImageData(fEditBtnEnabled)));
        this.fEditBtn.setLayoutData((Object)buttonGridData);
        this.fEditBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiAttrLocaledName.this.onEdit(labelText);
            }
        });
        this.fEditBtn.setEnabled(false);
        this.fRemoveBtn = new Button(buttonsComposite, 0x2000000);
        String fRemoveBtnEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_delete_over.png").getFile();
        this.fRemoveBtn.setBackgroundImage(new Image(null, new ImageData(fRemoveBtnEnabled)));
        this.fRemoveBtn.setLayoutData((Object)buttonGridData);
        this.fRemoveBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                IStructuredSelection sel = (IStructuredSelection)UiAttrLocaledName.this.fTable.getSelection();
                LocaledValue lv = (LocaledValue)sel.getFirstElement();
                if (lv != null) {
                    if (UiAttrLocaledName.this.fInput != null) {
                        UiAttrLocaledName.this.fInput.remove(lv);
                    }
                    UiAttrLocaledName.this.fTable.remove((Object)lv);
                    UiAttrLocaledName.this.getPage().setDirty(true);
                    UiAttrLocaledName.this.validate();
                }
            }
        });
        this.fRemoveBtn.setEnabled(false);
        this.tableGridComposite = toolkit.createComposite(parent);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        this.tableGridComposite.setLayout((Layout)gl);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        this.tableGridComposite.setLayoutData((Object)gridData);
        toolkit.paintBordersFor(this.tableGridComposite);
        Composite tableComposite = new Composite(this.tableGridComposite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout layout = new TableColumnLayout();
        tableComposite.setLayout((Layout)layout);
        this.fTable = new TableViewer(tableComposite, 68352);
        Table table = this.fTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn col = new TableViewerColumn(this.fTable, 0);
        layout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnPixelData(100, true, true));
        col.getColumn().setText("Language");
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LocaledValue) {
                    return ((LocaledValue)element).getLocale();
                }
                return super.getText(element);
            }
        });
        col = new TableViewerColumn(this.fTable, 16384);
        layout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        col.getColumn().setText(labelText);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LocaledValue) {
                    return ((LocaledValue)element).getValue();
                }
                return super.getText(element);
            }
        });
        this.fTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                UiAttrLocaledName.this.onEdit(labelText);
            }
        });
        this.fTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UiAttrLocaledName.this.updateRemoveButtonStatus();
            }
        });
    }

    protected void updateRemoveButtonStatus() {
        IStructuredSelection sel = (IStructuredSelection)this.fTable.getSelection();
        LocaledValue lv = (LocaledValue)sel.getFirstElement();
        if (lv == null) {
            this.fRemoveBtn.setEnabled(false);
            this.fEditBtn.setEnabled(false);
        } else {
            this.fRemoveBtn.setEnabled(true);
            this.fEditBtn.setEnabled(true);
            if (this.fDefaultLocaleRequired && lv.getLocale().equals("en-gb")) {
                this.fRemoveBtn.setEnabled(false);
            }
        }
    }

    protected void onEdit(String title) {
        IStructuredSelection sel = (IStructuredSelection)this.fTable.getSelection();
        LocaledValue lv = (LocaledValue)sel.getFirstElement();
        if (lv == null) {
            return;
        }
        LocaleNameDialog dlg = new LocaleNameDialog(Display.getDefault().getActiveShell(), title, this.fInput);
        dlg.setEditMode(lv);
        if (dlg.open() == 0) {
            lv.setLocale(dlg.getLocale());
            lv.setValue(dlg.getName());
            this.fTable.update((Object)lv, null);
            this.getPage().setDirty(true);
        }
    }

    @Override
    public boolean validate() {
        if (this.isMandatory() && this.fInput.size() == 0) {
            this.getPage().getManagedForm().getMessageManager().addMessage((Object)this.fTable.getTable(), "Label is mandatory attribute.", null, 3, (Control)this.fTable.getTable());
            return false;
        }
        this.getPage().getManagedForm().getMessageManager().removeMessage((Object)this.fTable.getTable(), (Control)this.fTable.getTable());
        return true;
    }

    private static class LocaleNameDialog
    extends SelectionStatusDialog
    implements Listener {
        private String fValueLabel = "Name";
        private String fLocale;
        private String fName;
        private Set<String> fFilter;
        private Combo fLocaleCombo;
        private Text fNameText;
        private LocaledValue fEditTarget;

        private Font getBoldFont(Control label, int fontSize) {
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
            Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
            FontData[] fD = boldFont.getFontData();
            if (fontSize != 0) {
                fD[0].setHeight(fontSize);
            }
            return new Font(null, fD[0]);
        }

        public LocaleNameDialog(Shell parentShell, String title, List<LocaledValue> filter) {
            super(parentShell);
            this.setTitle(title);
            this.fFilter = new HashSet<String>();
            if (filter != null) {
                for (LocaledValue lvalue : filter) {
                    this.fFilter.add(lvalue.getLocale());
                }
            }
        }

        public void setEditMode(LocaledValue lv) {
            this.fEditTarget = lv;
        }

        public void setValueLabel(String valueLabel) {
            this.fValueLabel = valueLabel;
        }

        public String getLocale() {
            return this.fLocale;
        }

        public String getName() {
            return this.fName;
        }

        public void handleEvent(Event event) {
            this.validate();
        }

        protected void computeResult() {
            this.fName = this.fNameText.getText().trim();
            this.fLocale = this.fLocaleCombo.getText();
        }

        private void validate() {
            Status status = null;
            this.computeResult();
            status = this.fName.length() == 0 ? new Status(4, "org.tizen.nativecore.misc", "Enter a " + this.fValueLabel) : new Status(0, "org.tizen.nativecore.misc", null);
            this.updateStatus((IStatus)status);
        }

        protected Control createDialogArea(Composite parent) {
            Composite grid = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginTop = 20;
            layout.marginBottom = 9;
            layout.marginLeft = 20;
            layout.marginRight = 20;
            layout.verticalSpacing = 10;
            grid.setLayout((Layout)layout);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 510;
            grid.setLayoutData((Object)gd);
            Label label = new Label(grid, 0);
            label.setText("Language:");
            label.setFont(this.getBoldFont((Control)label, 0));
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.fLocaleCombo = new Combo(grid, 8);
            ArrayList<LanguageData> languageList = LanguageListXmlStore.getInstance().getLanguageList();
            for (LanguageData lang : languageList) {
                String id = lang.getId();
                if (this.fFilter.contains(id)) continue;
                this.fLocaleCombo.add(lang.getId());
            }
            this.fLocaleCombo.addListener(2, (Listener)this);
            if (this.fFilter.contains("en-gb")) {
                this.fLocaleCombo.select(0);
            } else {
                this.fLocaleCombo.setText("en-gb");
            }
            this.fLocaleCombo.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
            this.fLocaleCombo.setLayout((Layout)new GridLayout());
            label = new Label(grid, 0);
            label.setText(String.valueOf(this.fValueLabel) + ":");
            label.setFont(this.getBoldFont((Control)label, 0));
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.fNameText = new Text(grid, 2048);
            this.fNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.fNameText.addListener(24, (Listener)this);
            this.fNameText.setFocus();
            if (this.fEditTarget != null) {
                this.fLocaleCombo.add(this.fEditTarget.getLocale());
                this.fLocaleCombo.setText(this.fEditTarget.getLocale());
                this.fNameText.setText(this.fEditTarget.getValue());
            }
            this.setHelpAvailable(false);
            this.validate();
            return grid;
        }
    }
}

