/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistProcessor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ContentAssistPreference {
    public static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    public static final String TIMEOUT_DELAY = "content_assist_timeout_delay";
    public static final String PROPOSALS_TIMEOUT = "content_assist_proposals_timeout";
    public static final String PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    public static final String PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    public static final String PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    public static final String PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    public static final String AUTOINSERT = "content_assist_autoinsert";
    public static final String PREFIX_COMPLETION = "content_assist_prefix_completion";
    public static final String AUTOACTIVATION_TRIGGERS_DOT = "content_assist_autoactivation_trigger_dot";
    public static final String AUTOACTIVATION_TRIGGERS_ARROW = "content_assist_autoactivation_trigger_arrow";
    public static final String AUTOACTIVATION_TRIGGERS_DOUBLECOLON = "content_assist_autoactivation_trigger_doublecolon";
    public static final String AUTOACTIVATION_TRIGGERS_REPLACE_DOT_WITH_ARROW = "content_assist_autoactivation_trigger_replace_dot_with_arrow";
    public static final String AUTOACTIVATION_TRIGGERS_AS_TYPES = "content_assist_autoactivation_trigger_as_types";
    public static final String AUTOACTIVATION_TRIGGERS_AS_TYPES_ENABLE = "content_assist_autoactivation_trigger_as_types_enabled";
    public static final String AUTOACTIVATION_TRIGGERS_AS_TYPES_DEFAULT = "_abcdefghighklmnopqrstuvwxyzABCDEFGHIGHKLMNOPQRSTUVWXYZ";
    public static final String DEFAULT_ARGUMENT_DISPLAY_PARAMETERS_WITH_DEFAULT_ARGUMENT = "content_assist_default_argument_display_parameters_with_default_argument";
    public static final String DEFAULT_ARGUMENT_DISPLAY_ARGUMENTS = "content_assist_default_argument_display_arguments";
    public static final String ORDER_PROPOSALS = "content_assist_order_proposals";
    public static final String CURRENT_FILE_SEARCH_SCOPE = "content_assist_current_file_search_scope";
    public static final String PROJECT_SEARCH_SCOPE = "content_assist_project_search_scope";
    public static final String PROPOSALS_FILTER = "content_assist_proposal_filter";
    public static final String SHOW_CAMEL_CASE_MATCHES = "contentAssist.showCamelCaseMatches";
    private static ContentAssistPreference instance = null;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String prop = event.getProperty();
            if (prop.equals(ContentAssistPreference.SHOW_CAMEL_CASE_MATCHES)) {
                ContentAssistPreference.this.updateOnPreferences();
            }
        }
    };

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    private static Color getColor(IPreferenceStore store, String key) {
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        return ContentAssistPreference.getColor(store, key, textTools.getColorManager());
    }

    private static CContentAssistProcessor getCProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (p instanceof CContentAssistProcessor) {
            return (CContentAssistProcessor)p;
        }
        return null;
    }

    private static void configureCProcessor(ContentAssistant assistant, IPreferenceStore store) {
        CContentAssistProcessor ccp = ContentAssistPreference.getCProcessor(assistant);
        if (ccp == null) {
            return;
        }
        ContentAssistPreference.configureActivationCharacters(store, ccp);
    }

    private static void configureActivationCharacters(IPreferenceStore store, CContentAssistProcessor ccp) {
        String triggers = "";
        boolean useDotAsTrigger = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
        boolean useArrowAsTrigger = store.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW);
        boolean useDoubleColonAsTrigger = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON);
        boolean triggerCharsEnabled = store.getBoolean(AUTOACTIVATION_TRIGGERS_AS_TYPES_ENABLE);
        String triggerChars = store.getString(AUTOACTIVATION_TRIGGERS_AS_TYPES);
        if (useDotAsTrigger) {
            triggers = ".";
        }
        if (useArrowAsTrigger) {
            triggers = String.valueOf(triggers) + ">";
        }
        if (useDoubleColonAsTrigger) {
            triggers = String.valueOf(triggers) + ":";
        }
        if (triggerCharsEnabled) {
            triggers = String.valueOf(triggers) + AUTOACTIVATION_TRIGGERS_AS_TYPES_DEFAULT;
            if (!triggerChars.isEmpty()) {
                triggers = String.valueOf(triggers) + triggerChars;
            }
        }
        ccp.setCContentAutoActivationCharacters(triggers);
        boolean dotTriggersAutoReplace = store.getBoolean(AUTOACTIVATION_TRIGGERS_REPLACE_DOT_WITH_ARROW);
        if (!useDotAsTrigger && dotTriggersAutoReplace) {
            triggers = String.valueOf(triggers) + ".";
        }
        ccp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        triggers = "";
        if (dotTriggersAutoReplace) {
            triggers = ".";
        }
        ccp.setReplacementAutoActivationCharacters(triggers);
    }

    public static void configure(ContentAssistant assistant, IPreferenceStore store) {
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        IColorManager manager = textTools.getColorManager();
        boolean enabledDot = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
        boolean enabledArrow = store.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW);
        boolean enabledDoubleColon = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON);
        boolean enabledReplaceDotWithArrow = store.getBoolean(AUTOACTIVATION_TRIGGERS_REPLACE_DOT_WITH_ARROW);
        boolean enabledTyped = store.getBoolean(AUTOACTIVATION_TRIGGERS_AS_TYPES);
        boolean enabled = enabledDot || enabledArrow || enabledDoubleColon || enabledReplaceDotWithArrow || enabledTyped;
        assistant.enableAutoActivation(enabled);
        int delay = store.getInt(AUTOACTIVATION_DELAY);
        assistant.setAutoActivationDelay(delay);
        Color c1 = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND, manager);
        assistant.setProposalSelectorForeground(c1);
        Color c2 = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND, manager);
        assistant.setProposalSelectorBackground(c2);
        Color c3 = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND, manager);
        assistant.setContextInformationPopupForeground(c3);
        assistant.setContextSelectorForeground(c3);
        Color c4 = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND, manager);
        assistant.setContextInformationPopupBackground(c4);
        assistant.setContextSelectorBackground(c4);
        enabled = store.getBoolean(AUTOINSERT);
        assistant.enableAutoInsert(enabled);
        enabled = store.getBoolean(PREFIX_COMPLETION);
        assistant.enablePrefixCompletion(enabled);
        ContentAssistPreference.configureCProcessor(assistant, store);
    }

    private static void changeCProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        CContentAssistProcessor ccp = ContentAssistPreference.getCProcessor(assistant);
        if (ccp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_DOT.equals(key) || AUTOACTIVATION_TRIGGERS_ARROW.equals(key) || AUTOACTIVATION_TRIGGERS_DOUBLECOLON.equals(key) || AUTOACTIVATION_TRIGGERS_REPLACE_DOT_WITH_ARROW.equals(key) || AUTOACTIVATION_TRIGGERS_AS_TYPES_ENABLE.equals(key)) {
            ContentAssistPreference.configureActivationCharacters(store, ccp);
        }
    }

    public static void changeConfiguration(ContentAssistant assistant, IPreferenceStore store, PropertyChangeEvent event) {
        String p = event.getProperty();
        if (AUTOACTIVATION_TRIGGERS_DOT.equals(p) || AUTOACTIVATION_TRIGGERS_ARROW.equals(p) || AUTOACTIVATION_TRIGGERS_DOUBLECOLON.equals(p) || AUTOACTIVATION_TRIGGERS_REPLACE_DOT_WITH_ARROW.equals(p)) {
            boolean enabledDot = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
            boolean enabledArrow = store.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW);
            boolean enabledDoubleColon = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON);
            boolean enabledReplaceDotWithArrow = store.getBoolean(AUTOACTIVATION_TRIGGERS_REPLACE_DOT_WITH_ARROW);
            boolean enabledAlways = store.getBoolean(AUTOACTIVATION_TRIGGERS_AS_TYPES);
            boolean enabled = enabledDot || enabledArrow || enabledDoubleColon || enabledReplaceDotWithArrow || enabledAlways;
            assistant.enableAutoActivation(enabled);
        } else if (AUTOACTIVATION_DELAY.equals(p)) {
            int delay = store.getInt(AUTOACTIVATION_DELAY);
            assistant.setAutoActivationDelay(delay);
        } else if (PROPOSALS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND);
            assistant.setProposalSelectorForeground(c);
        } else if (PROPOSALS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND);
            assistant.setProposalSelectorBackground(c);
        } else if (PARAMETERS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND);
            assistant.setContextInformationPopupForeground(c);
            assistant.setContextSelectorForeground(c);
        } else if (PARAMETERS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND);
            assistant.setContextInformationPopupBackground(c);
            assistant.setContextSelectorBackground(c);
        } else if (AUTOINSERT.equals(p)) {
            boolean enabled = store.getBoolean(AUTOINSERT);
            assistant.enableAutoInsert(enabled);
        } else if (PREFIX_COMPLETION.equals(p)) {
            boolean enabled = store.getBoolean(PREFIX_COMPLETION);
            assistant.enablePrefixCompletion(enabled);
        }
        ContentAssistPreference.changeCProcessor(assistant, store, p);
    }

    private ContentAssistPreference() {
        ContentAssistPreference.getPreferences().addPropertyChangeListener(this.propertyListener);
        this.updateOnPreferences();
    }

    public static synchronized ContentAssistPreference getInstance() {
        if (instance == null) {
            instance = new ContentAssistPreference();
        }
        return instance;
    }

    private static IPreferenceStore getPreferences() {
        return CUIPlugin.getDefault().getPreferenceStore();
    }

    private synchronized void updateOnPreferences() {
        boolean showCamelCaseMatches = ContentAssistPreference.getPreferences().getBoolean(SHOW_CAMEL_CASE_MATCHES);
        ContentAssistMatcherFactory.getInstance().setShowCamelCaseMatches(showCamelCaseMatches);
    }

    private void shutdownInternal() {
        ContentAssistPreference.getPreferences().removePropertyChangeListener(this.propertyListener);
    }

    public static synchronized void shutdown() {
        if (instance != null) {
            instance.shutdownInternal();
        }
    }
}

