/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.editor.AbstractCModelOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.cdt.ui.actions.GenerateActionGroup;
import org.eclipse.cdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.cdt.ui.refactoring.actions.CRefactoringActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CContentOutlinePage
extends AbstractCModelOutlinePage {
    private Composite fParent;
    private StackLayout fStackLayout;
    private Composite fOutlinePage;
    private Control fStatusPage;
    private boolean fScalabilityMode;

    public CContentOutlinePage(CEditor editor) {
        super("#TranslationUnitOutlinerContext", editor);
    }

    public CEditor getEditor() {
        return (CEditor)this.fEditor;
    }

    @Override
    public void createControl(Composite parent) {
        this.fParent = new Composite(parent, 0);
        this.fStackLayout = new StackLayout();
        this.fParent.setLayout((Layout)this.fStackLayout);
        this.fOutlinePage = new Composite(this.fParent, 0);
        this.fOutlinePage.setLayout((Layout)new FillLayout());
        super.createControl(this.fOutlinePage);
        this.fStatusPage = this.createStatusPage(this.fParent);
        this.updateVisiblePage();
    }

    @Override
    public Control getControl() {
        return this.fParent;
    }

    private Control createStatusPage(Composite parent) {
        final Link link = new Link(parent, 0);
        link.setText(CEditorMessages.Scalability_outlineDisabled);
        link.setToolTipText(CEditorMessages.Scalability_linkToolTip);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.cdt.ui.preferences.CScalabilityPreferences", null, null).open();
            }
        });
        return link;
    }

    @Override
    public void setInput(ITranslationUnit unit) {
        CEditor editor = this.getEditor();
        if (editor.isEnableScalablilityMode() && PreferenceConstants.getPreferenceStore().getBoolean("scalability.reconciler")) {
            this.fScalabilityMode = true;
            super.setInput(null);
        } else {
            this.fScalabilityMode = false;
            super.setInput(unit);
        }
        this.updateVisiblePage();
    }

    private void updateVisiblePage() {
        if (this.fStackLayout == null) {
            return;
        }
        if (this.fScalabilityMode) {
            if (this.fStackLayout.topControl != this.fStatusPage) {
                this.fStackLayout.topControl = this.fStatusPage;
                this.fParent.layout();
            }
        } else if (this.fStackLayout.topControl != this.fOutlinePage) {
            this.fStackLayout.topControl = this.fOutlinePage;
            this.fParent.layout();
        }
    }

    @Override
    protected ActionGroup createSearchActionGroup() {
        return new SelectionSearchGroup(this);
    }

    @Override
    protected ActionGroup createOpenViewActionGroup() {
        OpenViewActionGroup ovag = new OpenViewActionGroup(this, this.getEditor());
        ovag.setEnableIncludeBrowser(true);
        return ovag;
    }

    @Override
    protected ActionGroup createRefactoringActionGroup() {
        return new CRefactoringActionGroup(this);
    }

    @Override
    protected ActionGroup createSourceActionGroup() {
        return new GenerateActionGroup(this);
    }

    @Override
    protected ActionGroup createCustomFiltersActionGroup() {
        return new CustomFiltersActionGroup("org.eclipse.cdt.ui.COutlinePage", (StructuredViewer)this.getTreeViewer());
    }

    @Override
    protected ActionGroup createMemberFilterActionGroup() {
        return new MemberFilterActionGroup((StructuredViewer)this.getTreeViewer(), "COutlineViewer");
    }

    @Override
    protected void registerActionBars(IActionBars actionBars) {
        super.registerActionBars(actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)new MemberGroupingAction(this));
        menu.add((IAction)new NamespaceGroupingAction(this));
    }

    protected static class MemberGroupingAction
    extends Action {
        public MemberGroupingAction(AbstractCModelOutlinePage outlinePage) {
            super(ActionMessages.MemberGroupingAction_label);
            this.setDescription(ActionMessages.MemberGroupingAction_description);
            this.setToolTipText(ActionMessages.MemberGroupingAction_tooltip);
            CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.public_co.gif");
            boolean enabled = this.isMemberGroupingEnabled();
            this.setChecked(enabled);
        }

        public void run() {
            PreferenceConstants.getPreferenceStore().setValue("org.eclipse.cdt.ui.outline.groupmembers", this.isChecked());
        }

        public boolean isMemberGroupingEnabled() {
            return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupmembers");
        }
    }

    protected static class NamespaceGroupingAction
    extends Action {
        public NamespaceGroupingAction(AbstractCModelOutlinePage outlinePage) {
            super(ActionMessages.NamespacesGroupingAction_label);
            this.setDescription(ActionMessages.NamespacesGroupingAction_description);
            this.setToolTipText(ActionMessages.NamespacesGroupingAction_tooltip);
            this.setImageDescriptor(CDTSharedImages.getImageDescriptor("icons/tobj16/namespace_obj.png"));
            this.setDisabledImageDescriptor(CDTSharedImages.getImageDescriptor("icons/tobj16/namespace_obj.png"));
            boolean enabled = this.isNamspacesGroupingEnabled();
            this.setChecked(enabled);
        }

        public void run() {
            PreferenceConstants.getPreferenceStore().setValue("org.eclipse.cdt.ui.outline.groupnamespaces", this.isChecked());
        }

        public boolean isNamspacesGroupingEnabled() {
            return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupnamespaces");
        }
    }
}

