/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli;

import java.io.File;
import org.tizen.core.gputil.VersionUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.sbilib.for_cli.SBIAction;
import org.tizen.sbilib.for_cli.SBIExecute;
import org.tizen.sbilib.for_cli.SBIModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SBIParser {
    public static SBIModel parseBuildScript(String sbiBuildConfFile, String requireVersion) {
        String attr;
        Element elem;
        String name;
        Node inputNode;
        int i;
        String version;
        Document sbiDoc = XMLUtil.readXML((File)new File(sbiBuildConfFile));
        if (sbiDoc == null) {
            return null;
        }
        if (requireVersion != null && !requireVersion.isEmpty() && VersionUtil.compareVersion((String)(version = XMLUtil.getDOMValue((Document)sbiDoc, (String)"/sbi/@version")), (String)requireVersion) < 0) {
            return null;
        }
        SBIModel sbiModel = new SBIModel();
        NodeList inputNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/sbi/macros/input");
        for (i = 0; i < inputNodes.getLength(); ++i) {
            String method;
            inputNode = inputNodes.item(i);
            if (inputNode == null || !(inputNode instanceof Element) || (name = (elem = (Element)inputNode).getAttribute("name")) == null || (method = elem.getAttribute("method")) == null || method.isEmpty()) continue;
            String source = elem.getAttribute("source");
            String value = elem.getAttribute("value");
            String sep = elem.getAttribute("separator");
            String pr = elem.getAttribute("prefix");
            String sur = elem.getAttribute("surfix");
            attr = elem.getAttribute("attr");
            sbiModel.getMacro().addMacroOrigin(name, method, source, value, sep, pr, sur, attr);
        }
        inputNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/sbi/variables/input");
        for (i = 0; i < inputNodes.getLength(); ++i) {
            String value;
            inputNode = inputNodes.item(i);
            if (inputNode == null || !(inputNode instanceof Element) || (name = (elem = (Element)inputNode).getAttribute("name")) == null || name.isEmpty() || (value = elem.getAttribute("value")) == null || value.isEmpty()) continue;
            sbiModel.getMacro().addVariable(name, value);
        }
        NodeList actionNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/sbi/action");
        for (int i2 = 0; i2 < actionNodes.getLength(); ++i2) {
            Node action = actionNodes.item(i2);
            if (action == null || !(action instanceof Element)) continue;
            SBIAction act = new SBIAction();
            act.setName(((Element)action).getAttribute("name"));
            act.setCurDir(((Element)action).getAttribute("curdir"));
            NodeList execList = XMLUtil.getDOMNodes((Element)((Element)action), (String)"execute");
            for (int j = 0; j < execList.getLength(); ++j) {
                Node execNode = execList.item(j);
                if (execNode == null || !(execNode instanceof Element)) continue;
                String execPath = ((Element)execNode).getAttribute("exec");
                String curdir = ((Element)execNode).getAttribute("curdir");
                String orderStr = ((Element)execNode).getAttribute("order");
                attr = ((Element)execNode).getAttribute("attr");
                int order = 0;
                if (orderStr != null && !orderStr.isEmpty()) {
                    order = Integer.valueOf(orderStr);
                }
                String[] attrs = null;
                if (attr != null && !attr.isEmpty()) {
                    attrs = attr.split(",");
                }
                SBIExecute exec = new SBIExecute(execPath, curdir, order, attrs);
                NodeList paramList = XMLUtil.getDOMNodes((Element)((Element)execNode), (String)"param");
                for (int k = 0; k < paramList.getLength(); ++k) {
                    Node paramNode = paramList.item(k);
                    if (!(paramNode instanceof Element)) continue;
                    Element elem2 = (Element)paramNode;
                    String name2 = elem2.getAttribute("name");
                    String inputs = elem2.getAttribute("inputs");
                    String[] values = inputs.split(",");
                    String require = elem2.getAttribute("require");
                    exec.addParam(name2, values, require);
                }
                NodeList envList = XMLUtil.getDOMNodes((Element)((Element)execNode), (String)"env");
                for (int k = 0; k < envList.getLength(); ++k) {
                    String[] inputList;
                    String inputs;
                    Node envNode = envList.item(k);
                    if (!(envNode instanceof Element)) continue;
                    Element elem3 = (Element)envNode;
                    String type = elem3.getAttribute("type");
                    if (type == null || type.isEmpty()) {
                        String name3 = elem3.getAttribute("name");
                        String value = elem3.getAttribute("value");
                        String envAttrs = elem3.getAttribute("attr");
                        String separator = elem3.getAttribute("separator");
                        String require = elem3.getAttribute("require");
                        String value2 = null;
                        if (name3 == null) continue;
                        String[] attrList = null;
                        if (envAttrs != null) {
                            attrList = envAttrs.split(",");
                        }
                        exec.addEnv(name3, value2 != null ? value2 : value, separator, attrList, require);
                        continue;
                    }
                    if (!type.equals("batch") || (inputs = elem3.getAttribute("inputs")) == null) continue;
                    for (String input : inputList = inputs.split(",")) {
                        exec.addEnv(input, "${" + input + "}");
                    }
                }
                NodeList echoList = XMLUtil.getDOMNodes((Element)((Element)execNode), (String)"echo");
                for (int k = 0; k < echoList.getLength(); ++k) {
                    Node echoNode = echoList.item(k);
                    if (!(echoNode instanceof Element)) continue;
                    Element elem4 = (Element)echoNode;
                    String text = elem4.getAttribute("text");
                    exec.addEcho(text);
                }
                act.addExec(exec);
            }
            act.setMacro(sbiModel.getMacro());
            sbiModel.getActions().put(act.name, act);
        }
        NodeList scriptNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/sbi/script");
        for (int i3 = 0; i3 < scriptNodes.getLength(); ++i3) {
            Node script = scriptNodes.item(i3);
            if (script == null || !(script instanceof Element)) continue;
            String scriptText = script.getTextContent();
            sbiModel.getMacro().addScript(scriptText);
        }
        return sbiModel;
    }
}

