/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTBaseSpecifier
extends ASTNode
implements ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier,
ICPPASTCompletionContext {
    private boolean isVirtual;
    private int visibility;
    private ICPPASTNameSpecifier nameSpecifier;
    private boolean fIsPackExpansion;

    public CPPASTBaseSpecifier() {
    }

    public CPPASTBaseSpecifier(ICPPASTNameSpecifier nameSpecifier) {
        this.setNameSpecifier(nameSpecifier);
    }

    public CPPASTBaseSpecifier(ICPPASTNameSpecifier nameSpecifier, int visibility, boolean isVirtual) {
        this.isVirtual = isVirtual;
        this.visibility = visibility;
        this.setNameSpecifier(nameSpecifier);
    }

    @Override
    public CPPASTBaseSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTBaseSpecifier copy(IASTNode.CopyStyle style) {
        CPPASTBaseSpecifier copy = new CPPASTBaseSpecifier(this.nameSpecifier == null ? null : this.nameSpecifier.copy(style));
        copy.isVirtual = this.isVirtual;
        copy.visibility = this.visibility;
        copy.fIsPackExpansion = this.fIsPackExpansion;
        return this.copy(copy, style);
    }

    @Override
    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public void setVirtual(boolean value) {
        this.assertNotFrozen();
        this.isVirtual = value;
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(int visibility) {
        this.assertNotFrozen();
        this.visibility = visibility;
    }

    @Override
    @Deprecated
    public IASTName getName() {
        if (this.nameSpecifier instanceof IASTName) {
            return (IASTName)((Object)this.nameSpecifier);
        }
        throw new UnsupportedOperationException("Cannot call getName() on base-specifier whose name-specifier is not a name. Use getNameSpecifier() instead.");
    }

    @Override
    @Deprecated
    public void setName(IASTName name) {
        this.setNameSpecifier((ICPPASTName)name);
    }

    @Override
    public ICPPASTNameSpecifier getNameSpecifier() {
        return this.nameSpecifier;
    }

    @Override
    public void setNameSpecifier(ICPPASTNameSpecifier nameSpecifier) {
        this.assertNotFrozen();
        this.nameSpecifier = nameSpecifier;
        if (nameSpecifier != null) {
            nameSpecifier.setParent(this);
            nameSpecifier.setPropertyInParent(NAME_SPECIFIER);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitBaseSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.nameSpecifier != null && !this.nameSpecifier.accept(action)) {
            return false;
        }
        return !action.shouldVisitBaseSpecifiers || action.leave(this) != 2;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (this.nameSpecifier == n) {
            return 1;
        }
        return 3;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        IASTName className;
        IBinding binding;
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        ICPPClassType classType = null;
        if (this.getParent() instanceof CPPASTCompositeTypeSpecifier && (binding = (className = ((CPPASTCompositeTypeSpecifier)this.getParent()).getName()).resolveBinding()) instanceof ICPPClassType) {
            classType = (ICPPClassType)binding;
        }
        IBinding[] iBindingArray = bindings;
        int n2 = bindings.length;
        int n3 = 0;
        while (n3 < n2) {
            IBinding binding2 = iBindingArray[n3];
            if (binding2 instanceof IType) {
                IType type = (IType)((Object)binding2);
                while (type instanceof ITypedef || type instanceof ICPPAliasTemplate) {
                    IType iType = type = type instanceof ITypedef ? ((ITypedef)type).getType() : ((ICPPAliasTemplate)type).getType();
                }
                if (type instanceof ICPPClassType) {
                    int key = ((ICPPClassType)type).getKey();
                    if (!(key != 3 && key != 1 && !(type instanceof ICPPDeferredClassInstance) && !(type instanceof ICPPUnknownMemberClass) || classType != null && type.isSameType(classType))) {
                        filtered.add(binding2);
                    }
                } else if (type instanceof ICPPTemplateTypeParameter) {
                    filtered.add(binding2);
                }
            }
            ++n3;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }

    @Override
    public boolean isPackExpansion() {
        return this.fIsPackExpansion;
    }

    @Override
    public void setIsPackExpansion(boolean val) {
        this.assertNotFrozen();
        this.fIsPackExpansion = val;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }
}

