# PO build script


_FUNC_PO2MO = $(patsubst %.po,res/locale/%/LC_MESSAGES/$(2).mo,$(notdir $(1)))


# parameter :
#  $(1) - C/C++ soruce file
#  $(2) - output path
#  $(3) - app name
CONVERT_ESC_PO_TO_MO = $(2)/$(call CONVERT_4MAKE_TO_OUT,$(call _FUNC_PO2MO,$(1),$(3)))


# parameter :
#  $(1) - encoded one C/C++ soruce file
#  $(2) - output path
#  $(3) - app name
# output :
#  $(4) - output files list
define MO_BUILD_PROC_RAW
$(call CONVERT_ESC_PO_TO_MO,$(1),$(2),$(3)) : $(call DECODE_4MAKE,$(1))
	@echo '  Building file: $$<'
	@echo '  Invoking: msgfmt String Formatter'
#	$$(call MAKEDIRS,$$(@D))
	$$(call MAKEDIRS,$$(dir $$(subst $$(SPACE),\ ,$$@)))
	$$(MSGFMT) -o "$$@" "$$<"
	@echo '  Finished building: $$<'
$(4) += $(call CONVERT_ESC_PO_TO_MO,$(1),$(2),$(3))
endef

 
# parameter :
#  $(1) - output dir
#  $(2) - src paths
#  $(3) - app name
# output :
#  $(4) - OBJS 

define MO_PROC_RAW

_OUTPUT_DIR := $$(strip $(1))#
_SRCS := $$(strip $(2))#
_APPNAME := $(3)

ifneq ($$(strip $$(_SRCS)),)

#_ENC_SRCS := $$(call ENCODE_4MAKE,$$(_SRCS))
_ENC_SRCS := $$(subst $(BSLASH) ,\&sp\;,$$(_SRCS))

_NORMAL_SRCS := $$(filter-out %*.po,$$(_ENC_SRCS))
_WIDLCARD_SRCS0 := $$(filter %*.po,$$(_ENC_SRCS))

_WIDLCARD_SRCS0 := $$(foreach var,$$(_WIDLCARD_SRCS0),$$(call CHECK_NO_ABS,$$(var)))
_WIDLCARD_ABS_SRCS0 := $$(foreach var,$$(_WIDLCARD_SRCS0),$$(call CHECK_ABS,$$(var)))

_WIDLCARD_SRCS := $$(foreach var,$$(_WIDLCARD_SRCS0),$$(call FIND_FILES_4MAKE2,$$(_PROJ_DIR),$$(subst \&sp\;,$(BSLASH) ,$$(var))))
_WIDLCARD_ABS_SRCS := $$(foreach var,$$(_WIDLCARD_ABS_SRCS0),$$(call FIND_FILES_4MAKE2,$$(_PROJ_DIR),$$(subst \&sp\;,$(BSLASH) ,$$(var))))

_ALL_SRCS := $$(_NORMAL_SRCS) $$(_WIDLCARD_SRCS) $$(_WIDLCARD_ABS_SRCS)

ifneq ($$(strip $$(_ALL_SRCS)),)

#_ENC_SRCS := $$(call ENCODE_4MAKE,$$(_ALL_SRCS))
_ENC_SRCS := $$(subst $(BSLASH) ,\&sp\;,$$(_ALL_SRCS))

$$(foreach var,$$(_ENC_SRCS),$$(eval $$(call MO_BUILD_PROC_RAW,$$(var),$$(_OUTPUT_DIR),$$(_APPNAME),$(4))))

endif  # (_(strip _(_ALL_SRCS)),)

endif  # (_(strip _(_SRCS)),)

endef
