/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.editor;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.po.NativeLocaleMessageHandler;
import org.tizen.nativecommon.po.NativeLocaleMessageManager;
import org.tizen.nativecommon.rm.model.TizenLocale;

public class POFileContentAssist
implements ICompletionProposalComputer {
    private List<String> proposal = new ArrayList<String>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void sessionStarted() {
        this.proposal.add("_");
        this.proposal.add("i18n_get_text");
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof CContentAssistInvocationContext) {
            CContentAssistInvocationContext cContext = (CContentAssistInvocationContext)context;
            IASTCompletionNode completionNode = cContext.getCompletionNode();
            if (completionNode == null) {
                return Collections.emptyList();
            }
            String prefix = completionNode.getPrefix();
            if (this.isSupportProposal(prefix)) {
                return this.computeCompletionProposals(cContext, completionNode, prefix);
            }
        }
        return Collections.emptyList();
    }

    public boolean isSupportProposal(String prefix) {
        for (String str : this.proposal) {
            if (!str.equals(prefix) && !prefix.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    private List<ICompletionProposal> computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) {
        ArrayList<ICompletionProposal> retList = new ArrayList<ICompletionProposal>();
        Image image = CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getMacroImageDescriptor());
        IPath localePath = new Path(context.getProject().getLocationURI().getPath()).append("/res/po");
        IProject project = context.getProject().getProject();
        NativeLocaleMessageHandler poHandler = NativeLocaleMessageManager.getLocaleMessageHandler(project);
        String[] list = poHandler.getLocaleCodes();
        TizenLocale TL = TizenLocale.valueOf(list[0]);
        String[] ids = poHandler.getMsgIds(TL);
        localePath.toFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String type) {
                return type.endsWith(".po");
            }
        });
        int repOffset = context.getParseOffset();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            String assist = "(\"" + str + "\"";
            System.out.println(assist);
            retList.add((ICompletionProposal)new CCompletionProposal(assist, repOffset, assist.length(), image, "msgID: " + str, 1));
            ++n2;
        }
        return retList;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        ArrayList<IContextInformation> result = new ArrayList<IContextInformation>();
        return result;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

