/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch.ui;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.sdblib.IDevice;

public class TizenLaunchDeviceSelectionDialog
extends Dialog {
    int x = 0;
    int y = 0;
    private static final int width = 250;
    private static final int height = 250;
    private Table table;
    private IDevice selectedDevice = null;
    private IDevice[] deployableDevices;

    public TizenLaunchDeviceSelectionDialog(Shell parentShell, List<IDevice> devices) {
        this(parentShell, devices == null ? null : devices.toArray(new IDevice[0]));
    }

    public TizenLaunchDeviceSelectionDialog(Shell parentShell, IDevice[] devices) {
        super(parentShell);
        this.setShellStyle(96);
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - 250) / 2;
        this.y = bounds.y + bounds.height / 2;
        this.deployableDevices = devices;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select device to deploy");
        newShell.setLocation(this.x, this.y);
        newShell.setSize(250, 250);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createDeviceGroup(container);
        return container;
    }

    private void createDeviceGroup(Composite composite) {
        this.table = new Table(composite, 2052);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TizenLaunchDeviceSelectionDialog.this.selectedDevice = TizenLaunchDeviceSelectionDialog.this.deployableDevices[TizenLaunchDeviceSelectionDialog.this.table.getSelectionIndex()];
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData table_gd = new GridData(1808);
        table_gd.heightHint = 50;
        this.table.setLayoutData((Object)table_gd);
        this.createColumn(this.table, 0, "Serial Number", "Emulator-00000");
        this.createColumn(this.table, 0, "Name", "ABCDEFGHIJK");
        this.createItem(this.table);
    }

    private void createColumn(Table table, int style, String header, String sample) {
        TableColumn col = new TableColumn(table, style);
        col.setText(sample);
        col.pack();
        col.setText(header);
    }

    private void createItem(Table table) {
        IDevice[] iDeviceArray = this.deployableDevices;
        int n = this.deployableDevices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            TableItem item = new TableItem(table, 0);
            item.setText(0, device.getSerialNumber());
            item.setText(1, device.getDeviceName());
            ++n2;
        }
    }

    public IDevice getSelectedDevice() {
        return this.selectedDevice;
    }
}

