/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.tizen.nativecore.ext.manifest.DataControl;

public class UiDataControlDlg
extends SelectionStatusDialog {
    private Text fProviderIdText;
    private Button fSqlRadio;
    private Button fMapRadio;
    private Button fReadCheck;
    private Button fWriteCheck;
    private String fDefaultProviderID;
    private DataControl fDataControl;

    public UiDataControlDlg(String appName) {
        super(Display.getDefault().getActiveShell());
        appName = appName.replace(" ", "");
        this.fDefaultProviderID = "http://" + appName + ".com/datacontrol/provider/" + appName;
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
        this.setTitle("Add Data Control");
    }

    public void setInput(DataControl dataControl) {
        this.fDataControl = dataControl;
        this.setTitle("Edit Data Control");
    }

    public DataControl getDataControl() {
        return this.fDataControl;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 510;
        composite.setLayoutData((Object)gd);
        Label labelProvId = new Label(composite, 0);
        labelProvId.setText("Provider ID");
        GridData lgd = new GridData(768);
        lgd.widthHint = 135;
        labelProvId.setLayoutData((Object)lgd);
        this.fProviderIdText = new Text(composite, 2048);
        this.fProviderIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label labelType = new Label(composite, 0);
        labelType.setText("Type");
        labelType.setLayoutData((Object)lgd);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiDataControlDlg.this.validate();
            }
        };
        this.fSqlRadio = new Button(composite, 16);
        this.fSqlRadio.setText("SQL");
        this.fSqlRadio.addSelectionListener((SelectionListener)buttonListener);
        this.fMapRadio = new Button(composite, 16);
        this.fMapRadio.setText("Map");
        this.fMapRadio.addSelectionListener((SelectionListener)buttonListener);
        Label labelAccess = new Label(composite, 0);
        labelAccess.setText("Access rights");
        labelAccess.setLayoutData((Object)lgd);
        this.fReadCheck = new Button(composite, 32);
        this.fReadCheck.setText("Read");
        this.fReadCheck.addSelectionListener((SelectionListener)buttonListener);
        this.fWriteCheck = new Button(composite, 32);
        this.fWriteCheck.setText("Write");
        this.fWriteCheck.addSelectionListener((SelectionListener)buttonListener);
        if (this.fDataControl != null) {
            String v;
            this.fProviderIdText.setText(this.fDataControl.getProviderid());
            if (this.fDataControl.getType().equals("Sql")) {
                this.fSqlRadio.setSelection(true);
            }
            if (this.fDataControl.getType().equals("Map")) {
                this.fMapRadio.setSelection(true);
            }
            if ((v = this.fDataControl.getAccess()).equals("ReadOnly")) {
                this.fReadCheck.setSelection(true);
            } else if (v.equals("WriteOnly")) {
                this.fWriteCheck.setSelection(true);
            } else if (v.equals("ReadWrite")) {
                this.fReadCheck.setSelection(true);
                this.fWriteCheck.setSelection(true);
            }
        } else {
            this.fProviderIdText.setText(this.fDefaultProviderID);
        }
        this.fProviderIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiDataControlDlg.this.validate();
            }
        });
        this.validate();
        return composite;
    }

    private void validate() {
        this.computeResult();
        Status status = null;
        String value = this.fDataControl.getProviderid();
        if (value.isEmpty()) {
            status = new Status(4, "org.tizen.nativecore.misc", "Enter provider ID");
            this.updateStatus((IStatus)status);
            return;
        }
        value = this.fDataControl.getType();
        if (value == null || value.isEmpty()) {
            status = new Status(4, "org.tizen.nativecore.misc", "Select type");
            this.updateStatus((IStatus)status);
            return;
        }
        value = this.fDataControl.getAccess();
        if (value == null || value.isEmpty()) {
            status = new Status(4, "org.tizen.nativecore.misc", "Select access rights");
            this.updateStatus((IStatus)status);
            return;
        }
        if (this.fDataControl.getProviderid().startsWith("http://tizen.org")) {
            status = new Status(2, "org.tizen.nativecore.misc", "The specified provider ID requires the platform level signing key.");
        }
        if (status == null) {
            status = new Status(0, "org.tizen.nativecore.misc", null);
        }
        this.updateStatus((IStatus)status);
    }

    protected void computeResult() {
        if (this.fDataControl == null) {
            this.fDataControl = new DataControl();
        }
        this.fDataControl.setProviderid(this.fProviderIdText.getText());
        String value = "";
        if (this.fSqlRadio.getSelection()) {
            value = "Sql";
        } else if (this.fMapRadio.getSelection()) {
            value = "Map";
        }
        this.fDataControl.setType(value);
        value = "";
        if (this.fReadCheck.getSelection() && this.fWriteCheck.getSelection()) {
            value = "ReadWrite";
        } else if (this.fReadCheck.getSelection()) {
            value = "ReadOnly";
        } else if (this.fWriteCheck.getSelection()) {
            value = "WriteOnly";
        }
        this.fDataControl.setAccess(value);
    }
}

