/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.internal.ui.wizards.ICDTCommonProjectWizard;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.IWizardWithMemory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.core.application.tproject.TprojectHandler;
import org.tizen.common.ui.wizards.TizenCommonWizard;
import org.tizen.common.ui.wizards.model.Template;
import org.tizen.common.ui.wizards.online.ITizenWizardFileService;
import org.tizen.common.ui.wizards.online.TizenWizardFileServiceImpl;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;
import org.tizen.nativeappcommon.wizards.Messages;
import org.tizen.nativeappcommon.wizards.TizenMainWizardPage;
import org.tizen.nativeappcommon.wizards.TizenNativeWizardPerspectiveThread;
import org.tizen.nativeappcommon.wizards.model.TizenNativeTemplateExtensionPoint;
import org.tizen.nativeappcommon.wizards.model.TizenNativeTemplateModel;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.ResourceFilterDefines;
import org.tizen.nativecommon.templateengine.build.AbstractProjectGenerator;
import org.tizen.nativecommon.templateengine.model.TizenTemplate;
import org.w3c.dom.Element;

public abstract class TizenProjectWizard
extends TizenCommonWizard
implements IWizardWithMemory,
ICDTCommonProjectWizard {
    private final Logger logger = LoggerFactory.getLogger(TizenProjectWizard.class);
    private boolean styleSet = false;
    public static final String FILENAME_PROJECT_DESCRIPTION = ".project";
    public static final String FILENAME_C_PROJECT_DESCRIPTION = ".cproject";
    private URI locationPath;
    private String projectName;
    protected TizenNativeTemplateModel nativeTemplate;
    protected IWorkingSet[] workingSets;
    private ITizenWizardFileService metaFileService = new TizenWizardFileServiceImpl();
    protected String projectPkgName = "";
    private static final String PREFIX = "CProjectWizard";
    private static final String OP_ERROR = "CProjectWizard.op_error";
    private static final String title = CUIPlugin.getResourceString((String)"CProjectWizard.op_error.title");
    private static final String message = CUIPlugin.getResourceString((String)"CProjectWizard.op_error.message");
    private static final String[] EMPTY_ARR = new String[0];
    public static final String PAGE_NAME = "Tizen Native Project Wizard";
    protected TizenMainWizardPage fMainPage;
    protected IProject newProject;
    private String wz_title;
    private String wz_desc;
    private boolean existingPath = false;
    private String lastProjectName = null;
    private URI lastProjectLocation = null;
    private CWizardHandler savedHandler = null;
    protected IProgressMonitor continueCreationMonitor;

    protected abstract AbstractProjectGenerator getBuildFileGenerator();

    public abstract boolean postCreateJobProcess(IProgressMonitor var1);

    public TizenProjectWizard() {
        this(Messages.TizenProjectWizard_0, Messages.TizenProjectWizard_1);
    }

    public TizenProjectWizard(String title, String desc) {
        this.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(title);
        this.wz_title = title;
        this.wz_desc = desc;
    }

    public void addPages() {
        this.fMainPage = new TizenMainWizardPage(CUIPlugin.getResourceString((String)PREFIX));
        this.fMainPage.setTitle(this.wz_title);
        this.fMainPage.setDescription(this.wz_desc);
        this.addPage((IWizardPage)this.fMainPage);
    }

    protected TizenMainWizardPage getMainPage() {
        TizenMainWizardPage mainPage = (TizenMainWizardPage)this.getPage(PAGE_NAME);
        if (mainPage == null) {
            mainPage = this.fMainPage;
        }
        return mainPage;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        if (!this.styleSet && wizardContainer instanceof Window) {
            Window container = (Window)wizardContainer;
            Class<Window> containerClass = Window.class;
            Class[] setShellStyleParam = new Class[]{Integer.TYPE};
            Method setShellStyle = null;
            Method getShellStyle = null;
            try {
                setShellStyle = containerClass.getDeclaredMethod("setShellStyle", setShellStyleParam);
                getShellStyle = containerClass.getDeclaredMethod("getShellStyle", new Class[0]);
            }
            catch (Exception e) {
                this.logger.error(Messages.TizenProjectWizard_Exception_METHOD_GET_EXCEPTION, (Throwable)e);
                super.setContainer(wizardContainer);
                return;
            }
            setShellStyle.setAccessible(true);
            getShellStyle.setAccessible(true);
            try {
                int style = (Integer)getShellStyle.invoke((Object)container, new Object[0]);
                style = style & 0xFFFEFFFF | 0x8000;
                setShellStyle.invoke((Object)container, style);
            }
            catch (Exception e) {
                this.logger.error(Messages.TizenProjectWizard_Exception_METHOD_INVOKE_EXCEPTION, (Throwable)e);
                super.setContainer(wizardContainer);
                return;
            }
            this.styleSet = true;
        }
        super.setContainer(wizardContainer);
    }

    public String[] getNatures() {
        return new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature"};
    }

    protected IProject continueCreation(IProject prj) {
        if (this.continueCreationMonitor == null) {
            this.continueCreationMonitor = new NullProgressMonitor();
        }
        try {
            try {
                this.continueCreationMonitor.beginTask(Messages.TizenProjectWizard_2, 1);
                CProjectNature.addCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
                CCProjectNature.addCCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
            }
            catch (CoreException e) {
                this.logger.error("Failed to add natures", (Throwable)e);
                this.continueCreationMonitor.done();
            }
        }
        finally {
            this.continueCreationMonitor.done();
        }
        return prj;
    }

    public String[] getContentTypeIDs() {
        return new String[]{"org.eclipse.cdt.core.cxxSource", "org.eclipse.cdt.core.cxxHeader"};
    }

    public boolean performFinish() {
        try {
            this.locationPath = this.getMainPage().getProjectLocation();
            this.projectName = this.getMainPage().getProjectName();
            this.setCreated();
        }
        catch (Exception e) {
            this.logger.error("Failed to call setCreated()", (Throwable)e);
        }
        IIndexManager fManager = CCorePlugin.getIndexManager();
        fManager.removeIndexerSetupParticipant(null);
        return super.performFinish();
    }

    protected TizenTemplate getTizenTemplate(String samplePath, String projectName, String projectLocation) {
        return new TizenTemplate(samplePath, projectName, projectLocation);
    }

    private boolean isChanged() {
        if (this.savedHandler != this.fMainPage.h_selected) {
            return true;
        }
        if (!this.fMainPage.getProjectName().equals(this.lastProjectName)) {
            return true;
        }
        URI projectLocation = this.fMainPage.getProjectLocation();
        if (projectLocation == null ? this.lastProjectLocation != null : !projectLocation.equals(this.lastProjectLocation)) {
            return true;
        }
        return this.savedHandler.isChanged();
    }

    public IProject getProject(boolean defaults) {
        return this.getProject(defaults, true);
    }

    public IProject getProject(boolean defaults, boolean onFinish) {
        if (this.newProject != null && this.isChanged()) {
            this.clearProject();
        }
        if (this.newProject == null) {
            TizenMainWizardPage mainPage;
            block8: {
                block9: {
                    IFileStore fs;
                    this.existingPath = false;
                    mainPage = this.getMainPage();
                    URI p = mainPage.getProjectLocation();
                    if (p == null) {
                        fs = EFS.getStore((URI)ResourcesPlugin.getWorkspace().getRoot().getLocationURI());
                        fs = fs.getChild(mainPage.getProjectName());
                    } else {
                        fs = EFS.getStore((URI)p);
                    }
                    IFileInfo f = fs.fetchInfo();
                    if (!f.exists() || !f.isDirectory()) break block8;
                    if (!fs.getChild(FILENAME_PROJECT_DESCRIPTION).fetchInfo().exists() || MessageDialog.openConfirm((Shell)this.getShell(), (String)"Old project will be overridden", (String)"Existing project settings will be overridden.\nImport feature can be used instead to preserve old settings.\nOK to override ?")) break block9;
                    return null;
                }
                try {
                    this.existingPath = true;
                }
                catch (CoreException e) {
                    CUIPlugin.log((IStatus)e.getStatus());
                }
            }
            this.savedHandler = mainPage.h_selected;
            if (this.savedHandler != null) {
                this.savedHandler.saveState();
            }
            this.lastProjectName = mainPage.getProjectName();
            this.lastProjectLocation = mainPage.getProjectLocation();
            this.invokeRunnable(this.getRunnable(defaults, onFinish));
        }
        return this.newProject;
    }

    private void clearProject() {
        if (this.lastProjectName == null) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(this.lastProjectName).delete(!this.existingPath, true, null);
        }
        catch (CoreException coreException) {}
        this.newProject = null;
        this.lastProjectName = null;
        this.lastProjectLocation = null;
    }

    private boolean invokeRunnable(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            CUIPlugin.errorDialog((Shell)this.getShell(), (String)title, (String)message, (Throwable)e.getTargetException(), (boolean)true);
            this.clearProject();
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.clearProject();
            return false;
        }
        return true;
    }

    public boolean performFinishInCDT() {
        boolean needsPost = this.newProject != null && !this.isChanged();
        TizenMainWizardPage mainPage = this.getMainPage();
        if (this.getProject(mainPage.isCurrent(), true) == null) {
            return false;
        }
        mainPage.h_selected.postProcess(this.newProject, needsPost);
        try {
            this.setCreated();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        this.updatePerspective(mainPage.getSelectedSampleLocation());
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    protected void updatePerspective(IPath samplePath) {
        TemplateDescriptor desc;
        if (samplePath != null && (desc = TizenTemplateProcessParser.createTemplateDesc(samplePath.toFile())) != null) {
            Element root = desc.getRootElement();
            Element slpPropertyElement = TizenTemplateProcessParser.getElementFromTag(root, "slp-property");
            Element propertyGroupElement = TizenTemplateProcessParser.getElementFromTag(slpPropertyElement, "property-group");
            List<Element> extraTypeElements = TizenTemplateProcessParser.getElementsFromTag(propertyGroupElement, "extra-type");
            String customPerspective = null;
            TizenNativeTemplateExtensionPoint extensionPoint = new TizenNativeTemplateExtensionPoint();
            for (Element element : extraTypeElements) {
                String extraType = element.getTextContent();
                IConfigurationElement matchedExtraElement = extensionPoint.getFirstMatchedExtraElementByType(extraType);
                customPerspective = extensionPoint.getFinalPerspectiveFromExtraElement(matchedExtraElement);
                if (customPerspective == null) continue;
                this.logger.debug("Selected {} extra-type from extension-point: {}", (Object)extraType, (Object)matchedExtraElement.getContributor());
                break;
            }
            if (customPerspective != null) {
                try {
                    this.logger.debug("Change perspective to {}", customPerspective);
                    PlatformUI.getWorkbench().showPerspective(customPerspective, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    return;
                }
                catch (WorkbenchException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
    }

    protected boolean setCreated() throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(this.newProject, false);
        if (des == null) {
            return false;
        }
        if (des.isCdtProjectCreating()) {
            des = mngr.getProjectDescription(this.newProject, true);
            des.setCdtProjectCreated();
            mngr.setProjectDescription(this.newProject, des, false, null);
            return true;
        }
        return false;
    }

    private IRunnableWithProgress getRunnable(boolean _defaults, final boolean onFinish) {
        final boolean defaults = _defaults;
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor imonitor) throws InvocationTargetException, InterruptedException {
                final Exception[] except = new Exception[1];
                TizenProjectWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                Object fMonitor = monitor == null ? new NullProgressMonitor() : monitor;
                                fMonitor.beginTask(CUIPlugin.getResourceString((String)"CProjectWizard.op_description"), 100);
                                fMonitor.worked(10);
                                try {
                                    try {
                                        ((this).this).TizenProjectWizard.this.newProject = TizenProjectWizard.this.createIProject(TizenProjectWizard.this.lastProjectName, TizenProjectWizard.this.lastProjectLocation, (IProgressMonitor)new SubProgressMonitor(fMonitor, 40));
                                        if (((this).this).TizenProjectWizard.this.newProject != null) {
                                            TizenProjectWizard.this.createTProject(((this).this).TizenProjectWizard.this.newProject);
                                            TizenMainWizardPage mainPage = TizenProjectWizard.this.getMainPage();
                                            mainPage.h_selected.createProject(((this).this).TizenProjectWizard.this.newProject, defaults, onFinish, (IProgressMonitor)new SubProgressMonitor(fMonitor, 40));
                                        }
                                        fMonitor.worked(10);
                                    }
                                    catch (CoreException e) {
                                        CUIPlugin.log((Throwable)e);
                                        fMonitor.done();
                                    }
                                }
                                finally {
                                    fMonitor.done();
                                }
                            }
                        });
                        try {
                            TizenProjectWizard.this.getContainer().run(false, true, (IRunnableWithProgress)op);
                        }
                        catch (InvocationTargetException e) {
                            except[0] = e;
                        }
                        catch (InterruptedException e) {
                            except[0] = e;
                        }
                    }
                });
                if (except[0] != null) {
                    if (except[0] instanceof InvocationTargetException) {
                        throw (InvocationTargetException)except[0];
                    }
                    if (except[0] instanceof InterruptedException) {
                        throw (InterruptedException)except[0];
                    }
                    throw new InvocationTargetException(except[0]);
                }
            }
        };
    }

    public IProject createIProject(String name, URI location) throws CoreException {
        return this.createIProject(name, location, (IProgressMonitor)new NullProgressMonitor());
    }

    public IProject createIProject(String name, URI location, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating .project file", 100);
        if (this.newProject != null) {
            return this.newProject;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject newProjectHandle = root.getProject(name);
        if (!newProjectHandle.exists()) {
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            if (location != null) {
                description.setLocationURI(location);
            }
            this.newProject = CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
        } else {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            this.newProject = newProjectHandle;
        }
        if (!this.newProject.isOpen()) {
            this.newProject.open((IProgressMonitor)new SubProgressMonitor(monitor, 25));
        }
        this.continueCreationMonitor = new SubProgressMonitor(monitor, 25);
        IProject proj = this.continueCreation(this.newProject);
        monitor.done();
        return proj;
    }

    public void createTProject(IProject project) {
        TprojectHandler handler = new TprojectHandler(project);
        TizenProjectDescription desc = new TizenProjectDescription(project);
        TizenMainWizardPage mainPage = this.getMainPage();
        desc.setPlatform(mainPage.getSelectedTemplate().getProfileInfo());
        handler.marshal(desc);
    }

    public String getLastProjectName() {
        return this.lastProjectName;
    }

    public URI getLastProjectLocation() {
        return this.lastProjectLocation;
    }

    public IProject getLastProject() {
        return this.newProject;
    }

    public String[] getLanguageIDs() {
        String[] contentTypeIds = this.getContentTypeIDs();
        if (contentTypeIds.length > 0) {
            IContentTypeManager manager = Platform.getContentTypeManager();
            ArrayList<String> languageIDs = new ArrayList<String>();
            int i = 0;
            while (i < contentTypeIds.length) {
                ILanguage language;
                IContentType contentType = manager.getContentType(contentTypeIds[i]);
                if (contentType != null && (language = LanguageManager.getInstance().getLanguage(contentType)) != null && !languageIDs.contains(language.getId())) {
                    languageIDs.add(language.getId());
                }
                ++i;
            }
            return languageIDs.toArray(new String[languageIDs.size()]);
        }
        return EMPTY_ARR;
    }

    public String[] getExtensions() {
        String[] contentTypeIds = this.getContentTypeIDs();
        if (contentTypeIds.length > 0) {
            IContentTypeManager manager = Platform.getContentTypeManager();
            ArrayList<String> extensions = new ArrayList<String>();
            int i = 0;
            while (i < contentTypeIds.length) {
                IContentType contentType = manager.getContentType(contentTypeIds[i]);
                if (contentType != null) {
                    String[] thisTypeExtensions = contentType.getFileSpecs(8);
                    extensions.addAll(Arrays.asList(thisTypeExtensions));
                }
                ++i;
            }
            return extensions.toArray(new String[extensions.size()]);
        }
        return EMPTY_ARR;
    }

    protected WorkspaceJob createFinishJob() {
        return new WorkspaceJob("Creating native project"){

            /*
             * Unable to fully structure code
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                block96: {
                    block95: {
                        block94: {
                            block93: {
                                block92: {
                                    block91: {
                                        block90: {
                                            block89: {
                                                mainPage = TizenProjectWizard.this.getMainPage();
                                                createSubMonitor = null;
                                                configSubMonitor = null;
                                                postSubMonitor = null;
                                                isCanceled = false;
                                                totalTicks = 1000;
                                                monitor.beginTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_START, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)), totalTicks);
                                                if (!monitor.isCanceled()) break block89;
                                                TizenProjectWizard.access$7(TizenProjectWizard.this, TizenProjectWizard.this.newProject);
                                                isCanceled = true;
                                                var13_10 = Status.CANCEL_STATUS;
                                                try {
                                                    TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                                                }
                                                catch (IOException v0) {
                                                    TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                                                }
                                                if (createSubMonitor != null) {
                                                    createSubMonitor.done();
                                                }
                                                if (configSubMonitor != null) {
                                                    configSubMonitor.done();
                                                }
                                                if (postSubMonitor != null) {
                                                    postSubMonitor.done();
                                                }
                                                monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                                                monitor.worked(20);
                                                monitor.done();
                                                if (!isCanceled) {
                                                    TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                                                    new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                                                }
                                                return var13_10;
                                            }
                                            monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_CHECK_PATH, (Object)TizenProjectWizard.this.nativeTemplate.getName()));
                                            monitor.worked(100);
                                            TizenProjectWizard.access$2(TizenProjectWizard.this).getDownloadToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                                            v1 = needsPost = TizenProjectWizard.this.newProject != null && TizenProjectWizard.access$8(TizenProjectWizard.this) == false;
                                            if (TizenProjectWizard.this.newProject != null && TizenProjectWizard.access$8(TizenProjectWizard.this)) {
                                                TizenProjectWizard.access$9(TizenProjectWizard.this);
                                            }
                                            TizenProjectWizard.access$10(TizenProjectWizard.this, false);
                                            if (TizenProjectWizard.access$11(TizenProjectWizard.this) == null) {
                                                fs = EFS.getStore((URI)ResourcesPlugin.getWorkspace().getRoot().getLocationURI());
                                                fs = fs.getChild(TizenProjectWizard.access$4(TizenProjectWizard.this));
                                            } else {
                                                fs = EFS.getStore((URI)TizenProjectWizard.access$11(TizenProjectWizard.this));
                                            }
                                            f = fs.fetchInfo();
                                            if (!f.exists() || !f.isDirectory()) ** GOTO lbl69
                                            if (!fs.getChild(".project").fetchInfo().exists() || MessageDialog.openConfirm((Shell)TizenProjectWizard.this.getShell(), (String)"Old project will be overridden", (String)"Existing project settings will be overridden.\nImport feature can be used instead to preserve old settings.\nOK to override ?")) break block90;
                                            try {
                                                TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                                            }
                                            catch (IOException v2) {
                                                TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                                            }
                                            if (createSubMonitor != null) {
                                                createSubMonitor.done();
                                            }
                                            if (configSubMonitor != null) {
                                                configSubMonitor.done();
                                            }
                                            if (postSubMonitor != null) {
                                                postSubMonitor.done();
                                            }
                                            monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                                            monitor.worked(20);
                                            monitor.done();
                                            if (!isCanceled) {
                                                TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                                                new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                                            }
                                            return null;
                                        }
                                        TizenProjectWizard.access$10(TizenProjectWizard.this, true);
lbl69:
                                        // 2 sources

                                        TizenProjectWizard.access$12(TizenProjectWizard.this, mainPage.h_selected);
                                        TizenProjectWizard.access$13(TizenProjectWizard.this, TizenProjectWizard.access$4(TizenProjectWizard.this));
                                        TizenProjectWizard.access$14(TizenProjectWizard.this, TizenProjectWizard.access$11(TizenProjectWizard.this));
                                        if (!monitor.isCanceled()) break block91;
                                        TizenProjectWizard.access$7(TizenProjectWizard.this, TizenProjectWizard.this.newProject);
                                        isCanceled = true;
                                        var13_11 = Status.CANCEL_STATUS;
                                        try {
                                            TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                                        }
                                        catch (IOException v3) {
                                            TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                                        }
                                        if (createSubMonitor != null) {
                                            createSubMonitor.done();
                                        }
                                        if (configSubMonitor != null) {
                                            configSubMonitor.done();
                                        }
                                        if (postSubMonitor != null) {
                                            postSubMonitor.done();
                                        }
                                        monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                                        monitor.worked(20);
                                        monitor.done();
                                        if (!isCanceled) {
                                            TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                                            new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                                        }
                                        return var13_11;
                                    }
                                    monitor.subTask(Messages.NATIVE_PROJECT_CREATE_MONITOR_CREATE_CONFIG);
                                    monitor.worked(100);
                                    configSubMonitor = new SubProgressMonitor(monitor, 100);
                                    TizenProjectWizard.this.newProject = TizenProjectWizard.this.createIProject(TizenProjectWizard.access$0(TizenProjectWizard.this), TizenProjectWizard.access$1(TizenProjectWizard.this), (IProgressMonitor)configSubMonitor);
                                    if (TizenProjectWizard.this.newProject != null) break block92;
                                    var13_12 = Status.CANCEL_STATUS;
                                    try {
                                        TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                                    }
                                    catch (IOException v4) {
                                        TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                                    }
                                    if (createSubMonitor != null) {
                                        createSubMonitor.done();
                                    }
                                    if (configSubMonitor != null) {
                                        configSubMonitor.done();
                                    }
                                    if (postSubMonitor != null) {
                                        postSubMonitor.done();
                                    }
                                    monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                                    monitor.worked(20);
                                    monitor.done();
                                    if (!isCanceled) {
                                        TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                                        new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                                    }
                                    return var13_12;
                                }
                                TizenProjectWizard.this.createTProject(TizenProjectWizard.this.newProject);
                                if (!monitor.isCanceled()) break block93;
                                TizenProjectWizard.access$7(TizenProjectWizard.this, TizenProjectWizard.this.newProject);
                                isCanceled = true;
                                var13_13 = Status.CANCEL_STATUS;
                                try {
                                    TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                                }
                                catch (IOException v5) {
                                    TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                                }
                                if (createSubMonitor != null) {
                                    createSubMonitor.done();
                                }
                                if (configSubMonitor != null) {
                                    configSubMonitor.done();
                                }
                                if (postSubMonitor != null) {
                                    postSubMonitor.done();
                                }
                                monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                                monitor.worked(20);
                                monitor.done();
                                if (!isCanceled) {
                                    TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                                    new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                                }
                                return var13_13;
                            }
                            monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_CREATE_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                            monitor.worked(100);
                            createSubMonitor = new SubProgressMonitor(monitor, 300);
                            mainPage.h_selected.createProject(TizenProjectWizard.this.newProject, mainPage.isCurrent(), true, (IProgressMonitor)createSubMonitor);
                            mainPage.h_selected.postProcess(TizenProjectWizard.this.newProject, needsPost);
                            if (!monitor.isCanceled()) break block94;
                            TizenProjectWizard.access$7(TizenProjectWizard.this, TizenProjectWizard.this.newProject);
                            isCanceled = true;
                            var13_14 = Status.CANCEL_STATUS;
                            try {
                                TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                            }
                            catch (IOException v6) {
                                TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                            }
                            if (createSubMonitor != null) {
                                createSubMonitor.done();
                            }
                            if (configSubMonitor != null) {
                                configSubMonitor.done();
                            }
                            if (postSubMonitor != null) {
                                postSubMonitor.done();
                            }
                            monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                            monitor.worked(20);
                            monitor.done();
                            if (!isCanceled) {
                                TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                                new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                            }
                            return var13_14;
                        }
                        monitor.subTask(Messages.NATIVE_PROJECT_CREATE_MONITOR_ADD_WORKINGSET);
                        monitor.worked(100);
                        TizenProjectWizard.this.setCreated();
                        if (TizenProjectWizard.this.newProject != null) {
                            ProjectUtil.enableProjectAutoBuild((IProject)TizenProjectWizard.this.newProject, (boolean)true);
                        }
                        ProjectUtil.addFilter((IProject)TizenProjectWizard.this.newProject, (ResourceFilterDefines)ResourceFilterDefines.TPK_FOLDER);
                        ProjectUtil.addFilter((IProject)TizenProjectWizard.this.newProject, (ResourceFilterDefines)ResourceFilterDefines.PROJECT_DEF_FILE);
                        TizenProjectWizard.access$15(TizenProjectWizard.this, TizenProjectWizard.this.workingSets, TizenProjectWizard.this.newProject);
                        if (!monitor.isCanceled()) break block95;
                        TizenProjectWizard.access$7(TizenProjectWizard.this, TizenProjectWizard.this.newProject);
                        isCanceled = true;
                        var13_15 = Status.CANCEL_STATUS;
                        try {
                            TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                        }
                        catch (IOException v7) {
                            TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                        }
                        if (createSubMonitor != null) {
                            createSubMonitor.done();
                        }
                        if (configSubMonitor != null) {
                            configSubMonitor.done();
                        }
                        if (postSubMonitor != null) {
                            postSubMonitor.done();
                        }
                        monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                        monitor.worked(20);
                        monitor.done();
                        if (!isCanceled) {
                            TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                            new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                        }
                        return var13_15;
                    }
                    monitor.subTask(Messages.NATIVE_PROJECT_CREATE_MONITOR_SAVE_BUILDINFO);
                    monitor.worked(100);
                    postSubMonitor = new SubProgressMonitor(monitor, 100);
                    isChecked = TizenProjectWizard.this.postCreateJobProcess((IProgressMonitor)postSubMonitor);
                    if (isChecked) break block96;
                    TizenProjectWizard.access$7(TizenProjectWizard.this, TizenProjectWizard.this.newProject);
                    isCanceled = true;
                    var13_16 = Status.CANCEL_STATUS;
                    try {
                        TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                    }
                    catch (IOException v8) {
                        TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                    }
                    if (createSubMonitor != null) {
                        createSubMonitor.done();
                    }
                    if (configSubMonitor != null) {
                        configSubMonitor.done();
                    }
                    if (postSubMonitor != null) {
                        postSubMonitor.done();
                    }
                    monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                    monitor.worked(20);
                    monitor.done();
                    if (!isCanceled) {
                        TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                        new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                    }
                    return var13_16;
                    catch (CoreException e) {
                        CUIPlugin.log((IStatus)e.getStatus());
                        TizenProjectWizard.access$3(TizenProjectWizard.this).error(NLS.bind((String)Messages.TizenProjectWizard_Exception_Creating_Project, (Object)TizenProjectWizard.this.newProject.getName()), (Throwable)e);
                        TizenProjectWizard.access$7(TizenProjectWizard.this, TizenProjectWizard.this.newProject);
                        isCanceled = true;
                        var13_17 = new Status(4, "org.tizen.nativeappcommon", Messages.NATIVE_PROJECT_CREATE_MONITOR_ERROR, (Throwable)e);
                        try {
                            TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                        }
                        catch (IOException v9) {
                            TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                        }
                        if (createSubMonitor != null) {
                            createSubMonitor.done();
                        }
                        if (configSubMonitor != null) {
                            configSubMonitor.done();
                        }
                        if (postSubMonitor != null) {
                            postSubMonitor.done();
                        }
                        monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                        monitor.worked(20);
                        monitor.done();
                        if (!isCanceled) {
                            TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                            new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                        }
                        return var13_17;
                    }
                    catch (IOException e) {
                        TizenProjectWizard.access$3(TizenProjectWizard.this).error(NLS.bind((String)Messages.TizenProjectWizard_Exception_Creating_Project, (Object)TizenProjectWizard.this.newProject.getName()), (Throwable)e);
                        TizenProjectWizard.access$7(TizenProjectWizard.this, TizenProjectWizard.this.newProject);
                        isCanceled = true;
                        var13_18 = new Status(4, "org.tizen.nativeappcommon", Messages.NATIVE_PROJECT_CREATE_MONITOR_ERROR, (Throwable)e);
                        {
                            catch (Throwable var12_23) {
                                try {
                                    TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                                }
                                catch (IOException v10) {
                                    TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                                }
                                if (createSubMonitor != null) {
                                    createSubMonitor.done();
                                }
                                if (configSubMonitor != null) {
                                    configSubMonitor.done();
                                }
                                if (postSubMonitor != null) {
                                    postSubMonitor.done();
                                }
                                monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                                monitor.worked(20);
                                monitor.done();
                                if (!isCanceled) {
                                    TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                                    new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                                }
                                throw var12_23;
                            }
                        }
                        try {
                            TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                        }
                        catch (IOException v11) {
                            TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                        }
                        if (createSubMonitor != null) {
                            createSubMonitor.done();
                        }
                        if (configSubMonitor != null) {
                            configSubMonitor.done();
                        }
                        if (postSubMonitor != null) {
                            postSubMonitor.done();
                        }
                        monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                        monitor.worked(20);
                        monitor.done();
                        if (!isCanceled) {
                            TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                            new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                        }
                        return var13_18;
                    }
                }
                try {
                    TizenProjectWizard.access$2(TizenProjectWizard.this).deleteLocalSampleToCreateProject((Template)TizenProjectWizard.this.nativeTemplate);
                }
                catch (IOException v12) {
                    TizenProjectWizard.access$3(TizenProjectWizard.this).warn("Failed to delete the sample" + TizenProjectWizard.this.nativeTemplate.getLocalSamplePath().toOSString());
                }
                if (createSubMonitor != null) {
                    createSubMonitor.done();
                }
                if (configSubMonitor != null) {
                    configSubMonitor.done();
                }
                if (postSubMonitor != null) {
                    postSubMonitor.done();
                }
                monitor.subTask(NLS.bind((String)Messages.NATIVE_PROJECT_CREATE_MONITOR_FINISH_PROJECT, (Object)TizenProjectWizard.access$4(TizenProjectWizard.this)));
                monitor.worked(20);
                monitor.done();
                if (!isCanceled) {
                    TizenProjectWizard.access$5(TizenProjectWizard.this, (IResource)TizenProjectWizard.this.newProject);
                    new TizenNativeWizardPerspectiveThread().updatePerspective(TizenProjectWizard.access$6(TizenProjectWizard.this), mainPage.getSelectedSampleLocation());
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void deleteProject(IProject project) {
        try {
            if (project != null && project.exists()) {
                project.delete(true, true, null);
            }
        }
        catch (CoreException e) {
            this.logger.error("Failed to delete a project", (Throwable)e);
        }
    }

    static /* synthetic */ ITizenWizardFileService access$2(TizenProjectWizard tizenProjectWizard) {
        return tizenProjectWizard.metaFileService;
    }

    static /* synthetic */ Logger access$3(TizenProjectWizard tizenProjectWizard) {
        return tizenProjectWizard.logger;
    }

    static /* synthetic */ String access$4(TizenProjectWizard tizenProjectWizard) {
        return tizenProjectWizard.projectName;
    }

    static /* synthetic */ void access$5(TizenProjectWizard tizenProjectWizard, IResource iResource) {
        tizenProjectWizard.selectAndReveal(iResource);
    }

    static /* synthetic */ IConfigurationElement access$6(TizenProjectWizard tizenProjectWizard) {
        return tizenProjectWizard.fConfigElement;
    }

    static /* synthetic */ void access$7(TizenProjectWizard tizenProjectWizard, IProject iProject) {
        tizenProjectWizard.deleteProject(iProject);
    }

    static /* synthetic */ boolean access$8(TizenProjectWizard tizenProjectWizard) {
        return tizenProjectWizard.isChanged();
    }

    static /* synthetic */ void access$9(TizenProjectWizard tizenProjectWizard) {
        tizenProjectWizard.clearProject();
    }

    static /* synthetic */ void access$10(TizenProjectWizard tizenProjectWizard, boolean bl) {
        tizenProjectWizard.existingPath = bl;
    }

    static /* synthetic */ URI access$11(TizenProjectWizard tizenProjectWizard) {
        return tizenProjectWizard.locationPath;
    }

    static /* synthetic */ void access$12(TizenProjectWizard tizenProjectWizard, CWizardHandler cWizardHandler) {
        tizenProjectWizard.savedHandler = cWizardHandler;
    }

    static /* synthetic */ void access$13(TizenProjectWizard tizenProjectWizard, String string) {
        tizenProjectWizard.lastProjectName = string;
    }

    static /* synthetic */ void access$14(TizenProjectWizard tizenProjectWizard, URI uRI) {
        tizenProjectWizard.lastProjectLocation = uRI;
    }

    static /* synthetic */ void access$15(TizenProjectWizard tizenProjectWizard, IWorkingSet[] iWorkingSetArray, IProject iProject) {
        tizenProjectWizard.addToWorkingSets(iWorkingSetArray, iProject);
    }
}

