/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.nativecommon.ProjectUtil;

public class TizenLaunchInfo {
    private static final Logger logger = LoggerFactory.getLogger(TizenLaunchInfo.class);

    public static List<DeltaResourceInfo> makeInterestList(IProject project) {
        TizenPackageInfoStore store = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)project).getTizenPkgInfoStore();
        return store.getInterestList();
    }

    private static DeltaResourceInfo getBinaryDeltaResourceInfo(IProject project) {
        TizenProjectType tProjectType = ProjectUtil.getTizenProjectType(project);
        String binaryName = ProjectUtil.getBinaryName(project);
        String buildConfName = ProjectUtil.getDefaultConfiguration(project).getName();
        String hostBinary = "/" + buildConfName + "/" + binaryName;
        String remoteBinary = "";
        remoteBinary = TizenProjectType.TIZEN_C_IME_APPLICATION.equals((Object)tProjectType) ? "/lib/" + binaryName : "/bin/" + binaryName;
        return new DeltaResourceInfo(hostBinary, remoteBinary);
    }

    public static List<DeltaResourceInfo> makeIgnoreList(IProject project) {
        ArrayList<DeltaResourceInfo> ignoreList = new ArrayList<DeltaResourceInfo>();
        ignoreList.add(new DeltaResourceInfo("/" + SigningPathUtil.getSignatureDirectory() + ".manifest.tmp"));
        TizenPackageInfoStore store = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)project).getTizenPkgInfoStore();
        ignoreList.addAll(store.getIgnoreList());
        return ignoreList;
    }

    public static DeltaResourceInfo makeSubAppBinaryInterest(IProject project) {
        String artefactName = ProjectUtil.getArtefactName(project);
        String hostBinary = "/" + ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration().getName() + "/" + artefactName + ".exe";
        String remoteBinary = "/bin/" + artefactName + ".exe";
        return new DeltaResourceInfo(String.valueOf(artefactName) + ".exe", hostBinary, remoteBinary, null, -1, project.getName());
    }
}

