/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import org.tizen.nativecore.ext.manifest.IPrivilege;
import org.tizen.nativecore.misc.core.PrivilegeLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ProviderPrivilege
implements IPrivilege {
    private String value;
    private PrivilegeLevel privLevel;
    private String description;
    private String licenseFile;
    private final String ELEMENT_PROVIDER = "appdefined-privilege";

    public ProviderPrivilege() {
        this.privLevel = PrivilegeLevel.APP_DEFINED_PROVIDER;
        this.licenseFile = "";
        this.description = "";
        this.value = "";
    }

    public ProviderPrivilege(String value, PrivilegeLevel level, String desc, String licenseFile) {
        this.value = value;
        this.privLevel = level;
        this.description = desc;
        this.licenseFile = licenseFile;
    }

    @Override
    public void loadElement(Element element) {
        Node node;
        String attr;
        if (!element.getNodeName().equals("appdefined-privilege")) {
            return;
        }
        this.setValue(element.getTextContent());
        this.setDescription("[App-defined-provider] " + element.getTextContent());
        NamedNodeMap attrs = element.getAttributes();
        if (attrs.getLength() > 0 && (attr = (node = attrs.item(0)).getNodeName()).equals("license")) {
            this.setLicenseFile(node.getNodeValue());
        }
    }

    @Override
    public void generateElement(Document dom, Element parent, PrivilegeLevel level) {
        Element element = dom.createElement("appdefined-privilege");
        parent.appendChild(element);
        if (this.getValue() != null && this.getValue().length() > 0) {
            element.setTextContent(this.getValue());
        }
        if (!this.licenseFile.isEmpty()) {
            element.setAttribute("license", this.licenseFile);
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String textContent) {
        this.value = textContent;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public void setLicenseFile(String fileName) {
        this.licenseFile = fileName;
    }

    public void setLevel(PrivilegeLevel level) {
        this.privLevel = level;
    }

    @Override
    public PrivilegeLevel getLevel() {
        return this.privLevel;
    }

    public boolean equals(Object obj) {
        IPrivilege p = (IPrivilege)obj;
        return p.getValue() == this.value;
    }
}

