/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast.cpp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPInheritance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class SemanticQueries {
    public static boolean isCopyOrMoveConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveConstructorKind.COPY_OR_MOVE);
    }

    public static boolean isMoveConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveConstructorKind.MOVE);
    }

    public static boolean isCopyConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveConstructorKind.COPY);
    }

    private static boolean isCopyOrMoveConstructor(ICPPConstructor constructor, CopyOrMoveConstructorKind kind) {
        if (constructor instanceof ICPPFunctionTemplate) {
            return false;
        }
        if (!SemanticQueries.isCallableWithNumberOfArguments(constructor, 1)) {
            return false;
        }
        IType firstArgumentType = constructor.getType().getParameterTypes()[0];
        if (!((firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 1)) instanceof ICPPReferenceType)) {
            return false;
        }
        ICPPReferenceType firstArgReferenceType = (ICPPReferenceType)firstArgumentType;
        boolean isRvalue = firstArgReferenceType.isRValueReference();
        if (isRvalue && kind == CopyOrMoveConstructorKind.COPY) {
            return false;
        }
        if (!isRvalue && kind == CopyOrMoveConstructorKind.MOVE) {
            return false;
        }
        firstArgumentType = firstArgReferenceType.getType();
        firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 8);
        ICPPClassType classType = constructor.getClassOwner();
        if (classType instanceof ICPPClassTemplate) {
            classType = CPPTemplates.createDeferredInstance((ICPPClassTemplate)classType);
        }
        return firstArgumentType.isSameType(classType);
    }

    private static boolean isCallableWithNumberOfArguments(ICPPFunction function, int numArguments) {
        return function.getParameters().length >= numArguments && function.getRequiredArgumentCount() <= numArguments;
    }

    public static ICPPMethod[] getPureVirtualMethods(ICPPClassType classType, IASTNode point) {
        CPPInheritance.FinalOverriderMap finalOverriderMap = CPPInheritance.getFinalOverriderMap(classType, point);
        ArrayList<ICPPMethod> pureVirtualMethods = new ArrayList<ICPPMethod>();
        for (ICPPMethod method : finalOverriderMap.getMap().keySet()) {
            if (!method.isPureVirtual()) continue;
            Map<Integer, List<ICPPMethod>> finalOverriders = finalOverriderMap.getMap().get(method);
            for (Integer subobjectNumber : finalOverriders.keySet()) {
                List<ICPPMethod> overridersForSubobject = finalOverriders.get(subobjectNumber);
                if (overridersForSubobject.size() != 1 || overridersForSubobject.get(0) != method) continue;
                pureVirtualMethods.add(method);
            }
        }
        return pureVirtualMethods.toArray(new ICPPMethod[pureVirtualMethods.size()]);
    }

    public static boolean isUnknownBuiltin(IProblemBinding binding, IASTNode node) {
        boolean isBuiltin;
        char[] name = binding.getNameCharArray();
        boolean bl = isBuiltin = binding.getID() == 1 && CharArrayUtils.startsWith(name, "__builtin_");
        if (isBuiltin) {
            IASTTranslationUnit tu;
            if (node != null && (tu = node.getTranslationUnit()) instanceof ASTTranslationUnit) {
                return !((ASTTranslationUnit)tu).isKnownBuiltin(name);
            }
            return true;
        }
        return false;
    }

    private static enum CopyOrMoveConstructorKind {
        COPY,
        MOVE,
        COPY_OR_MOVE;

    }
}

