/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.sa.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecommon.sa.model.Warning;
import org.tizen.nativecommon.sa.model.WarningFile;
import org.tizen.nativecommon.sa.model.WarningFileInfo;

public class WarningRootByFile {
    private List<File> resultFiles = new ArrayList<File>();
    private List<WarningFile> warningFiles = new ArrayList<WarningFile>();

    public List<File> getResultFiles() {
        return this.resultFiles;
    }

    public List<WarningFile> getChildren() {
        return this.warningFiles;
    }

    public void setResultFiles(List<File> resultFiles) {
        this.resultFiles = resultFiles;
    }

    public void setChildren(List<WarningFile> warningFiles) {
        this.warningFiles = warningFiles;
    }

    public void addChild(WarningFile warningFile) {
        for (WarningFile oldWarningFile : this.warningFiles) {
            if (!oldWarningFile.getFile().equals(warningFile.getFile())) continue;
            for (Warning warning : warningFile.getChildren()) {
                oldWarningFile.addChild(warning);
            }
            return;
        }
        this.warningFiles.add(warningFile);
    }

    public void addWarning(Warning warning) {
        WarningFileInfo fileInfo = warning.getFileInfo();
        warning.setName(String.valueOf(warning.getDes()) + ": (" + fileInfo.getLine() + ":" + fileInfo.getColumn() + ")");
        warning.setParent(null);
        for (WarningFile warningFile : this.warningFiles) {
            if (!warningFile.getFile().equals(warning.getFileInfo().getFile())) continue;
            warningFile.addChild(warning);
            return;
        }
        WarningFile newWarningFile = new WarningFile();
        newWarningFile.setName(fileInfo.getFile().getName());
        newWarningFile.setFile(fileInfo.getFile());
        newWarningFile.setParent(this);
        newWarningFile.addChild(warning);
        this.addChild(newWarningFile);
    }

    public String toString() {
        return this.resultFiles.toString();
    }
}

