/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.c.CArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CPointerType;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;

public class CASTConditionalExpression
extends ASTNode
implements IASTConditionalExpression,
IASTAmbiguityParent {
    private IASTExpression condition;
    private IASTExpression negative;
    private IASTExpression positive;

    public CASTConditionalExpression() {
    }

    public CASTConditionalExpression(IASTExpression condition, IASTExpression positive, IASTExpression negative) {
        this.setLogicalConditionExpression(condition);
        this.setPositiveResultExpression(positive);
        this.setNegativeResultExpression(negative);
    }

    @Override
    public CASTConditionalExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTConditionalExpression copy(IASTNode.CopyStyle style) {
        CASTConditionalExpression copy = new CASTConditionalExpression();
        copy.setLogicalConditionExpression(this.condition == null ? null : this.condition.copy(style));
        copy.setPositiveResultExpression(this.positive == null ? null : this.positive.copy(style));
        copy.setNegativeResultExpression(this.negative == null ? null : this.negative.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getLogicalConditionExpression() {
        return this.condition;
    }

    @Override
    public void setLogicalConditionExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.condition = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(LOGICAL_CONDITION);
        }
    }

    @Override
    public IASTExpression getPositiveResultExpression() {
        return this.positive;
    }

    @Override
    public void setPositiveResultExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.positive = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(POSITIVE_RESULT);
        }
    }

    @Override
    public IASTExpression getNegativeResultExpression() {
        return this.negative;
    }

    @Override
    public void setNegativeResultExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.negative = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEGATIVE_RESULT);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.condition != null && !this.condition.accept(action)) {
            return false;
        }
        if (this.positive != null && !this.positive.accept(action)) {
            return false;
        }
        if (this.negative != null && !this.negative.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.condition) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.condition = (IASTExpression)other;
        }
        if (child == this.positive) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.positive = (IASTExpression)other;
        }
        if (child == this.negative) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.negative = (IASTExpression)other;
        }
    }

    @Override
    public IType getExpressionType() {
        IType negativeType;
        IASTExpression positiveExpression = this.getPositiveResultExpression();
        if (positiveExpression == null) {
            positiveExpression = this.getLogicalConditionExpression();
        }
        IASTExpression negativeExpression = this.getNegativeResultExpression();
        IType originalPositiveType = positiveExpression.getExpressionType();
        IType originalNegativeType = this.getNegativeResultExpression().getExpressionType();
        IType positiveType = CVisitor.unwrapTypedefs(originalPositiveType);
        IType resultType = this.computeResultType(positiveExpression, negativeExpression, positiveType, negativeType = CVisitor.unwrapTypedefs(originalNegativeType));
        if (resultType == null) {
            return ProblemType.UNKNOWN_FOR_EXPRESSION;
        }
        return ExpressionTypes.restoreTypedefs(resultType, originalPositiveType, originalPositiveType);
    }

    private IType computeResultType(IASTExpression positiveExpression, IASTExpression negativeExpression, IType positiveType, IType negativeType) {
        positiveType = CVisitor.unwrapCV(positiveType);
        negativeType = CVisitor.unwrapCV(negativeType);
        if (positiveType instanceof IBasicType && negativeType instanceof IBasicType) {
            if (((IBasicType)positiveType).getKind() == IBasicType.Kind.eVoid && ((IBasicType)negativeType).getKind() == IBasicType.Kind.eVoid) {
                return CBasicType.VOID;
            }
            return CArithmeticConversion.convertCOperandTypes(4, positiveType, negativeType);
        }
        if (positiveType instanceof ICompositeType && negativeType instanceof ICompositeType && positiveType.isSameType(negativeType)) {
            return positiveType;
        }
        if (CVisitor.isNullPointerConstant(positiveExpression) && negativeType instanceof IPointerType) {
            return negativeType;
        }
        if (CVisitor.isNullPointerConstant(negativeExpression) && positiveType instanceof IPointerType) {
            return positiveType;
        }
        if (positiveType instanceof IPointerType && negativeType instanceof IPointerType) {
            IType positivePointeeCV = ((IPointerType)positiveType).getType();
            IType negativePointeeCV = ((IPointerType)negativeType).getType();
            IType positivePointee = CVisitor.unwrapCV(positivePointeeCV);
            IType negativePointee = CVisitor.unwrapCV(negativePointeeCV);
            IType resultPointee = positivePointee.isSameType(CBasicType.VOID) || negativePointee.isSameType(CBasicType.VOID) ? CBasicType.VOID : negativePointee;
            return new CPointerType(ExpressionTypes.restoreCV(resultPointee, positivePointeeCV, negativePointeeCV), 0);
        }
        return null;
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public final IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }
}

