/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.launching.GdbAttachLaunchDelegate;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.debugtools.OnDemandInstall;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.rds.RdsDeployer;
import org.tizen.common.rds.RdsMessages;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.sdb.command.FsCommand;
import org.tizen.common.sdb.command.PackageInfoCommand;
import org.tizen.common.sdb.command.UnInstallCommand;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.LaunchUtil;
import org.tizen.common.util.PackageUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.ViewUtil;
import org.tizen.common.util.log.FileAppender;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonBuildPackageFile;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.CommonProjectDependentPackager;
import org.tizen.nativecommon.build.PlatformChangingManager;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.build.ui.TizenPropertyTester;
import org.tizen.nativecommon.command.NativeDebugCommand;
import org.tizen.nativecommon.command.NativeHelperCommand;
import org.tizen.nativecommon.command.NativeInstallCommand;
import org.tizen.nativecommon.command.NativeLaunchCommand;
import org.tizen.nativecommon.fastdeploy.NativeFastDeployListener;
import org.tizen.nativecommon.launch.DebugLaunchListener;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.NativeRdsDeployer;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchConfigurationConstants;
import org.tizen.nativecommon.launch.TizenLaunchConsole;
import org.tizen.nativecommon.launch.TizenLaunchInfo;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.dsf.TizenDebuggerServicesFactory;
import org.tizen.nativecommon.launch.ui.LoadLibraryConfirmDialog;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

public class TizenAttachDelegate
extends GdbAttachLaunchDelegate {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected File packageFile = null;
    protected IConfiguration selectedConfig = null;
    protected IDevice currentDevice = null;
    protected String executeResult = "";
    protected int localDebugPort = -1;
    protected String packageType;
    protected static final String ENVIRONMENT_SETTING_CMD = "export ";
    protected static final String PLATFORM_FAIL_MESSAGE = "fail";
    @Deprecated
    protected TizenLaunchCommand tizenCommand = null;
    protected TizenLaunchConsole launchConsole = null;
    private DsfSession debugSession;
    protected static final int defaultTimeOut = 60000;

    protected boolean canDebugProject(ILaunchConfiguration config) throws CoreException {
        return true;
    }

    protected String getPluginID() {
        return "org.tizen.nativecommon";
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        UserLogger.start((String)"native.launch");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject project = ProjectUtil.getProject(config);
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote_attach");
        config = wc.doSave();
        try {
            monitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 20);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
            if ("launched already".equals(launch.getAttribute("LAUNCH_ATTR_KEY_IS_LAUNCHING"))) {
                this.logger.debug("the {} project is already launching.(device serial: {})", (Object)project.getName(), (Object)this.currentDevice.getSerialNumber());
                throw new CoreException((IStatus)new Status(4, "org.tizen.nativecommon", NLS.bind((String)LaunchMessages.LAUNCHED_ALREADY, (Object)project.getName())));
            }
            LaunchUtils.verifyExecutableProject(project);
            this.currentDevice = ConnectionPlugin.getDefault().getTargetToolBarManager().getDefaultLaunchTarget(project, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
            if (this.currentDevice == null) {
                return;
            }
            boolean launchAvailable = LaunchUtil.checkProfile((IDevice)this.currentDevice, (IProject)project);
            if (!launchAvailable) {
                return;
            }
            try {
                LaunchUtils.setDeviceToLaunchConfiguration(config.getWorkingCopy(), this.currentDevice);
                this.verifyBuildConfiguration(config, mode, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.setConsole(config);
                this.launchConsole.show();
                FileAppender fileAppender = (FileAppender)org.apache.log4j.Logger.getRootLogger().getAppender("TIZEN_FILE_APPENDER");
                String logPath = fileAppender != null ? FileUtil.convertToOSPath((String)fileAppender.getLogPath()) : "";
                this.launchConsole.println(NLS.bind((String)LaunchMessages.LAUNCH_START, (Object)logPath));
                if (mode.equals("debug") && this.canDebugProject(config)) {
                    this.setDebugConfigAttributes(config);
                    if (RdsPreferencePage.isRdsMode((IProject)project)) {
                        NativeFastDeployListener.disableFastDeployListener((IProject)project);
                        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                        launchManager.addLaunchListener((ILaunchesListener)new DebugLaunchListener(launch, project));
                    }
                    this.launchApplicationForDebug(launch, config, null, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                return;
            }
        }
        finally {
            if (mode.equals("debug")) {
                class PostDebugJob
                implements Runnable {
                    private final ILaunch launch;
                    private final ILaunchConfiguration config;

                    public PostDebugJob(ILaunch launch, ILaunchConfiguration config) {
                        this.launch = launch;
                        this.config = config;
                    }

                    @Override
                    public void run() {
                        try {
                            try {
                                TizenAttachDelegate.this.processPostDebug(this.config);
                            }
                            catch (CoreException coreException) {
                                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                                launchManager.removeLaunch(this.launch);
                            }
                        }
                        finally {
                            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                            launchManager.removeLaunch(this.launch);
                        }
                    }
                }
                Thread t = new Thread(new PostDebugJob(launch, config));
                t.start();
            } else {
                if (!launch.isTerminated()) {
                    launch.terminate();
                }
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                if (!config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "").equals("core") || monitor.isCanceled()) {
                    launchManager.removeLaunch(launch);
                }
            }
            monitor.done();
            UserLogger.end((String)"native.launch");
        }
    }

    protected void processPostDebug(ILaunchConfiguration config) throws CoreException {
        if (this.debugSession != null) {
            while (this.debugSession.isActive()) {
            }
        }
        String gdbserverPort = LaunchUtils.getGdbserverPort(config);
        if (this.localDebugPort != -1) {
            try {
                this.currentDevice.removeForward(this.localDebugPort, Integer.parseInt(gdbserverPort));
            }
            catch (Exception e) {
                this.logger.error("Failed to remove forward", (Throwable)e);
            }
        }
    }

    protected void launchApplicationForDebug(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            config.getWorkingCopy();
            if (!LaunchUtils.setAvailableGdbServerPort(launch, config, this.currentDevice)) {
                if (!launch.isTerminated()) {
                    launch.terminate();
                }
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                launchManager.removeLaunch(launch);
                return;
            }
            this.launchApplicationWithGDBServer(launch, config, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            String gdbserverPort = "";
            String localPort = "";
            try {
                gdbserverPort = config.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102");
                LaunchUtils.createForward(config, this.currentDevice);
                localPort = config.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102");
                LaunchUtils.getGdbserverPort(config);
            }
            catch (Exception e) {
                LaunchUtils.newCoreException(TizenLaunchMessages.GDB_CANNOT_CREATE_PORT, e);
            }
            try {
                try {
                    super.launch(config, "debug", launch, monitor);
                    GdbLaunch gdbLaunch = (GdbLaunch)launch;
                    this.debugSession = gdbLaunch.getSession();
                }
                catch (Exception e) {
                    if (!launch.isTerminated()) {
                        launch.terminate();
                    }
                    LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBCLIENT, e);
                    try {
                        this.currentDevice.removeForward(Integer.parseInt(localPort), Integer.parseInt(gdbserverPort));
                    }
                    catch (Exception e2) {
                        this.logger.error("Failed to remove forward", (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    this.currentDevice.removeForward(Integer.parseInt(localPort), Integer.parseInt(gdbserverPort));
                }
                catch (Exception e) {
                    this.logger.error("Failed to remove forward", (Throwable)e);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getCodeCoverageEnvironmentVariable(IProject project) {
        String command = "export GCOV_PREFIX=" + ProjectUtil.getRootTmpDirectory(project) + "/data " + "&& export GCOV_PREFIX_STRIP=0 && ";
        return command;
    }

    protected String getGdbserverRunCommand(ILaunchConfiguration config) throws CoreException {
        IProject project = ProjectUtil.getProject(config);
        String execArguments = this.getArguments(config);
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
        String command = manifest.getLaunchCommand(config, true, this.hasCodeCoverageFlag(config), false, execArguments);
        return command;
    }

    protected void launchApplicationWithGDBServer(ILaunch launch, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBSERVER, 1);
                monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBSERVER);
                this.launchConsole.println(this.getConsoleVerboseMessage(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBSERVER));
                this.verifyGDBServerExists(launch, config, monitor);
                NativeDebugCommand command = new NativeDebugCommand(this.currentDevice, config, this.hasCodeCoverageFlag(config), false, "", true, (ITizenConsoleManager)this.launchConsole);
                command.execute();
            }
            catch (OperationCanceledException oce) {
                throw oce;
            }
            catch (Exception e) {
                LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBSERVER, e);
                this.logger.error(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBSERVER, (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void verifyGDBServerExists(ILaunch launch, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        String gdbServer = TizenPlatformConstants.getGDBServerPath((IDevice)this.currentDevice);
        boolean isInstalled = false;
        NativeHelperCommand helperCommand = new NativeHelperCommand(this.currentDevice, null);
        try {
            isInstalled = helperCommand.isGDBServerInstalled(gdbServer);
        }
        catch (Exception e) {
            this.logger.debug("Gdbserver version check error", (Throwable)e);
            isInstalled = false;
        }
        if (!isInstalled) {
            File file = new File(gdbServer);
            String gdbServerDir = file.getParent();
            if (gdbServerDir != null) {
                try {
                    helperCommand.removeFile(gdbServerDir);
                }
                catch (Exception e2) {
                    LaunchUtils.newCoreException(NLS.bind((String)TizenLaunchMessages.GDBSERVER_NOT_REMOVED, (Object)this.currentDevice.getDeviceName()), e2);
                }
            }
            OnDemandInstall onDemand = new OnDemandInstall(this.currentDevice, "gdbserver");
            onDemand.setBlocking(true);
            onDemand.install(monitor);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                LaunchUtils.newCoreException(NLS.bind((String)TizenLaunchMessages.GDBSERVER_NOT_INSTALLED, (Object)this.currentDevice.getDeviceName()), e1);
            }
        }
    }

    protected boolean hasCodeCoverageFlag(ILaunchConfiguration config) throws CoreException {
        IProject project = ProjectUtil.getProject(config);
        String buildConfigName = this.getBuildConfigName(config);
        IConfiguration configuration = this.getBuildConfiguration(buildConfigName, project);
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
        String cflags = manifest.getAllCFlags(configuration);
        return cflags.contains("-fprofile-arcs -ftest-coverage");
    }

    protected String getDebugLaunchCommand(ILaunchConfiguration config) throws CoreException {
        IProject project = ProjectUtil.getProject(config);
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
        String command = "/opt/apps/" + manifest.getPackageName() + "/bin/" + ProjectUtil.getExecutableName(config);
        return command;
    }

    protected void activateProgressView() {
        ViewUtil.showView((String)"org.eclipse.ui.views.ProgressView", (boolean)true);
    }

    protected void setConsole(ILaunchConfiguration config) {
        IProject project = null;
        IPath exePath = null;
        try {
            project = ProjectUtil.getProject(config);
            exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
            this.launchConsole = TizenLaunchConsole.getTizenConsole();
            this.launchConsole.clear();
            Object[] binding = new String[4];
            binding[0] = ProjectUtil.getArtefactName(project);
            binding[1] = exePath.toOSString();
            binding[2] = DateFormat.getInstance().format(new Date());
            String consoleName = NLS.bind((String)TizenLaunchMessages.Launch_Application_Console_Title, (Object[])binding);
            this.launchConsole.changeConsoleName(consoleName);
        }
        catch (Exception e) {
            this.logger.error(TizenLaunchMessages.CANNOT_SET_CONSOLE, (Throwable)e);
        }
    }

    protected void setDebugConfigAttributes(ILaunchConfiguration config) throws CoreException {
        this.setSharedlibrarySearchPath(config);
    }

    private boolean hasSharedLibrary(List list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            File[] fileList;
            Path libPath = new Path((String)it.next());
            File file = libPath.toFile();
            if (!file.isDirectory() || file.listFiles() == null) continue;
            File[] fileArray = fileList = file.listFiles();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if ("so".equals(FileUtil.getFileExtension((String)f.getName()))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void openLoadSymbolDialog(ILaunchConfiguration config) throws CoreException {
        boolean needOpen = false;
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        needOpen = wc.getAttribute(TizenLaunchConfigurationConstants.ATTR_LOAD_SYMBOL_DIALOG, true);
        if (needOpen) {
            class DialogRunnable
            implements Runnable {
                LoadLibraryConfirmDialog dialog;
                private final /* synthetic */ ILaunchConfiguration val$config;

                DialogRunnable(ILaunchConfiguration iLaunchConfiguration) {
                    this.val$config = iLaunchConfiguration;
                }

                @Override
                public void run() {
                    this.dialog = new LoadLibraryConfirmDialog(this.val$config, SWTUtil.getShell());
                    this.dialog.open();
                }

                public boolean isCanceled() {
                    return this.dialog.isCanceled();
                }

                public boolean openDialogAgain() {
                    return this.dialog.openDialogAgain();
                }

                public boolean selectedYes() {
                    return this.dialog.selectedYes();
                }
            }
            DialogRunnable dialogRunnable = new DialogRunnable(config);
            SWTUtil.syncExec((Runnable)dialogRunnable);
            if (dialogRunnable.isCanceled()) {
                throw new OperationCanceledException();
            }
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.AUTO_SOLIB", dialogRunnable.selectedYes());
            if (!dialogRunnable.openDialogAgain()) {
                wc.setAttribute(TizenLaunchConfigurationConstants.ATTR_LOAD_SYMBOL_DIALOG, false);
            }
            wc.doSave();
        }
    }

    protected boolean canAddLibrarySearchPath(ILaunchConfiguration config, IPath searchPath) throws CoreException {
        boolean ret = true;
        List values = config.getAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", Collections.EMPTY_LIST);
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Path oldPath = new Path((String)it.next());
            if (!PathUtil.equalPath((IPath)oldPath, (IPath)searchPath)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    protected boolean isRdsMode(IProject project, ILaunchConfiguration config) {
        TizenPropertyTester tester = new TizenPropertyTester();
        boolean rdsMode = RdsPreferencePage.isRdsMode((IProject)project);
        if (tester.isUnitTestProject(project)) {
            return false;
        }
        boolean ospCompat = LaunchUtils.isOspCompat(config);
        if (ospCompat) {
            this.launchConsole.println(RdsDeployer.makeRdsLog((String)"OspCompat is True, so RDS mode is skipped."));
        }
        return rdsMode && !ospCompat;
    }

    protected void deployApplication(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        UserLogger.start((String)"native.launch", (String)".deploy");
        NativeRdsDeployer rdsDeployer = null;
        try {
            monitor.beginTask(TizenLaunchMessages.START_DEPLOY_PROCESS, 11);
            monitor.subTask(TizenLaunchMessages.START_DEPLOY_PROCESS);
            this.launchConsole.println(this.getConsoleVerboseMessage(TizenLaunchMessages.START_DEPLOY_PROCESS));
            IProject project = ProjectUtil.getProject(config);
            List migratingReferencedProjects = PackageUtil.getMigratingReferencedProjects((IProject)project);
            if (!CollectionUtil.isEmpty((Collection)migratingReferencedProjects)) {
                PackageUtil.migrateReferencedProjects((IProject)project, (List)migratingReferencedProjects);
            }
            rdsDeployer = new NativeRdsDeployer(project, this.currentDevice, this.launchConsole, "TPK".toLowerCase(), monitor);
            if (this.isRdsMode(project, config)) {
                List referencedProjects;
                this.launchConsole.println(LaunchMessages.getStepMessage((String)RdsMessages.RDS_MODE_ENABLED));
                rdsDeployer.setInterestList(TizenLaunchInfo.makeInterestList(project));
                rdsDeployer.setIgnoreList(TizenLaunchInfo.makeIgnoreList(project));
                List<DeltaResourceInfo> rootProjectAppendIngoreList = this.convertBlackListToRDSDeltaList(project);
                if (rootProjectAppendIngoreList != null) {
                    rdsDeployer.appendIgnoreList(rootProjectAppendIngoreList);
                }
                if ((referencedProjects = org.tizen.common.util.ProjectUtil.getReferencedProjects((IProject)project)) != null && referencedProjects.size() > 0) {
                    for (IProject iproject : referencedProjects) {
                        rdsDeployer.appendInterestList(TizenLaunchInfo.makeSubAppBinaryInterest(iproject));
                    }
                    for (IProject iproject : referencedProjects) {
                        List<DeltaResourceInfo> subProjectAppendIngoreList = this.convertBlackListToRDSDeltaList(iproject);
                        if (subProjectAppendIngoreList == null) continue;
                        rdsDeployer.appendIgnoreList(subProjectAppendIngoreList);
                    }
                }
                if (monitor.isCanceled()) {
                    LaunchUtils.newCoreException(8, null, null);
                }
                if (!rdsDeployer.deploy()) {
                    this.normalDeploy(project, config, monitor);
                }
                rdsDeployer.pushResInfoFile();
            } else {
                rdsDeployer.removeResInfoFile();
                this.launchConsole.println(LaunchMessages.getStepMessage((String)RdsMessages.RDS_MODE_DISABLED));
                this.normalDeploy(project, config, monitor);
            }
            if (monitor.isCanceled()) {
                LaunchUtils.newCoreException(8, null, null);
            }
            LaunchUtils.touchExecutableFile(project);
        }
        finally {
            if (rdsDeployer != null) {
                try {
                    rdsDeployer.close();
                }
                catch (IOException e) {
                    this.logger.error("Failed to close RDSDeployer", (Throwable)e);
                }
            }
            monitor.done();
            UserLogger.end((String)"native.launch", (String)".deploy");
        }
    }

    private List<DeltaResourceInfo> convertBlackListToRDSDeltaList(IProject project) {
        ArrayList<DeltaResourceInfo> appendIgnoreList = null;
        ITizenProject tizenProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)project);
        TizenPackageInfoStore tizenPkgInfoStore = tizenProject.getTizenPkgInfoStore();
        List blackList = tizenPkgInfoStore.getBlackList();
        if (blackList != null && blackList.size() > 0) {
            appendIgnoreList = new ArrayList<DeltaResourceInfo>();
            for (PackageResourceInfo packageInfo : blackList) {
                String name = packageInfo.getName();
                String remotePath = packageInfo.remotePath();
                int resourceType = packageInfo.getResourceType();
                DeltaResourceInfo ingoreDelta = new DeltaResourceInfo(name, "/" + name, remotePath, null, resourceType, project.getName());
                appendIgnoreList.add(ingoreDelta);
            }
        }
        return appendIgnoreList;
    }

    private void normalDeploy(IProject project, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        this.createPackage(config, (IProgressMonitor)new SubProgressMonitor(monitor, 6));
        if (monitor.isCanceled()) {
            LaunchUtils.newCoreException(8, null, null);
        }
        ProjectUtil.refreshResources(project);
        this.transferPackage((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor.isCanceled()) {
            LaunchUtils.newCoreException(8, null, null);
        }
        this.installPackage(config, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
    }

    protected void createPackage(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        UserLogger.start((String)"native.launch", (String)".packaging");
        try {
            monitor.beginTask(TizenLaunchMessages.CREATE_PACKAGE, 1);
            monitor.subTask(TizenLaunchMessages.CREATE_PACKAGE);
            this.launchConsole.println(this.getConsoleVerboseMessage(TizenLaunchMessages.CREATE_PACKAGE));
            IProject project = ProjectUtil.getProject(config);
            IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
            CommonProjectDependentPackager packager = ProjectTypeManager.getProjectPackagerInstance(project);
            if (packager == null) {
                this.newCoreException(TizenLaunchMessages.CANNOT_CREATE_PACKAGE, null);
            }
            String buildConfigName = this.getBuildConfigName(config);
            this.packageType = CommonBuildPackageFile.getPackageType(project);
            if ("".equals(this.packageType)) {
                this.packageType = "TPK";
            }
            try {
                manifest.doMultiAppPreProcess(packager, monitor);
            }
            catch (Exception e) {
                this.newCoreException(TizenLaunchMessages.CANNOT_CREATE_PACKAGE, e);
            }
            try {
                packager.buildPackage(buildConfigName, this.packageType, TizenPlatformConstants.SIGNING_DEFAULT);
            }
            catch (SBIException e) {
                this.newCoreException(TizenLaunchMessages.CANNOT_CREATE_PACKAGE, e);
            }
            this.packageType = this.packageType.toLowerCase();
            String packageDirectory = String.valueOf(File.separatorChar) + buildConfigName + File.separatorChar;
            Path packagePath = new Path(String.valueOf(project.getLocation().toString()) + packageDirectory);
            this.packageFile = ProjectUtil.findPackageFile(this.currentDevice, packagePath.toFile(), this.packageType.toLowerCase(), project);
            if (this.packageFile == null) {
                LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_CREATE_PACKAGE, null);
            }
            this.launchConsole.println(LaunchMessages.getStepMessage((String)NLS.bind((String)TizenLaunchMessages.CREATED_PACKAGE, (Object)this.packageFile.getAbsolutePath())));
        }
        finally {
            monitor.done();
            UserLogger.end((String)"native.launch", (String)".packaging");
        }
    }

    protected String getBuildConfigName(ILaunchConfiguration config) throws CoreException {
        IProject project = ProjectUtil.getProject(config);
        String buildConfigName = config.getAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", "");
        if (buildConfigName.isEmpty()) {
            IConfiguration configuration = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
            return configuration.getName();
        }
        return buildConfigName;
    }

    protected void transferPackage(IProgressMonitor monitor) throws CoreException {
        block10: {
            UserLogger.start((String)"native.launch", (String)".transfer");
            SyncService sync = null;
            try {
                try {
                    monitor.beginTask(TizenLaunchMessages.TRANSFER_PACKAGE, 1);
                    monitor.subTask(TizenLaunchMessages.TRANSFER_PACKAGE);
                    this.launchConsole.showConsoleView();
                    this.launchConsole.println(this.getConsoleVerboseMessage(TizenLaunchMessages.TRANSFER_PACKAGE));
                    if (this.packageFile == null) {
                        LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_TRANSFER_FILE, null);
                    }
                    String destDirectoryPath = TizenPlatformConstants.getAppTmpDirectory((IDevice)this.currentDevice);
                    String srcFilePath = this.packageFile.getAbsoluteFile().getCanonicalPath();
                    String destFilePath = String.valueOf(destDirectoryPath) + "/" + this.packageFile.getAbsoluteFile().getName();
                    sync = this.currentDevice.getSyncService();
                    SyncResult syncSuccess = sync.push(srcFilePath, this.currentDevice.getFileEntry(destFilePath).getParent());
                    if (!syncSuccess.isOk()) {
                        LaunchUtils.newCoreException(NLS.bind((String)TizenLaunchMessages.CANNOT_TRANSFER_FILE_TO, (Object)destFilePath), null);
                    }
                    this.launchConsole.println(LaunchMessages.getStepMessage((String)NLS.bind((String)TizenLaunchMessages.TRANSFERRED_PACKAGE, (Object)srcFilePath, (Object)destDirectoryPath)));
                }
                catch (Exception e) {
                    LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_TRANSFER_FILE, e);
                    monitor.done();
                    if (sync != null) {
                        IOUtil.tryClose((Object[])new Object[]{sync});
                    }
                    UserLogger.end((String)"native.launch", (String)".transfer");
                    break block10;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                if (sync != null) {
                    IOUtil.tryClose((Object[])new Object[]{sync});
                }
                UserLogger.end((String)"native.launch", (String)".transfer");
                throw throwable;
            }
            monitor.done();
            if (sync != null) {
                IOUtil.tryClose((Object[])new Object[]{sync});
            }
            UserLogger.end((String)"native.launch", (String)".transfer");
        }
    }

    protected void uninstallPackage(IProjectLaunchCommand manifest) throws CoreException {
        this.uninstallPackage(manifest, false);
    }

    protected void uninstallPackage(IProjectLaunchCommand manifest, boolean inInstall) throws CoreException {
        if (inInstall) {
            this.launchConsole.println(LaunchMessages.getStepMessage((String)TizenLaunchMessages.UNINSTALL_PACKAGE));
        } else {
            this.launchConsole.println(this.getConsoleVerboseMessage(TizenLaunchMessages.UNINSTALL_PACKAGE));
        }
        String pkgId = manifest.getPackageName();
        PackageInfoCommand pkgCommand = new PackageInfoCommand(this.currentDevice, null);
        boolean isInstalled = false;
        try {
            isInstalled = pkgCommand.isInstalled(pkgId, "TPK".toLowerCase());
        }
        catch (Exception e) {
            this.logger.error("Failed to find old application", (Throwable)e);
        }
        try {
            if (isInstalled) {
                UnInstallCommand command = new UnInstallCommand(this.currentDevice, manifest.getPackageName(), "TPK".toLowerCase(), (ITizenConsoleManager)this.launchConsole);
                command.execute();
                this.launchConsole.println(LaunchMessages.getStepMessage((String)NLS.bind((String)TizenLaunchMessages.UNINSTALLED_PACKAGE, (Object)manifest.getPackageName())));
            }
        }
        catch (Exception e) {
            LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_REMOVE, e);
        }
    }

    protected void installPackage(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        UserLogger.start((String)"native.launch", (String)".install");
        try {
            monitor.beginTask(TizenLaunchMessages.INSTALL_PACKAGE, 2);
            monitor.subTask(TizenLaunchMessages.INSTALL_PACKAGE);
            this.launchConsole.println(this.getConsoleVerboseMessage(TizenLaunchMessages.INSTALL_PACKAGE));
            IProject project = ProjectUtil.getProject(config);
            IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
            PackageInfoCommand pkgCommand = new PackageInfoCommand(this.currentDevice, null);
            boolean isRemovable = false;
            try {
                isRemovable = pkgCommand.isRemovable(manifest.getPackageName());
            }
            catch (Exception e) {
                LaunchUtils.newCoreException("cannot check read only", e);
            }
            if (!LaunchUtils.isUpdateMode(config) && isRemovable) {
                this.uninstallPackage(manifest, true);
            }
            monitor.worked(1);
            String destDirectory = TizenPlatformConstants.getAppTmpDirectory((IDevice)this.currentDevice);
            try {
                NativeInstallCommand command = new NativeInstallCommand(this.currentDevice, this.packageFile, null, null);
                command.setConsole((ITizenConsoleManager)this.launchConsole);
                command.execute();
                String version = manifest.getVersion();
                if (version == null) {
                    manifest.loadManifestfile();
                    version = manifest.getVersion();
                }
                this.launchConsole.println(LaunchMessages.getStepMessage((String)NLS.bind((String)TizenLaunchMessages.INSTALLED_PACKAGE, (Object)manifest.getPackageName(), (Object)version)));
            }
            catch (Exception e) {
                LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_INSTALL, e);
            }
            try {
                FsCommand fsCommand = new FsCommand(this.currentDevice, null);
                fsCommand.removeFile(String.valueOf(destDirectory) + "/" + this.packageFile.getName());
            }
            catch (Exception e) {
                this.logger.error(String.format("Failed to remove %s on target", this.packageFile.getName()), (Throwable)e);
            }
        }
        finally {
            UserLogger.end((String)"native.launch", (String)".install");
        }
    }

    protected String getArguments(ILaunchConfiguration config) throws CoreException {
        String arguments = null;
        arguments = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
        return arguments;
    }

    protected void newCoreException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.tizen.nativecommon", message, exception);
        throw new CoreException((IStatus)status);
    }

    protected void verifyBuildConfiguration(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        String changingArch;
        IProject project = ProjectUtil.getProject(config);
        IConfiguration buildConfig = ProjectUtil.getDefaultConfiguration(project);
        String arch = CommonConfigurationManager.getArchitectureFromConfiguration(buildConfig);
        if (!LaunchUtils.isSameArch(this.currentDevice, arch) && !PlatformChangingManager.changePlatform(project, changingArch = LaunchUtils.getChangingArch(arch, this.currentDevice), true)) {
            LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_CHANGE_BUILDCONFIGURATION, null);
        }
    }

    protected IConfiguration getBuildConfiguration(String buildConfigName, IProject project) throws CoreException {
        IConfiguration[] configurations;
        IConfiguration configuration = null;
        IConfiguration[] iConfigurationArray = configurations = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration c = iConfigurationArray[n2];
            if (c.getName().equals(buildConfigName)) {
                configuration = c;
                break;
            }
            ++n2;
        }
        if (configuration == null) {
            LaunchUtils.newCoreException(TizenLaunchMessages.BUILD_CONFIGURATION_DOES_NOT_MATCH_WITH_CURRENT_DEVICE_TYPE, null);
        }
        return configuration;
    }

    protected String getArchitecture(IProject project) {
        String arch = null;
        IConfiguration config = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
        String targetID = manifest.getBuildTargetName(config);
        try {
            arch = SmartBuildInterface.getInstance().getRootstrapArchitecture(targetID);
        }
        catch (SBIException e) {
            this.logger.error("Failed to get an architecture", (Throwable)e);
        }
        return arch;
    }

    public void launchApplication(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        NativeLaunchCommand command = new NativeLaunchCommand(this.currentDevice, config, this.hasCodeCoverageFlag(config), false, "", (ITizenConsoleManager)this.launchConsole);
        try {
            command.execute();
            String messageOfPlatform = command.getCommandOutput();
            if (messageOfPlatform.contains(PLATFORM_FAIL_MESSAGE)) {
                LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH, new IOException());
            }
        }
        catch (Exception e) {
            LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH, e);
        }
    }

    public String getConsoleVerboseMessage(String message) {
        return LaunchMessages.getStepTitle((String)message);
    }

    protected IDsfDebugServicesFactory newServiceFactory(ILaunchConfiguration config, String version) {
        return new TizenDebuggerServicesFactory(version, config);
    }

    protected void setSharedlibrarySearchPath(ILaunchConfiguration config) throws CoreException {
        Path debugPath;
        IProject proj2;
        List values = config.getAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", new ArrayList(1));
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        Path libPath = new Path(String.valueOf(ProjectUtil.getProject(config).getLocation().toOSString()) + File.separatorChar + "lib");
        boolean hasSharedLibrary = false;
        if (this.canAddLibrarySearchPath(config, (IPath)libPath)) {
            values.add(libPath.toOSString());
        }
        IProject project = ProjectUtil.getProject(config);
        List refProjects = CDebugUtils.getReferencedProjects((IProject)project);
        for (IProject proj2 : refProjects) {
            IConfiguration configuration;
            if (!proj2.exists() || !"so".equals((configuration = ProjectUtil.getDefaultConfiguration(proj2)).getArtifactExtension()) || !this.canAddLibrarySearchPath(config, (IPath)(libPath = new Path(String.valueOf(proj2.getLocation().toOSString()) + File.separatorChar + configuration.getName())))) continue;
            values.add(libPath.toOSString());
            hasSharedLibrary = true;
        }
        if (values.size() > 0 && !hasSharedLibrary && this.hasSharedLibrary(values)) {
            hasSharedLibrary = true;
        }
        if (hasSharedLibrary) {
            this.openLoadSymbolDialog(config);
        }
        if (this.canAddLibrarySearchPath(config, (IPath)(debugPath = new Path(String.valueOf((proj2 = ProjectUtil.getProject(config)).getLocation().toOSString()) + File.separatorChar + ProjectUtil.getDefaultConfiguration(proj2).getName())))) {
            values.add(debugPath.toOSString());
        }
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", values);
        wc.doSave();
    }

    protected File getGDBClientArgument(IBinaryParser.IBinaryObject exeFile) {
        return null;
    }
}

