/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.core;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.util.ProjectUtil;

public class CorePropertyTester
extends PropertyTester {
    private final Logger logger = LoggerFactory.getLogger(CorePropertyTester.class);

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            if (property.equals("isCoreProject")) {
                if (receiver instanceof IProject) {
                    IProject project = (IProject)receiver;
                    return this.isCoreProject(project);
                }
                if (receiver instanceof IFolder) {
                    IFolder folder = (IFolder)receiver;
                    IProject project = folder.getProject();
                    return this.isCoreProject(project);
                }
            }
            if (property.equals("isDebuggable")) {
                if (receiver instanceof IProject) {
                    IProject project = (IProject)receiver;
                    return this.isDebuggable(project);
                }
                if (receiver instanceof IFolder) {
                    IFolder folder = (IFolder)receiver;
                    IProject project = folder.getProject();
                    return this.isDebuggable(project);
                }
            }
            return false;
        }
        catch (Exception e) {
            this.logger.error("Failed to test isCoreProject", (Throwable)e);
            return false;
        }
    }

    private boolean isDebuggable(IProject project) {
        boolean isCoreProject = this.isCoreProject(project);
        if (isCoreProject) {
            TizenProjectType type = ProjectUtil.getTizenProjectType((IProject)project);
            return !type.isImeProject();
        }
        return false;
    }

    private boolean isCoreProject(IProject project) {
        if (this.isUnitTestProject(project)) {
            return false;
        }
        TizenProjectType type = ProjectUtil.getTizenProjectType((IProject)project);
        if (type == null) {
            return false;
        }
        return type.isCoreProject() || type == TizenProjectType.TIZEN_C_SHAREDLIBRARY || type == TizenProjectType.TIZEN_C_STATICLIBRARY;
    }

    private boolean isUnitTestProject(IProject project) {
        String[] natureIds = null;
        try {
            natureIds = project.getDescription().getNatureIds();
        }
        catch (CoreException coreException) {
            return false;
        }
        if (natureIds != null) {
            String[] stringArray = natureIds;
            int n = natureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                if ("org.tizen.tizentest.nature".equals(natureId)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

