/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.cdt.internal.ui.workingsets.BuildJob;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProxy;
import org.eclipse.cdt.internal.ui.workingsets.ProjectConfigsController;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfigsController;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.internal.ui.workingsets.WorkspaceSnapshot;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WorkingSetConfigurationBlock {
    private static final String BUILD_PROMPT_DIALOG_ID = "workingsets.build.prompt";
    private static final int BUILD_PROMPT_DIALOG_NO = 0;
    private static final int BUILD_PROMPT_DIALOG_CANCEL = 1;
    private static final int BUILD_PROMPT_DIALOG_YES = 2;
    private WorkspaceSnapshot workspace;
    private WorkingSetConfigsController controller;
    private IWorkingSetProxy.ISnapshot initialSelection;
    private IFilter workingSetFilter;
    private Control contents;

    public WorkingSetConfigurationBlock(WorkspaceSnapshot workspace) {
        this(workspace, null);
    }

    public WorkingSetConfigurationBlock(WorkspaceSnapshot workspace, IWorkingSetProxy.ISnapshot initialSelection) {
        this.workspace = workspace;
        this.initialSelection = initialSelection;
    }

    public IFilter getWorkingSetFilter() {
        return this.workingSetFilter;
    }

    public void setWorkingSetFilter(IFilter filter) {
        this.workingSetFilter = filter;
    }

    public Control createContents(Composite parent) {
        SashForm sashForm = new SashForm(parent, 66048);
        GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults();
        this.createWorkingSetConfigsArea((Composite)sashForm, layoutFactory.extendedMargins(0, 0, 0, 15));
        this.createProjectConfigsArea((Composite)sashForm, layoutFactory.extendedMargins(0, 0, 15, 0));
        sashForm.setWeights(new int[]{1, 1});
        this.contents = sashForm;
        return sashForm;
    }

    protected Composite createWorkingSetConfigsArea(Composite parent, GridLayoutFactory layoutFactory) {
        Composite result = new Composite(parent, 0);
        layoutFactory.numColumns(2).applyTo(result);
        GridDataFactory layoutDataFactory = GridDataFactory.fillDefaults();
        Label label = new Label(result, 0);
        label.setText(WorkingSetMessages.WSConfigDialog_wsTree_label);
        layoutDataFactory.span(2, 1).applyTo((Control)label);
        this.controller = new WorkingSetConfigsController(this.workspace, this.initialSelection);
        TreeViewer tree = new TreeViewer(result);
        layoutDataFactory.span(1, 1).align(4, 4).grab(true, true).hint(250, -1).applyTo(tree.getControl());
        tree.setContentProvider((IContentProvider)new WSConfigsContentProvider());
        tree.setLabelProvider((IBaseLabelProvider)new WSConfigsLabelProvider((Viewer)tree));
        this.controller.setTreeViewer(tree);
        tree.setComparator(new ViewerComparator(){

            public int category(Object element) {
                IWorkingSetConfiguration.ISnapshot config;
                if (element instanceof IWorkingSetConfiguration.ISnapshot && (config = (IWorkingSetConfiguration.ISnapshot)element).isReadOnly()) {
                    return 0;
                }
                return 1;
            }
        });
        tree.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = WorkingSetMessages.WSConfigDialog_wsTree_accessible_name;
            }
        });
        Composite buttons = new Composite(result, 0);
        layoutDataFactory.grab(false, false).hint(-1, -1).applyTo((Control)buttons);
        layoutFactory.numColumns(1).extendedMargins(0, 0, 0, 0).applyTo(buttons);
        Button button = new Button(buttons, 8);
        layoutDataFactory.align(4, 1).applyTo((Control)button);
        button.setText(WorkingSetMessages.WSConfigDialog_add_label);
        this.controller.setAddButton(button);
        button = new Button(buttons, 8);
        layoutDataFactory.applyTo((Control)button);
        button.setText(WorkingSetMessages.WSConfigDialog_remove_label);
        this.controller.setRemoveButton(button);
        button = new Button(buttons, 8);
        layoutDataFactory.applyTo((Control)button);
        button.setText(WorkingSetMessages.WSConfigDialog_rename_label);
        this.controller.setRenameButton(button);
        button = new Button(buttons, 8);
        layoutDataFactory.applyTo((Control)button);
        button.setText(WorkingSetMessages.WSConfigDialog_activate_label);
        this.controller.setActivateButton(button);
        button = new Button(buttons, 8);
        layoutDataFactory.applyTo((Control)button);
        button.setText(WorkingSetMessages.WSConfigDialog_build_label);
        this.controller.setBuildButton(button);
        return result;
    }

    protected Composite createProjectConfigsArea(Composite parent, GridLayoutFactory layoutFactory) {
        Composite result = new Composite(parent, 0);
        layoutFactory.numColumns(1).applyTo(result);
        GridDataFactory layoutDataFactory = GridDataFactory.fillDefaults();
        Label label = new Label(result, 0);
        label.setText(WorkingSetMessages.WSConfigDialog_projTree_label);
        layoutDataFactory.applyTo((Control)label);
        ProjectConfigsController projectsController = new ProjectConfigsController();
        CheckboxTreeViewer tree = new CheckboxTreeViewer(result);
        layoutDataFactory.span(1, 1).align(4, 4).grab(true, true).applyTo(tree.getControl());
        this.controller.setProjectConfigsController(projectsController);
        projectsController.setWorkingSetConfigurationsController(this.controller);
        projectsController.setTreeViewer(tree);
        tree.setComparator(new ViewerComparator());
        tree.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = WorkingSetMessages.WSConfigDialog_projTree_accessible_name;
            }
        });
        return result;
    }

    public void save() {
        this.workspace.save();
    }

    public boolean build() {
        boolean result = true;
        Collection<IProject> projects = this.workspace.getProjectsToBuild();
        if (!projects.isEmpty()) {
            int button;
            int defaultButton = OptionalMessageDialog.getDialogDetail(BUILD_PROMPT_DIALOG_ID);
            if (defaultButton == -1) {
                defaultButton = 2;
            }
            if ((button = OptionalMessageDialog.open(BUILD_PROMPT_DIALOG_ID, this.contents.getShell(), WorkingSetMessages.WSConfigDialog_buildPrompt_title, null, WorkingSetMessages.WSConfigDialog_buildPrompt_message, 3, new String[]{IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL, IDialogConstants.YES_LABEL}, defaultButton)) == 1025) {
                button = defaultButton;
            } else if (button != 1) {
                OptionalMessageDialog.setDialogDetail(BUILD_PROMPT_DIALOG_ID, button);
            }
            switch (button) {
                case 2: {
                    new BuildJob(projects).schedule();
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    private class WSConfigsContentProvider
    implements ITreeContentProvider {
        private Collection<IWorkingSetProxy> workingSets;

        private WSConfigsContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == this.workingSets) {
                Collection<IWorkingSetProxy> filtered = this.filterWorkingSets(this.workingSets);
                return filtered.toArray();
            }
            if (parentElement instanceof IWorkingSetProxy) {
                return ((IWorkingSetProxy)parentElement).getConfigurations().toArray();
            }
            return new Object[0];
        }

        private Collection<IWorkingSetProxy> filterWorkingSets(Collection<IWorkingSetProxy> workingSets) {
            if (WorkingSetConfigurationBlock.this.workingSetFilter == null) {
                return workingSets;
            }
            ArrayList<IWorkingSetProxy> result = new ArrayList<IWorkingSetProxy>();
            for (IWorkingSetProxy next : workingSets) {
                if (!WorkingSetConfigurationBlock.this.workingSetFilter.select((Object)next)) continue;
                result.add(next);
            }
            return result;
        }

        public Object getParent(Object element) {
            return element instanceof IWorkingSetConfiguration ? ((IWorkingSetConfiguration)element).getWorkingSet() : null;
        }

        public boolean hasChildren(Object element) {
            return element != null && !(element instanceof IWorkingSetConfiguration);
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.workingSets = (Collection)newInput;
        }
    }

    private class WSConfigsLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private WorkbenchLabelProvider wbLabels = new WorkbenchLabelProvider();
        private Image configImage = CDTSharedImages.getImage("icons/obj16/config.gif");
        private Font defaultFont;
        private ResourceManager fonts = new LocalResourceManager(JFaceResources.getResources());

        WSConfigsLabelProvider(Viewer viewer) {
            this.defaultFont = viewer.getControl().getFont();
        }

        public String getText(Object element) {
            if (element instanceof IWorkingSetConfiguration) {
                IWorkingSetConfiguration config = (IWorkingSetConfiguration)element;
                if (config.isActive()) {
                    return WorkingSetConfiguration.isReadOnly(config) ? WorkingSetMessages.WSConfigDialog_implicit_config : NLS.bind((String)WorkingSetMessages.WSConfigDialog_active_config, (Object)config.getName());
                }
                return config.getName();
            }
            if (element instanceof IWorkingSetProxy) {
                return ((IWorkingSetProxy)element).resolve().getLabel();
            }
            return this.wbLabels.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IWorkingSetConfiguration) {
                return this.configImage;
            }
            if (element instanceof IWorkingSetProxy) {
                return this.wbLabels.getImage((Object)((IWorkingSetProxy)element).resolve());
            }
            return this.wbLabels.getImage(element);
        }

        public void dispose() {
            this.wbLabels.dispose();
            this.fonts.dispose();
            super.dispose();
        }

        public Font getFont(Object element) {
            IWorkingSetConfiguration config;
            if (element instanceof IWorkingSetConfiguration && (config = (IWorkingSetConfiguration)element).isActive()) {
                FontDescriptor desc = FontDescriptor.createFrom((Font)this.defaultFont);
                desc = WorkingSetConfiguration.isReadOnly(config) ? desc.withStyle(3) : desc.withStyle(1);
                return (Font)this.fonts.get((DeviceResourceDescriptor)desc);
            }
            return this.wbLabels.getFont(element);
        }
    }
}

