/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build.ui;

import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenProjectType;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.ProjectTypeManager;

public class TizenPropertyTester
extends PropertyTester {
    private final Logger logger = LoggerFactory.getLogger(TizenPropertyTester.class);
    private static String HAS_REFERENCDE_PROJECT = "hasReferencedProject";
    private static String IS_TIZEN_PROJECT = "isTizenProject";
    private static String IS_UIBUILDER_SUPPORTED = "isUIBuilderSupported";
    private static String IS_PACKAGABLE_NATIVE_PROJECT = "isPackagableNativeProject";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        block18: {
            block23: {
                int indx;
                String version;
                block25: {
                    ITizenProject tProject;
                    block24: {
                        IProject project;
                        block20: {
                            block21: {
                                TizenProjectType type;
                                block22: {
                                    block15: {
                                        IProject project2;
                                        block19: {
                                            block16: {
                                                block17: {
                                                    try {
                                                        if (!property.equals(IS_TIZEN_PROJECT)) break block15;
                                                        if (!(receiver instanceof IProject)) break block16;
                                                        project = (IProject)receiver;
                                                        if (!this.isUnitTestProject(project)) break block17;
                                                        return false;
                                                    }
                                                    catch (Exception e) {
                                                        this.logger.error("Failed to test isTizenProject", (Throwable)e);
                                                        return false;
                                                    }
                                                }
                                                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                                                if (info != null) {
                                                    if (ProjectTypeManager.isValidProjectType(project)) {
                                                        return true;
                                                    }
                                                    break block18;
                                                }
                                                return false;
                                            }
                                            if (!(receiver instanceof IFolder)) break block18;
                                            IFolder folder = (IFolder)receiver;
                                            project2 = folder.getProject();
                                            if (!this.isUnitTestProject(project2)) break block19;
                                            return false;
                                        }
                                        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project2);
                                        if (info != null) {
                                            if (ProjectTypeManager.isValidProjectType(project2)) {
                                                return true;
                                            }
                                            break block18;
                                        }
                                        return false;
                                    }
                                    if (property.equals(HAS_REFERENCDE_PROJECT)) {
                                        return this.hasReferencedProject(receiver, property, args, expectedValue);
                                    }
                                    if (!property.equals(IS_PACKAGABLE_NATIVE_PROJECT)) break block20;
                                    if (!(receiver instanceof IProject)) break block21;
                                    project = (IProject)receiver;
                                    type = ProjectUtil.getTizenProjectType(project);
                                    if (type != null) break block22;
                                    return false;
                                }
                                if (!type.isNativeApplicationProject()) break block21;
                                return true;
                            }
                            return false;
                        }
                        if (!property.equals(IS_UIBUILDER_SUPPORTED)) break block18;
                        if (!this.test(receiver, IS_TIZEN_PROJECT, args, expectedValue)) break block23;
                        project = null;
                        if (!(receiver instanceof IProject)) break block23;
                        project = (IProject)receiver;
                        tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)project);
                        if (tProject != null) break block24;
                        return false;
                    }
                    version = tProject.getDescription().getVersion();
                    indx = version.indexOf(46);
                    if (indx != -1) break block25;
                    return false;
                }
                return Integer.parseInt(version.substring(0, indx)) <= 4;
            }
            return false;
        }
        return false;
    }

    private boolean hasReferencedProject(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IProject)) {
            return false;
        }
        IProject project = (IProject)receiver;
        try {
            return ProjectUtil.hasReferencedLibraryProject(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.logger.error("Failed to test hasReferencedProject", (Throwable)e);
            return false;
        }
    }

    public boolean isUnitTestProject(IProject project) {
        String[] natureIds = null;
        try {
            natureIds = project.getDescription().getNatureIds();
        }
        catch (CoreException coreException) {
            return false;
        }
        if (natureIds != null) {
            String[] stringArray = natureIds;
            int n = natureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                if ("org.tizen.tizentest.nature".equals(natureId)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

