/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.indexer;

import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.IIndexTaskProvider;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecommon.indexer.PdomRootstrapRebuildTask;
import org.tizen.nativecommon.indexer.PdomRootstrapUpdateTask;
import org.tizen.nativecommon.indexer.PreBuiltPdom;

public class PdomIndexTaskProvider
implements IIndexTaskProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public IPDOMIndexerTask getPdomIndexerTask(ICProject project, IPDOMIndexer indexer) {
        try {
            PreBuiltPdom preBuiltPdom = new PreBuiltPdom(project);
            boolean exist = preBuiltPdom.exists();
            if (exist) {
                return new PdomRootstrapUpdateTask(indexer, 18, preBuiltPdom);
            }
            return new PdomRootstrapRebuildTask(indexer, preBuiltPdom);
        }
        catch (Throwable t) {
            final ITizenProject tProject = ProjectUtil.getTizenProject((IProject)project.getProject());
            if (tProject == null) {
                return null;
            }
            final TizenProjectDescription desc = tProject.getDescription();
            if (!desc.canUsePrebuiltIndexer().booleanValue()) {
                return null;
            }
            new Thread(){

                @Override
                public void run() {
                    desc.setUsePrebuiltIndexer(Boolean.valueOf(false));
                    tProject.setDescription(desc);
                }
            }.start();
            this.logger.error("Failed to use a prebuilt indexer", t);
            return null;
        }
    }
}

