/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTExpressionList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayModifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConstructorInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;
import org.eclipse.core.runtime.Assert;

public class CPPASTNewExpression
extends ASTNode
implements ICPPASTNewExpression,
IASTAmbiguityParent {
    private IASTInitializerClause[] fPlacement;
    private IASTTypeId fTypeId;
    private IASTInitializer fInitializer;
    private boolean fIsGlobal;
    private boolean fIsNewTypeId;
    private IASTExpression[] fCachedArraySizes;
    private ICPPEvaluation fEvaluation;
    private IASTImplicitName[] fImplicitNames;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTNewExpression() {
    }

    public CPPASTNewExpression(IASTInitializerClause[] placement, IASTInitializer initializer, IASTTypeId typeId) {
        this.setPlacementArguments(placement);
        this.setTypeId(typeId);
        this.setInitializer(initializer);
    }

    @Override
    public CPPASTNewExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTNewExpression copy(IASTNode.CopyStyle style) {
        CPPASTNewExpression copy = new CPPASTNewExpression();
        copy.setIsGlobal(this.fIsGlobal);
        copy.setIsNewTypeId(this.fIsNewTypeId);
        if (this.fPlacement != null) {
            IASTInitializerClause[] plcmt = new IASTInitializerClause[this.fPlacement.length];
            int i = 0;
            while (i < this.fPlacement.length) {
                plcmt[i] = this.fPlacement[i].copy(style);
                ++i;
            }
            copy.setPlacementArguments(plcmt);
        }
        copy.setTypeId(this.fTypeId == null ? null : this.fTypeId.copy(style));
        copy.setInitializer(this.fInitializer == null ? null : this.fInitializer.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public boolean isGlobal() {
        return this.fIsGlobal;
    }

    @Override
    public void setIsGlobal(boolean value) {
        this.assertNotFrozen();
        this.fIsGlobal = value;
    }

    @Override
    public IASTInitializerClause[] getPlacementArguments() {
        return this.fPlacement;
    }

    @Override
    public void setPlacementArguments(IASTInitializerClause[] args) {
        this.assertNotFrozen();
        this.fPlacement = args;
        if (args != null) {
            IASTInitializerClause[] iASTInitializerClauseArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                arg.setParent(this);
                arg.setPropertyInParent(NEW_PLACEMENT);
                ++n2;
            }
        }
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.fInitializer;
    }

    @Override
    public void setInitializer(IASTInitializer expression) {
        this.assertNotFrozen();
        this.fInitializer = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEW_INITIALIZER);
        }
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.fTypeId;
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.fTypeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public boolean isNewTypeId() {
        return this.fIsNewTypeId;
    }

    @Override
    public void setIsNewTypeId(boolean value) {
        this.assertNotFrozen();
        this.fIsNewTypeId = value;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.fImplicitNames == null) {
            CPPASTImplicitName operatorName = null;
            ICPPFunction operatorFunction = CPPSemantics.findOverloadedOperator(this);
            if (operatorFunction != null && !(operatorFunction instanceof CPPImplicitFunction)) {
                operatorName = new CPPASTImplicitName(operatorFunction.getNameCharArray(), (IASTNode)this);
                operatorName.setOperator(true);
                operatorName.setBinding(operatorFunction);
                operatorName.setOffsetAndLength(this.getOffset(), 3);
            }
            CPPASTImplicitName constructorName = null;
            IBinding constructor = CPPSemantics.findImplicitlyCalledConstructor(this);
            if (constructor != null) {
                constructorName = new CPPASTImplicitName(constructor.getNameCharArray(), (IASTNode)this);
                constructorName.setBinding(constructor);
                constructorName.setOffsetAndLength((ASTNode)((Object)this.getTypeId()));
            }
            this.fImplicitNames = operatorName != null ? (constructorName != null ? new IASTImplicitName[]{operatorName, constructorName} : new IASTImplicitName[]{operatorName}) : (constructorName != null ? new IASTImplicitName[]{constructorName} : IASTImplicitName.EMPTY_NAME_ARRAY);
        }
        return this.fImplicitNames;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean isArrayAllocation() {
        IASTDeclarator dtor;
        IASTTypeId typeId = this.getTypeId();
        if (typeId != null && (dtor = typeId.getAbstractDeclarator()) != null) {
            dtor = ASTQueries.findTypeRelevantDeclarator(dtor);
            return dtor instanceof IASTArrayDeclarator;
        }
        return false;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        int n;
        int n2;
        IASTNode[] iASTNodeArray;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitImplicitNames) {
            iASTNodeArray = this.getImplicitNames();
            n2 = iASTNodeArray.length;
            n = 0;
            while (n < n2) {
                IASTNode name = iASTNodeArray[n];
                if (!name.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.fPlacement != null) {
            iASTNodeArray = this.fPlacement;
            n2 = this.fPlacement.length;
            n = 0;
            while (n < n2) {
                IASTNode arg = iASTNodeArray[n];
                if (!arg.accept(action)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.fTypeId != null && !this.fTypeId.accept(action)) {
            return false;
        }
        if (this.fInitializer != null && !this.fInitializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTNewExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.fPlacement != null) {
            int i = 0;
            while (i < this.fPlacement.length) {
                if (child == this.fPlacement[i]) {
                    other.setPropertyInParent(child.getPropertyInParent());
                    other.setParent(child.getParent());
                    this.fPlacement[i] = (IASTExpression)other;
                }
                ++i;
            }
        }
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            IType t;
            IType iType = t = this.fTypeId != null ? CPPVisitor.createType(this.fTypeId) : ProblemType.UNKNOWN_FOR_EXPRESSION;
            if (t instanceof IArrayType) {
                t = ((IArrayType)t).getType();
            }
            ICPPEvaluation[] arguments = ICPPEvaluation.EMPTY_ARRAY;
            if (this.fInitializer instanceof ICPPASTConstructorInitializer) {
                IASTInitializerClause[] args = ((ICPPASTConstructorInitializer)this.fInitializer).getArguments();
                arguments = new ICPPEvaluation[args.length];
                int i = 0;
                while (i < arguments.length) {
                    arguments[i] = ((ICPPASTInitializerClause)args[i]).getEvaluation();
                    ++i;
                }
            }
            this.fEvaluation = EvalTypeId.createForNewExpression(t, this, false, arguments);
        }
        return this.fEvaluation;
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getType(this);
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    @Deprecated
    public IASTExpression[] getNewTypeIdArrayExpressions() {
        if (this.fCachedArraySizes == null) {
            IASTDeclarator dtor;
            if (this.fTypeId != null && (dtor = ASTQueries.findInnermostDeclarator(this.fTypeId.getAbstractDeclarator())) instanceof IASTArrayDeclarator) {
                IASTArrayDeclarator ad = (IASTArrayDeclarator)dtor;
                IASTArrayModifier[] ams = ad.getArrayModifiers();
                this.fCachedArraySizes = new IASTExpression[ams.length];
                int i = 0;
                while (i < ams.length) {
                    IASTArrayModifier am = ams[i];
                    this.fCachedArraySizes[i] = am.getConstantExpression();
                    ++i;
                }
                return this.fCachedArraySizes;
            }
            this.fCachedArraySizes = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        }
        return this.fCachedArraySizes;
    }

    @Override
    @Deprecated
    public void addNewTypeIdArrayExpression(IASTExpression expression) {
        this.assertNotFrozen();
        Assert.isNotNull((Object)this.fTypeId);
        IASTDeclarator dtor = ASTQueries.findInnermostDeclarator(this.fTypeId.getAbstractDeclarator());
        if (!(dtor instanceof IASTArrayDeclarator)) {
            IASTPointerOperator[] ptrOps;
            Assert.isNotNull((Object)dtor);
            Assert.isTrue((dtor.getParent() == this.fTypeId ? 1 : 0) != 0);
            CPPASTArrayDeclarator adtor = new CPPASTArrayDeclarator(dtor.getName());
            IASTPointerOperator[] iASTPointerOperatorArray = ptrOps = dtor.getPointerOperators();
            int n = ptrOps.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator ptr = iASTPointerOperatorArray[n2];
                adtor.addPointerOperator(ptr);
                ++n2;
            }
            this.fTypeId.setAbstractDeclarator(adtor);
            dtor = adtor;
        }
        CPPASTArrayModifier mod = new CPPASTArrayModifier(expression);
        ((ASTNode)mod).setOffsetAndLength((ASTNode)((Object)expression));
        ((IASTArrayDeclarator)dtor).addArrayModifier(mod);
    }

    @Override
    @Deprecated
    public IASTExpression getNewPlacement() {
        if (this.fPlacement == null || this.fPlacement.length == 0) {
            return null;
        }
        if (this.fPlacement.length == 1) {
            if (this.fPlacement[0] instanceof IASTExpression) {
                return (IASTExpression)this.fPlacement[0];
            }
            return null;
        }
        CASTExpressionList result = new CASTExpressionList();
        IASTInitializerClause[] iASTInitializerClauseArray = this.fPlacement;
        int n = this.fPlacement.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (arg instanceof IASTExpression) {
                result.addExpression(((IASTExpression)arg).copy());
            }
            ++n2;
        }
        result.setParent(this);
        result.setPropertyInParent(NEW_PLACEMENT);
        return result;
    }

    @Override
    @Deprecated
    public void setNewPlacement(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression == null) {
            this.setPlacementArguments(null);
        } else if (expression instanceof IASTExpressionList) {
            this.setPlacementArguments(((IASTExpressionList)expression).getExpressions());
        } else {
            this.setPlacementArguments(new IASTExpression[]{expression});
        }
    }

    @Override
    @Deprecated
    public IASTExpression getNewInitializer() {
        if (this.fInitializer == null || this.fInitializer instanceof IASTExpression) {
            return (IASTExpression)((Object)this.fInitializer);
        }
        if (this.fInitializer instanceof ICPPASTConstructorInitializer) {
            IASTExpression expr = ((ICPPASTConstructorInitializer)this.fInitializer).getExpression();
            expr = expr == null ? new CPPASTExpressionList() : expr.copy();
            expr.setParent(this);
            expr.setPropertyInParent(NEW_INITIALIZER);
            return expr;
        }
        return null;
    }

    @Override
    @Deprecated
    public void setNewInitializer(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression == null) {
            this.setInitializer(null);
        } else if (expression instanceof IASTInitializer) {
            this.setInitializer((IASTInitializer)((Object)expression));
        } else {
            CPPASTConstructorInitializer ctorInit = new CPPASTConstructorInitializer();
            ctorInit.setExpression(expression);
            ctorInit.setOffsetAndLength((ASTNode)((Object)expression));
            this.setInitializer(ctorInit);
        }
    }
}

