/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.tizen.nativecore.misc.IConstants;
import org.tizen.nativecore.misc.editor.UiAttrIcon;
import org.tizen.nativecore.misc.editor.dlg.UiChooserDialog;
import org.tizen.nativecore.misc.internal.ui.wizard.icon.UiNewIconWizard;
import org.tizen.nativecore.misc.utils.Constants;

public class UiIconChooserDialog
extends UiChooserDialog {
    private Button fNewBtn;
    private Button fRemoveBtn;
    private UiAttrIcon fAttrIcon;

    public UiIconChooserDialog(Shell parentShell, UiAttrIcon attrIcon) {
        super(parentShell);
        this.fAttrIcon = attrIcon;
        this.setTitle("Icon Chooser");
        this.setMessage("Choose a icon resource (" + IConstants.DIR_SHARED_RES + ")");
    }

    @Override
    protected void populateList() {
        final HashSet items = new HashSet();
        IProject project = this.fAttrIcon.getPage().getProject();
        if (project == null) {
            return;
        }
        IFolder resFolder = project.getFolder(IConstants.DIR_SHARED_RES);
        try {
            if (resFolder.exists() && resFolder.members().length < 1) {
                this.fRemoveBtn.setEnabled(false);
            } else {
                this.fRemoveBtn.setEnabled(true);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                List<String> images;
                if (!(resource instanceof IContainer) && (images = Arrays.asList(Constants.IMAGE_SUPPORTED)).contains(resource.getFileExtension().toLowerCase())) {
                    Path basePath = new Path(String.valueOf(resource.getProject().getProjectRelativePath().toString()) + IConstants.DIR_SHARED_RES);
                    items.add(resource.getProjectRelativePath().makeRelativeTo((IPath)basePath));
                }
                return true;
            }
        };
        try {
            if (resFolder.exists()) {
                resFolder.accept(visitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.setListElements(items.toArray());
    }

    @Override
    protected void createExtraDialogArea(Composite grid) {
        this.fNewBtn = new Button(grid, 8);
        this.fNewBtn.setText("New Icon...");
        this.fNewBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiIconChooserDialog.this.onNewIcon(e);
            }
        });
        this.fNewBtn.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.fRemoveBtn = new Button(grid, 8);
        this.fRemoveBtn.setText("Delete icon");
        this.fRemoveBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                UiIconChooserDialog.this.onDeleteIcon(e);
            }
        });
        this.fRemoveBtn.setLayoutData((Object)new GridData(16384, 1024, false, false));
    }

    public void onDeleteIcon(SelectionEvent e) {
        Object[] objects = this.getSelectedElements();
        if (objects.length == 1 && objects[0] instanceof IPath) {
            this.fSelectedItemName = objects[0].toString();
            IProject project = this.fAttrIcon.getPage().getProject();
            if (project != null) {
                Path filePath = new Path(String.valueOf(project.getProjectRelativePath().toString()) + IConstants.DIR_SHARED_RES + File.separator + this.fSelectedItemName);
                try {
                    project.getFile((IPath)filePath).delete(true, null);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
            this.populateList();
        }
    }

    public void onNewIcon(SelectionEvent e) {
        UiNewIconWizard wizard = new UiNewIconWizard(this.fAttrIcon.getPage().getProject(), "");
        wizard.getOptions().setIconType(this.fAttrIcon.getIconInput().getIconType());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() != 0) {
            return;
        }
        this.populateList();
    }
}

