/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CContentTypes {
    private static final String PREF_LOCAL_CONTENT_TYPE_SETTINGS = "enabled";
    private static final Preferences PROJECT_SCOPE = Platform.getPreferencesService().getRootNode().node("project");
    private static final String CONTENT_TYPE_PREF_NODE = "content-types";
    private static final String FULLPATH_CONTENT_TYPE_PREF_NODE = "org.eclipse.core.runtime/content-types";

    public static IContentType getContentType(IProject project, String filename) {
        if (filename == null) {
            return null;
        }
        IContentTypeManager matcher = null;
        ProjectScope scopeCtx = null;
        boolean preferCpp = true;
        if (project != null) {
            try {
                matcher = project.getContentTypeMatcher();
                if (CContentTypes.usesProjectSpecificContentTypes(project)) {
                    scopeCtx = new ProjectScope(project);
                }
                if (CoreModel.hasCNature(project)) {
                    preferCpp = CoreModel.hasCCNature(project) == IndexerPreferences.preferDefaultLanguage(project);
                }
            }
            catch (CoreException coreException) {
                matcher = Platform.getContentTypeManager();
            }
        } else {
            matcher = Platform.getContentTypeManager();
        }
        IContentType[] cts = matcher.findContentTypesFor(filename);
        switch (cts.length) {
            case 0: {
                return null;
            }
            case 1: {
                return cts[0];
            }
        }
        int maxPossiblePriority = scopeCtx == null ? 11 : 101;
        int bestPriority = -1;
        IContentType bestResult = null;
        int i = 0;
        while (i < cts.length) {
            IContentType candidate = cts[i];
            int priority = 0;
            try {
                IContentTypeSettings settings;
                if (scopeCtx != null && CContentTypes.isStrictlyAssociatedWith(settings = candidate.getSettings((IScopeContext)scopeCtx), filename)) {
                    priority = 100;
                }
                if (priority == 0 && bestPriority < 100 && CContentTypes.isStrictlyAssociatedWith((IContentTypeSettings)candidate, filename)) {
                    priority = 10;
                }
                if (CContentTypes.isPreferredContentType(candidate, preferCpp)) {
                    ++priority;
                }
            }
            catch (CoreException coreException) {}
            if (priority > bestPriority) {
                if (priority == maxPossiblePriority) {
                    return candidate;
                }
                bestPriority = priority;
                bestResult = candidate;
            }
            ++i;
        }
        return bestResult;
    }

    private static boolean isPreferredContentType(IContentType candidate, boolean preferCpp) {
        while (candidate != null) {
            String id = candidate.getId();
            if ("org.eclipse.cdt.core.cxxHeader".equals(id) || "org.eclipse.cdt.core.cxxSource".equals(id)) {
                return preferCpp;
            }
            if ("org.eclipse.cdt.core.cHeader".equals(id) || "org.eclipse.cdt.core.cSource".equals(id)) {
                return !preferCpp;
            }
            candidate = candidate.getBaseType();
        }
        return false;
    }

    private static boolean isStrictlyAssociatedWith(IContentTypeSettings settings, String filename) {
        String[] namespecs = settings.getFileSpecs(4);
        int i = 0;
        while (i < namespecs.length) {
            String name = namespecs[i];
            if (name.equals(filename)) {
                return true;
            }
            ++i;
        }
        int dotPosition = filename.lastIndexOf(46);
        if (dotPosition >= 0 && dotPosition < filename.length() - 1) {
            String fileExtension = filename.substring(dotPosition + 1);
            String[] extensions = settings.getFileSpecs(8);
            int i2 = 0;
            while (i2 < extensions.length) {
                String ext = extensions[i2];
                if (ext.equals(fileExtension)) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public static boolean usesProjectSpecificContentTypes(IProject project) {
        Preferences node;
        block7: {
            block6: {
                String projectName;
                block5: {
                    projectName = project.getName();
                    try {
                        node = PROJECT_SCOPE;
                        if (node.nodeExists(projectName)) break block5;
                        return false;
                    }
                    catch (BackingStoreException backingStoreException) {
                        return false;
                    }
                }
                node = node.node(projectName);
                if (node.nodeExists("org.eclipse.core.runtime")) break block6;
                return false;
            }
            node = node.node("org.eclipse.core.runtime");
            if (node.nodeExists(CONTENT_TYPE_PREF_NODE)) break block7;
            return false;
        }
        node = node.node(CONTENT_TYPE_PREF_NODE);
        return node.getBoolean(PREF_LOCAL_CONTENT_TYPE_SETTINGS, false);
    }

    public static void setUseProjectSpecificContentTypes(IProject project, boolean val) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences contentTypePrefs = projectScope.getNode(FULLPATH_CONTENT_TYPE_PREF_NODE);
        if (CContentTypes.usesProjectSpecificContentTypes(project) != val) {
            contentTypePrefs.putBoolean(PREF_LOCAL_CONTENT_TYPE_SETTINGS, val);
            try {
                contentTypePrefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }
}

