/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.nativecommon.apihover.FunctionSummary;
import org.tizen.nativecommon.apihover.HelpBook;
import org.tizen.nativecommon.apihover.IndexExtractor;
import org.tizen.nativecommon.apihover.IndexFileInfo;
import org.tizen.nativecommon.apihover.Item;
import org.tizen.nativecommon.apihover.ItemFunction;
import org.tizen.nativecommon.apihover.ItemMakro;
import org.tizen.nativecommon.apihover.ItemType;
import org.tizen.nativecommon.apihover.ItemVariable;
import org.tizen.nativecommon.apihover.MacroSummary;
import org.tizen.nativecommon.apihover.TypeSummary;
import org.tizen.nativecommon.apihover.VariableSummary;

public class IndexFinder {
    private static final String INDEX_FILES_EXTENSION_POINT_ID = "org.tizen.nativeapp.documentation";
    private static IndexFinder theIndexFinder = null;
    protected ArrayList<ICHelpBook> helpBooks = null;
    protected List<IndexExtractor> indexExtractors = null;

    public static IndexFinder getInstance() {
        if (theIndexFinder == null) {
            theIndexFinder = new IndexFinder();
        }
        return theIndexFinder;
    }

    protected IndexFinder() {
    }

    private List<IndexExtractor> getIndexExtractors() {
        if (this.indexExtractors == null) {
            this.createIndexExtractors();
        }
        return this.indexExtractors;
    }

    protected void createIndexExtractors() {
        this.indexExtractors = new ArrayList<IndexExtractor>();
        this.helpBooks = new ArrayList();
        IndexFileInfo[] infosArray = this.getIndexFiles();
        int i = 0;
        while (i < infosArray.length) {
            File file = new File(infosArray[i].getPath());
            if (file.exists()) {
                IndexExtractor ie = IndexExtractor.unserialize(infosArray[i].getPath());
                ie.setGeneratePrefixes(infosArray[i].generatePrefixes());
                this.indexExtractors.add(ie);
                this.addHelpBook(infosArray[i].getName(), infosArray[i].getType());
            }
            ++i;
        }
    }

    private IndexFileInfo[] getIndexFiles() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(INDEX_FILES_EXTENSION_POINT_ID);
        ArrayList<IndexFileInfo> infos = new ArrayList<IndexFileInfo>();
        int i = 0;
        while (i < config.length) {
            IConfigurationElement elem = config[i];
            if (elem.getName().equals("indexFile")) {
                IndexFileInfo ifi = new IndexFileInfo(elem.getAttribute("name"), elem.getAttribute("type"), elem.getAttribute("file"), Boolean.valueOf(elem.getAttribute("generatePrefixes")));
                infos.add(ifi);
            }
            ++i;
        }
        IndexFileInfo[] infosArray = new IndexFileInfo[infos.size()];
        infosArray = infos.toArray(infosArray);
        return infosArray;
    }

    public Item getItem(String expression) {
        int i = 0;
        while (i < this.getIndexExtractors().size()) {
            if (this.getIndexExtractors().get(i).getItemMap().containsKey(expression)) {
                return this.getIndexExtractors().get(i).getItemMap().get(expression);
            }
            ++i;
        }
        return null;
    }

    public IFunctionSummary[] getItemsWithPrefix(String prefix) {
        if (this.helpBooks == null) {
            this.createIndexExtractors();
        }
        HashMap<String, Item> mainMap = new HashMap<String, Item>();
        ArrayList<FunctionSummary> functionsList = new ArrayList<FunctionSummary>();
        int i = 0;
        while (i < this.getIndexExtractors().size()) {
            HashMap<String, Item> hashMap = this.getIndexExtractors().get(i).getItemMap();
            if (hashMap.size() > 0) {
                mainMap.putAll(hashMap);
            }
            ++i;
        }
        Set c = mainMap.entrySet();
        for (Map.Entry e : c) {
            Item item = (Item)e.getValue();
            if (!(item instanceof ItemFunction) || !item.getName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
            FunctionSummary f = new FunctionSummary();
            f.setReturnType(item.getReturnType());
            f.setPrototype(item.getPrototype());
            f.setName(item.getName());
            if (item.getNamespace() != null && !item.getNamespace().endsWith(".c")) {
                f.addIncludeFile(item.getNamespace());
            }
            functionsList.add(f);
        }
        IFunctionSummary[] functionsListArray = new IFunctionSummary[functionsList.size()];
        return functionsList.toArray(functionsListArray);
    }

    public MacroSummary[] getMacrosWithPrefix(String prefix) {
        if (this.helpBooks == null) {
            this.createIndexExtractors();
        }
        HashMap<String, Item> mainMap = new HashMap<String, Item>();
        ArrayList<MacroSummary> macrosList = new ArrayList<MacroSummary>();
        int i = 0;
        while (i < this.getIndexExtractors().size()) {
            HashMap<String, Item> hashMap = this.getIndexExtractors().get(i).getItemMap();
            if (hashMap.size() > 0) {
                mainMap.putAll(hashMap);
            }
            ++i;
        }
        Set c = mainMap.entrySet();
        for (Map.Entry e : c) {
            Item item = (Item)e.getValue();
            if (!(item instanceof ItemMakro) || !item.getName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
            MacroSummary m = new MacroSummary();
            m.setName(item.getName());
            m.setNamespace(item.getNamespace());
            m.setPrototype(item.getPrototype());
            if (item.getArgs() == null || item.getArgs().size() == 0) {
                m.setNoParameters(true);
            } else {
                m.setNoParameters(false);
            }
            macrosList.add(m);
        }
        MacroSummary[] macrosListArray = new MacroSummary[macrosList.size()];
        return macrosList.toArray(macrosListArray);
    }

    public TypeSummary[] getTypesWithPrefix(String prefix) {
        if (this.helpBooks == null) {
            this.createIndexExtractors();
        }
        HashMap<String, Item> mainMap = new HashMap<String, Item>();
        ArrayList<TypeSummary> typesList = new ArrayList<TypeSummary>();
        int i = 0;
        while (i < this.getIndexExtractors().size()) {
            HashMap<String, Item> hashMap = this.getIndexExtractors().get(i).getItemMap();
            if (hashMap.size() > 0) {
                mainMap.putAll(hashMap);
            }
            ++i;
        }
        Set c = mainMap.entrySet();
        for (Map.Entry e : c) {
            Item item = (Item)e.getValue();
            if (!(item instanceof ItemType) || !item.getName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
            TypeSummary t = new TypeSummary();
            t.setName(item.getName());
            t.setNamespace(item.getNamespace());
            typesList.add(t);
        }
        TypeSummary[] typesListArray = new TypeSummary[typesList.size()];
        return typesList.toArray(typesListArray);
    }

    public VariableSummary[] getVariablesWithPrefix(String prefix) {
        if (this.helpBooks == null) {
            this.createIndexExtractors();
        }
        HashMap<String, Item> mainMap = new HashMap<String, Item>();
        ArrayList<VariableSummary> variablesList = new ArrayList<VariableSummary>();
        int i = 0;
        while (i < this.getIndexExtractors().size()) {
            HashMap<String, Item> hashMap = this.getIndexExtractors().get(i).getItemMap();
            if (hashMap.size() > 0) {
                mainMap.putAll(hashMap);
            }
            ++i;
        }
        Set c = mainMap.entrySet();
        for (Map.Entry e : c) {
            Item item = (Item)e.getValue();
            if (!(item instanceof ItemVariable) || !item.getName().toLowerCase().startsWith(prefix.toLowerCase())) continue;
            VariableSummary v = new VariableSummary();
            v.setName(item.getName());
            v.setNamespace(item.getNamespace());
            v.setPrototype(item.getPrototype());
            variablesList.add(v);
        }
        VariableSummary[] variablesListArray = new VariableSummary[variablesList.size()];
        return variablesList.toArray(variablesListArray);
    }

    public String getPathEntry(Item item) {
        int i = 0;
        while (i < this.getIndexExtractors().size()) {
            if (this.getIndexExtractors().get(i).getItemMap().containsKey(item.getName())) {
                try {
                    return InstallPathConfig.getSDKPath();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    protected void addHelpBook(String name, String type) {
        this.helpBooks.add(new HelpBook(name, type));
    }

    public ArrayList<ICHelpBook> getHelpBooks() {
        if (this.helpBooks == null) {
            this.createIndexExtractors();
        }
        return this.helpBooks;
    }

    public ArrayList<String> prefixes(int cutOffOccurences) {
        HashMap<String, Integer> prefixes = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.getIndexExtractors().size()) {
            if (this.getIndexExtractors().get(i).generatePrefixes()) {
                HashMap<String, Item> map = this.getIndexExtractors().get(i).getItemMap();
                for (String s : map.keySet()) {
                    if (s.length() > 3) {
                        s = s.substring(0, 3);
                    }
                    if (prefixes.containsKey(s)) {
                        Integer num = (Integer)prefixes.get(s) + 1;
                        prefixes.remove(s);
                        prefixes.put(s, num);
                        continue;
                    }
                    prefixes.put(s, 1);
                }
            }
            ++i;
        }
        return new ArrayList<String>(prefixes.keySet());
    }

    private LinkedHashMap<String, Integer> sortHashMapByValues(HashMap<String, Integer> inputMap) {
        ArrayList<String> mapKeys = new ArrayList<String>(inputMap.keySet());
        ArrayList<Integer> mapValues = new ArrayList<Integer>(inputMap.values());
        Collections.sort(mapValues);
        Collections.sort(mapKeys);
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        block0: for (Integer val : mapValues) {
            for (String key : mapKeys) {
                String comp2;
                String comp1 = inputMap.get(key).toString();
                if (!comp1.equals(comp2 = val.toString())) continue;
                inputMap.remove(key);
                mapKeys.remove(key);
                sortedMap.put(key, val);
                continue block0;
            }
        }
        return sortedMap;
    }
}

