/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecore.misc.editor.XMLErrorHandler;
import org.xml.sax.SAXException;

public class ManifestSchemaValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String MANIFEST_MARKER_ID = "org.tizen.nativecore.misc.manifestProblem";
    public static final String VALIDATION_SCHEMAS_DIR = "schema";

    public void validateConfigurationDocument(IFile configFile, String[] schemaFileNames) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (schemaFileNames != null) {
            Source[] sources = new Source[schemaFileNames.length];
            BufferedInputStream[] bis = new BufferedInputStream[schemaFileNames.length];
            try {
                int i = 0;
                int sourcesLength = sources.length;
                while (i < sourcesLength) {
                    String schemaFileName = "schema/" + schemaFileNames[i];
                    bis[i] = new BufferedInputStream(this.getXSDInputStream(schemaFileName));
                    sources[i] = new StreamSource(bis[i]);
                    ++i;
                }
                Schema schema = factory.newSchema(sources);
                Validator validator = schema.newValidator();
                validator.setErrorHandler(new XMLErrorHandler(configFile));
                StreamSource source = new StreamSource(configFile.getLocation().toFile());
                configFile.deleteMarkers(MANIFEST_MARKER_ID, true, 2);
                validator.validate(source);
            }
            catch (SAXException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private InputStream getXSDInputStream(String schemaFileName) {
        return ManifestSchemaValidator.class.getClassLoader().getResourceAsStream(schemaFileName);
    }
}

