/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.rm.ui.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativecommon.rm.model.ITizenRMFeature;
import org.tizen.nativecommon.rm.model.RMHandler;
import org.tizen.nativecommon.rm.model.ResConfig;
import org.tizen.nativecommon.rm.ui.view.TizenRMMessages;

public class ConfigDialog
extends Dialog {
    private RMHandler rmHandler;
    private Combo localeCombo;
    private Combo dpiCombo;
    private TableViewer rmFeatureTableViewer;
    private Button addBtn;
    private boolean isSave = false;
    private static Image DELETE_IMAGE = ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/obj16/delete.png").createImage();

    protected ConfigDialog(Shell parentShell) {
        super(parentShell);
    }

    protected ConfigDialog(Shell parentShell, RMHandler rmHandler) {
        super(parentShell);
        this.rmHandler = rmHandler;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TizenRMMessages.DIALOG_TITLE);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)new GridData(1808));
        this.createHeader(composite);
        this.createBody(composite);
        return composite;
    }

    private void createBody(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = GridLayoutFactory.fillDefaults().create();
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(1810));
        this.rmFeatureTableViewer = new TableViewer(comp, 67588);
        this.rmFeatureTableViewer.getControl().setLayoutData((Object)new GridData(1810));
        TableViewerColumn dirColumn = this.createTableViewerColumn(this.rmFeatureTableViewer, TizenRMMessages.VIEW_LABEL_TITLE_DIRECTORY, 200, 16384, 0);
        dirColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResConfig.Item item = (ResConfig.Item)element;
                return item.getDir();
            }
        });
        TableViewerColumn localeColumn = this.createTableViewerColumn(this.rmFeatureTableViewer, TizenRMMessages.VIEW_LABEL_TITLE_LANGUAGE, 100, 16384, 1);
        localeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                ResConfig.Item item = (ResConfig.Item)element;
                return item.getLocaleImage();
            }

            public String getText(Object element) {
                ResConfig.Item item = (ResConfig.Item)element;
                return item.getLocaleName();
            }
        });
        TableViewerColumn resolutionColumn = this.createTableViewerColumn(this.rmFeatureTableViewer, TizenRMMessages.VIEW_LABEL_TITLE_RESOLUTION, 100, 16384, 2);
        resolutionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResConfig.Item item = (ResConfig.Item)element;
                return item.getResolutionToString();
            }
        });
        TableViewerColumn deleteColumn = this.createTableViewerColumn(this.rmFeatureTableViewer, TizenRMMessages.DIALOG_TABLE_COLUMN_DELETE, 100, 0x1000000, 3);
        deleteColumn.setLabelProvider((CellLabelProvider)new CenterAlignmentLabelProvider(){

            @Override
            protected Image getImage(Object element) {
                return DELETE_IMAGE;
            }
        });
        deleteColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.rmFeatureTableViewer){

            protected boolean canEdit(Object element) {
                ResConfig.Item item = (ResConfig.Item)element;
                ConfigDialog.this.rmHandler.removeItem(item, false);
                ConfigDialog.this.rmFeatureTableViewer.setInput((Object)ConfigDialog.this.makeInput());
                return false;
            }

            protected CellEditor getCellEditor(Object arg0) {
                return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
            }

            protected Object getValue(Object arg0) {
                return "";
            }

            protected void setValue(Object element, Object arg1) {
                this.getViewer().update(element, null);
            }
        });
        Table table = this.rmFeatureTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.rmFeatureTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.rmFeatureTableViewer.setInput(this.makeInput());
        this.rmFeatureTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((ResConfig.Item)e1).compareTo((ResConfig.Item)e2);
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer tv, String title, int bound, int align, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tv, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        column.setAlignment(align);
        return viewerColumn;
    }

    private void createHeader(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = GridLayoutFactory.swtDefaults().create();
        gl = new GridLayout();
        gl.numColumns = 3;
        comp.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.grabExcessVerticalSpace = false;
        comp.setLayoutData((Object)gd);
        ArrayList<String> localesStr = new ArrayList<String>();
        ITizenRMFeature[] iTizenRMFeatureArray = RMHandler.getLocales();
        int n = iTizenRMFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITizenRMFeature feature = iTizenRMFeatureArray[n2];
            localesStr.add(feature.toString());
            ++n2;
        }
        Image dpi = ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/obj16/dpi_all.png").createImage();
        Image locale = ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/obj16/locale.png").createImage();
        this.localeCombo = this.createCombo(comp, TizenRMMessages.DIALOG_TABLE_COLUMN_LOCALE, locale, RMHandler.getLocales());
        this.localeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigDialog.this.addBtn != null) {
                    ConfigDialog.this.addBtn.setEnabled(ConfigDialog.this.canAdd());
                }
            }
        });
        this.dpiCombo = this.createCombo(comp, TizenRMMessages.DIALOG_LABEL_DPI, dpi, RMHandler.getDPIs());
        this.dpiCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigDialog.this.addBtn != null) {
                    ConfigDialog.this.addBtn.setEnabled(ConfigDialog.this.canAdd());
                }
            }
        });
        this.addBtn = this.createButton(comp, 100, TizenRMMessages.DIALOG_BUTTON_ADD, false);
        this.addBtn.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                String locale = ConfigDialog.this.localeCombo.getItem(ConfigDialog.this.localeCombo.getSelectionIndex());
                String dpi = ConfigDialog.this.dpiCombo.getItem(ConfigDialog.this.dpiCombo.getSelectionIndex());
                ITizenRMFeature localeFeature = (ITizenRMFeature)ConfigDialog.this.localeCombo.getData(locale);
                ITizenRMFeature dpiFeature = (ITizenRMFeature)ConfigDialog.this.dpiCombo.getData(dpi);
                HashSet<ITizenRMFeature> rmFeatures = new HashSet<ITizenRMFeature>();
                rmFeatures.add(localeFeature);
                rmFeatures.add(dpiFeature);
                ConfigDialog.this.rmHandler.addFeatures(rmFeatures);
                ConfigDialog.this.isSave = true;
                ConfigDialog.this.rmFeatureTableViewer.setInput((Object)ConfigDialog.this.makeInput());
                ConfigDialog.this.addBtn.setEnabled(ConfigDialog.this.canAdd());
            }
        });
        this.addBtn.setEnabled(false);
    }

    private Combo createCombo(Composite parent, String text, Image image, ITizenRMFeature[] features) {
        Label l;
        Composite comp = new Composite(parent, 0);
        GridLayout gl = GridLayoutFactory.fillDefaults().create();
        gl.numColumns = 3;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(768));
        if (image != null) {
            l = new Label(comp, 0);
            l.setImage(image);
        }
        l = new Label(comp, 0);
        l.setText(text);
        Combo c = new Combo(comp, 8);
        c.setLayoutData((Object)new GridData(768));
        ArrayList<String> strList = new ArrayList<String>();
        ITizenRMFeature[] iTizenRMFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ITizenRMFeature feature = iTizenRMFeatureArray[n2];
            strList.add(feature.getName());
            c.setData(feature.getName(), (Object)feature);
            ++n2;
        }
        c.setItems(strList.toArray(new String[strList.size()]));
        c.setText((String)strList.get(0));
        return c;
    }

    private Set<ResConfig.Item> makeInput() {
        Set<ResConfig.Item> items = this.rmHandler.getSupportedType();
        return items;
    }

    private boolean canAdd() {
        String locale = this.localeCombo.getItem(this.localeCombo.getSelectionIndex());
        String dpi = this.dpiCombo.getItem(this.dpiCombo.getSelectionIndex());
        ITizenRMFeature localeFeature = (ITizenRMFeature)this.localeCombo.getData(locale);
        ITizenRMFeature dpiFeature = (ITizenRMFeature)this.dpiCombo.getData(dpi);
        if (localeFeature.isDefault() && dpiFeature.isDefault()) {
            return false;
        }
        HashSet<ITizenRMFeature> rmFeatures = new HashSet<ITizenRMFeature>();
        rmFeatures.add(localeFeature);
        rmFeatures.add(dpiFeature);
        return !this.rmHandler.existsItem(rmFeatures);
    }

    public int open() {
        this.isSave = false;
        return super.open();
    }

    public boolean close() {
        if (this.isSave) {
            Job saveJob = new Job("Saving build options"){

                protected IStatus run(IProgressMonitor arg0) {
                    ConfigDialog.this.rmHandler.saveBuildOption();
                    if (arg0 != null) {
                        arg0.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            saveJob.schedule();
        }
        return super.close();
    }

    public static abstract class CenterAlignmentLabelProvider
    extends OwnerDrawLabelProvider {
        protected void measure(Event arg0, Object arg1) {
        }

        protected void paint(Event event, Object element) {
            Image img = this.getImage(element);
            if (img != null) {
                Rectangle bounds = ((TableItem)event.item).getBounds(event.index);
                Rectangle imgBounds = img.getBounds();
                bounds.width /= 2;
                bounds.width -= imgBounds.width / 2;
                bounds.height /= 2;
                bounds.height -= imgBounds.height / 2;
                int x = bounds.width > 0 ? bounds.x + bounds.width : bounds.x;
                int y = bounds.height > 0 ? bounds.y + bounds.height : bounds.y;
                event.gc.drawImage(img, x, y);
            }
        }

        protected abstract Image getImage(Object var1);
    }
}

