/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.templateengine.build;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.util.XMLUtil;
import org.tizen.common.util.ParsingUtil;
import org.tizen.nativecommon.build.model.SBIModel;
import org.tizen.nativecommon.templateengine.build.AbstractProjectGenerator;
import org.tizen.nativecommon.templateengine.build.Messages;
import org.tizen.nativecommon.templateengine.build.model.BuildProperty;
import org.tizen.nativecommon.templateengine.build.model.DevPackageModel;
import org.tizen.nativecommon.templateengine.build.model.RootstrapModel;
import org.tizen.nativecommon.templateengine.build.model.TargetModel;
import org.tizen.nativecommon.templateengine.build.model.ToolchainModel;
import org.tizen.nativecommon.templateengine.build.util.BuildPluginUtil;
import org.tizen.nativecommon.templateengine.model.TizenTemplate;
import org.w3c.dom.Element;

public class BuildPluginManagerForCLI {
    public static final HashMap<String, HashMap<String, DevPackageModel>> DEVPKG_MAP = new HashMap();
    private static final ArrayList<ToolchainModel> tcList = new ArrayList();
    private static final ArrayList<RootstrapModel> rootstrapList = new ArrayList();
    private static Logger logger = LoggerFactory.getLogger(BuildPluginManagerForCLI.class);

    static {
        BuildPluginManagerForCLI.initializeTcAndRootstrap();
        BuildPluginManagerForCLI.initializeDevPkg();
        if (DEVPKG_MAP.size() == 0) {
            logger.error(Messages.getString("BuildPluginManagerForCLI.ExceptionNoApplicableDevpkg1"));
        }
    }

    private static void initializeTcAndRootstrap() {
        File[] files;
        File dir = new File(BuildPluginUtil.DIR_SBI_PLUGIN);
        if (!dir.exists()) {
            logger.error(MessageFormat.format(Messages.getString("BuildPluginManagerForCLI.ExceptionSBINotExist"), dir.getPath()));
            return;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String rootTagName;
                File file = fileArray[n2];
                Element root = null;
                try {
                    root = XMLUtil.getDocumentRootFromFile((File)file);
                }
                catch (Exception exception) {
                    logger.warn(MessageFormat.format(Messages.getString("BuildPluginManagerForCLI.ExceptionParsingSBIPlugin"), file.getPath()));
                    break block9;
                }
                if (root != null && (rootTagName = root.getTagName()).equals("extension")) {
                    String extId = root.getAttribute("point");
                    if ("rootstrapDefinition".equals(extId)) {
                        rootstrapList.add(BuildPluginManagerForCLI.createRootstrapModelFromRoot(root));
                    }
                    if ("toolchainDefinition".equals(extId)) {
                        tcList.add(BuildPluginManagerForCLI.createToolchainModelFromRoot(root));
                    }
                }
            }
            ++n2;
        }
        if (rootstrapList.size() == 0) {
            logger.error(MessageFormat.format(Messages.getString("BuildPluginManagerForCLI.ExceptionNoApplicableRootstrap"), BuildPluginUtil.DIR_SBI_PLUGIN));
        }
        if (tcList.size() == 0) {
            logger.error(MessageFormat.format(Messages.getString("BuildPluginManagerForCLI.ExceptionNoApplicableToolchain"), BuildPluginUtil.DIR_SBI_PLUGIN));
        }
    }

    private static void initializeDevPkg() {
        for (RootstrapModel rootstrap : rootstrapList) {
            String devPkgPath = rootstrap.getDevPkgPath();
            File devPkgFile = new File(devPkgPath);
            Element root = null;
            try {
                root = XMLUtil.getDocumentRootFromFile((File)devPkgFile);
            }
            catch (Exception exception) {
                logger.error(MessageFormat.format(Messages.getString("BuildPluginManagerForCLI.ExceptionParsingDevPkg"), devPkgPath));
                continue;
            }
            if (root != null) {
                HashMap<String, DevPackageModel> devMap = BuildPluginManagerForCLI.createDevPkgMap(root);
                if (devMap.size() <= 0) continue;
                DEVPKG_MAP.put(rootstrap.getId(), BuildPluginManagerForCLI.createDevPkgMap(root));
                continue;
            }
            logger.warn(MessageFormat.format(Messages.getString("BuildPluginManagerForCLI.ExceptionNoApplicableDevPkg2"), rootstrap.getId()));
        }
    }

    private static HashMap<String, DevPackageModel> createDevPkgMap(Element root) {
        HashMap<String, DevPackageModel> result = new HashMap<String, DevPackageModel>();
        List devPkgElementList = XMLUtil.getElementsByTag((Element)root, (String)"DevPackage");
        for (Element devPkgElement : devPkgElementList) {
            DevPackageModel devPkg = BuildPluginManagerForCLI.createDevPkg(devPkgElement);
            if (devPkg == null) continue;
            result.put(devPkg.getName(), devPkg);
        }
        BuildPluginManagerForCLI.resolveVirtualAndDependencyPkg(result);
        return result;
    }

    private static void resolveVirtualAndDependencyPkg(HashMap<String, DevPackageModel> devPkgMap) {
        Collection<DevPackageModel> devPkgCollection = devPkgMap.values();
        for (DevPackageModel devPkg : devPkgCollection) {
            BuildPluginManagerForCLI.resolveDevPkg(devPkg, devPkgMap);
        }
    }

    private static void resolveDevPkg(DevPackageModel _devPkg, HashMap<String, DevPackageModel> devPkgMap) {
        if (_devPkg.isResolved()) {
            return;
        }
        HashSet<DevPackageModel> dependencyChecker = new HashSet<DevPackageModel>();
        Stack devPkgRootStack = new Stack();
        LinkedList<DevPackageModel> _devPkgQueue = new LinkedList<DevPackageModel>();
        _devPkgQueue.add(_devPkg);
        devPkgRootStack.push(_devPkgQueue);
        while (!devPkgRootStack.isEmpty()) {
            LinkedList devPkgQueue = (LinkedList)devPkgRootStack.lastElement();
            if (devPkgQueue.isEmpty()) {
                devPkgRootStack.removeElementAt(devPkgRootStack.size() - 1);
                continue;
            }
            DevPackageModel devPkg = (DevPackageModel)devPkgQueue.getFirst();
            dependencyChecker.add(devPkg);
            List<String> dependencyList = devPkg.getDependencyList();
            LinkedList<DevPackageModel> nextList = new LinkedList<DevPackageModel>();
            BuildPluginManagerForCLI.checkDependencyAndResolve(dependencyList, devPkgMap, dependencyChecker, nextList);
            List<String> incPkgList = devPkg.getIncludePackageList();
            BuildPluginManagerForCLI.checkDependencyAndResolve(incPkgList, devPkgMap, dependencyChecker, nextList);
            if (nextList.isEmpty()) {
                devPkgQueue.removeFirst();
                devPkg.setResolved(true);
                for (String dependency : dependencyList) {
                    DevPackageModel depDevPackageModel = devPkgMap.get(dependency);
                    BuildPluginManagerForCLI.mergeFlags(devPkg, depDevPackageModel);
                }
                for (String incPkg : incPkgList) {
                    DevPackageModel incDevPackageModel = devPkgMap.get(incPkg);
                    BuildPluginManagerForCLI.mergeFlags(devPkg, incDevPackageModel);
                }
                continue;
            }
            devPkgRootStack.push(nextList);
        }
    }

    private static void checkDependencyAndResolve(List<String> subPkgList, HashMap<String, DevPackageModel> devPkgMap, HashSet<DevPackageModel> dependencyChecker, LinkedList<DevPackageModel> nextList) {
        for (String dependency : subPkgList) {
            DevPackageModel depDevPkg = devPkgMap.get(dependency);
            if (depDevPkg.isResolved()) continue;
            if (dependencyChecker.contains(depDevPkg)) {
                logger.error(MessageFormat.format(Messages.getString("BuildPluginManagerForCLI.ExceptionCyclingDependencyDetected"), depDevPkg.getName()));
                continue;
            }
            nextList.add(depDevPkg);
        }
    }

    private static void mergeFlags(DevPackageModel devPkg, DevPackageModel depDevPkg) {
        List<String> includePathList = depDevPkg.getIncludePathList();
        List<String> libraryList = depDevPkg.getLibraryList();
        List<String> libraryPathList = depDevPkg.getLibraryPathList();
        List<String> otherCFlagList = depDevPkg.getOtherCFlagList();
        List<String> otherLFlagList = depDevPkg.getOtherLFlagList();
        for (String includePath : includePathList) {
            devPkg.addIncludePath(includePath);
        }
        for (String library : libraryList) {
            devPkg.addLibrary(library);
        }
        for (String libraryPath : libraryPathList) {
            devPkg.addLibraryPath(libraryPath);
        }
        for (String otherCflag : otherCFlagList) {
            devPkg.addOtherCFlag(otherCflag);
        }
        for (String otherLFlag : otherLFlagList) {
            devPkg.addOtherLFlag(otherLFlag);
        }
    }

    private static DevPackageModel createDevPkg(Element devPkgElement) {
        if (devPkgElement == null) {
            return null;
        }
        String name = devPkgElement.getAttribute("name");
        boolean isFramework = ParsingUtil.parseBoolean((String)devPkgElement.getAttribute("is_framework"), (boolean)false);
        boolean isVirtual = ParsingUtil.parseBoolean((String)devPkgElement.getAttribute("is_virtual"), (boolean)false);
        DevPackageModel devPkg = new DevPackageModel(name, isFramework, isVirtual);
        List incPkgList = XMLUtil.getElementsByTag((Element)devPkgElement, (String)"include_package");
        for (Element incPkg : incPkgList) {
            devPkg.addIncludePackage(incPkg.getTextContent());
        }
        List incPathList = XMLUtil.getElementsByTag((Element)devPkgElement, (String)"include_path");
        for (Element incPath : incPathList) {
            devPkg.addIncludePath(incPath.getTextContent());
        }
        List libraryPathList = XMLUtil.getElementsByTag((Element)devPkgElement, (String)"library_path");
        for (Element libraryPath : libraryPathList) {
            devPkg.addLibraryPath(libraryPath.getTextContent());
        }
        List libraryList = XMLUtil.getElementsByTag((Element)devPkgElement, (String)"library");
        for (Element library : libraryList) {
            devPkg.addLibrary(library.getTextContent());
        }
        List dependencyList = XMLUtil.getElementsByTag((Element)devPkgElement, (String)"dependency");
        for (Element dependency : dependencyList) {
            devPkg.addDepenency(dependency.getTextContent());
        }
        List cFLagList = XMLUtil.getElementsByTag((Element)devPkgElement, (String)"other_cflag");
        for (Element cFlag : cFLagList) {
            devPkg.addOtherCFlag(cFlag.getTextContent());
        }
        List lFlagList = XMLUtil.getElementsByTag((Element)devPkgElement, (String)"other_lflag");
        for (Element lFlag : lFlagList) {
            devPkg.addOtherLFlag(lFlag.getTextContent());
        }
        return devPkg;
    }

    private static RootstrapModel createRootstrapModelFromRoot(Element root) {
        Element rootstrapElement = (Element)XMLUtil.getElementsByTag((Element)root, (String)"rootstrap").get(0);
        String id = rootstrapElement.getAttribute("id");
        String devPkgPath = BuildPluginUtil.getPropertyValueByKey(rootstrapElement, "DEV_PACKAGE_CONFIG_PATH").replace("#{SBI_HOME}", BuildPluginUtil.DIR_SBI_HOME);
        boolean isProvideVirtualEnv = false;
        if (ParsingUtil.parseBoolean((String)BuildPluginUtil.getPropertyValueByKey(rootstrapElement, "SUPPORT_VIRTUAL_ENVIRONMENT"), (boolean)false)) {
            isProvideVirtualEnv = true;
        }
        String supportedToolChain = rootstrapElement.getAttribute("supportToolchainType");
        String version = rootstrapElement.getAttribute("version");
        String arch = rootstrapElement.getAttribute("architecture");
        String defaultCf = BuildPluginUtil.getPropertyValueByKey(rootstrapElement, "COMPILER_MISCELLANEOUS_OPTION").replace("#{SBI_HOME}", BuildPluginUtil.DIR_SBI_HOME);
        String defaultLf = BuildPluginUtil.getPropertyValueByKey(rootstrapElement, "LINKER_MISCELLANEOUS_OPTION").replace("#{SBI_HOME}", BuildPluginUtil.DIR_SBI_HOME);
        RootstrapModel rootstrap = new RootstrapModel(id, devPkgPath, supportedToolChain, arch, isProvideVirtualEnv, defaultCf, defaultLf, version);
        return rootstrap;
    }

    private static ToolchainModel createToolchainModelFromRoot(Element root) {
        Element toolchainElement = (Element)XMLUtil.getElementsByTag((Element)root, (String)"toolchain").get(0);
        String id = toolchainElement.getAttribute("id");
        String architecture = toolchainElement.getAttribute("architecture");
        String type = toolchainElement.getAttribute("toolchainType");
        String name = toolchainElement.getAttribute("name");
        String projectType = BuildPluginUtil.getPropertyValueByKey(toolchainElement, "PROJECT_TYPE");
        boolean defaultTc = ParsingUtil.parseBoolean((String)BuildPluginUtil.getPropertyValueByKey(toolchainElement, "DEFAULT"), (boolean)false);
        String defaultCf = BuildPluginUtil.getPropertyValueByKey(toolchainElement, "COMPILER_MISCELLANEOUS_OPTION");
        defaultCf = defaultCf.replace("#{SBI_HOME}", BuildPluginUtil.DIR_SBI_HOME);
        String defaultLf = BuildPluginUtil.getPropertyValueByKey(toolchainElement, "LINKER_MISCELLANEOUS_OPTION");
        String makePath = BuildPluginUtil.getToolPathByName(toolchainElement, "make");
        defaultLf = defaultLf.replace("#{SBI_HOME}", BuildPluginUtil.DIR_SBI_HOME);
        ToolchainModel tc = new ToolchainModel(id, type, projectType, defaultCf, defaultLf, architecture, defaultTc, name, makePath);
        return tc;
    }

    public static TargetModel getDefaultTarget(String projectType, String arch) {
        if (projectType == null || arch == null) {
            return null;
        }
        ToolchainModel defaultTc = null;
        for (ToolchainModel tc : tcList) {
            if (!arch.equals(tc.getArchitecture()) || !projectType.equals(tc.getProjectType())) continue;
            if (tc.isDefault()) {
                defaultTc = tc;
                break;
            }
            if (defaultTc != null) continue;
            defaultTc = tc;
        }
        if (defaultTc == null) {
            return null;
        }
        RootstrapModel defaultRootstrap = null;
        String toolchainType = defaultTc.getType();
        for (RootstrapModel rootstrap : rootstrapList) {
            if (!arch.equals(rootstrap.getArch()) || !toolchainType.equals(rootstrap.getSupportedToolChain())) continue;
            defaultRootstrap = rootstrap;
            return new TargetModel(String.valueOf(defaultRootstrap.getId()) + "_" + defaultTc.getId(), defaultTc, defaultRootstrap);
        }
        for (RootstrapModel rootstrap : rootstrapList) {
            if (!arch.equals(SBIModel.getBaseArchName(rootstrap.getArch())) || !toolchainType.equals(rootstrap.getSupportedToolChain())) continue;
            defaultRootstrap = rootstrap;
            return new TargetModel(String.valueOf(defaultRootstrap.getId()) + "_" + defaultTc.getId(), defaultTc, defaultRootstrap);
        }
        return null;
    }

    public static TargetModel getTarget(String tcId, String rsId) {
        ToolchainModel tc = null;
        for (ToolchainModel t : tcList) {
            if (!t.getId().equals(tcId)) continue;
            tc = t;
            break;
        }
        RootstrapModel rs = null;
        for (RootstrapModel r : rootstrapList) {
            if (!r.getId().equals(rsId)) continue;
            rs = r;
            break;
        }
        if (tc != null && rs != null) {
            return new TargetModel(String.valueOf(rsId) + "_" + tcId, tc, rs);
        }
        return null;
    }

    public static DevPackageModel getDevPackageModel(String rootstrapId, String devPkgName) {
        HashMap<String, DevPackageModel> pkgMap = DEVPKG_MAP.get(rootstrapId);
        return pkgMap.get(devPkgName);
    }

    public static BuildProperty getBuildPropertyFromDevPkgs(List<DevPackageModel> devPackageList, TizenTemplate template, TargetModel target, AbstractProjectGenerator generator) {
        if (target != null) {
            generator.addDefaultIncludePaths(template, target);
            generator.addDefaultCFlags(template, target);
            generator.addDefaultLFlags(template, target);
            generator.addIncludePathFromDevPkg(template, target, devPackageList);
            generator.addCFlagFromDevPkg(template, target, devPackageList);
            generator.addLFlagFromDevPkg(template, target, devPackageList);
        }
        return generator.getBuildProperty();
    }
}

