/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.build.model;

import java.util.ArrayList;
import org.tizen.nativeappcommon.build.model.DevPackage;

public class DevPackageTreeItem {
    private boolean isChecked;
    private boolean isGrayed;
    private ArrayList<DevPackageTreeItem> children;
    private DevPackageTreeItem parent;
    private DevPackage pkg;

    public DevPackageTreeItem(DevPackage pkg) {
        this.pkg = pkg;
        this.children = new ArrayList();
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public boolean isGrayed() {
        return this.isGrayed;
    }

    public void setGrayed(boolean isGrayed) {
        this.isGrayed = isGrayed;
    }

    public ArrayList<DevPackageTreeItem> getChildren() {
        return this.children;
    }

    public void addChild(DevPackageTreeItem child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public void removeChild(DevPackageTreeItem child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public ArrayList<String> getDependency() {
        return this.pkg.getDependencyList();
    }

    public DevPackageTreeItem getParent() {
        return this.parent;
    }

    public void setParent(DevPackageTreeItem parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.pkg.getName();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean isVirtual() {
        return this.pkg.isVirtulalPackage();
    }

    public String getDescription() {
        return this.pkg.getDescription();
    }
}

