/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text.doctools.doxygen;

import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.ui.text.doctools.doxygen.DoxygenMultilineAutoEditStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class DoxygenSingleAutoEditStrategy
extends DoxygenMultilineAutoEditStrategy {
    private static final String SLASH_COMMENT = "///";
    private static final String EXCL_COMMENT = "//!";
    private static String fgDefaultLineDelim = "\n";

    @Override
    public void customizeDocumentCommand(IDocument doc, DocumentCommand cmd) {
        fgDefaultLineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        if (doc instanceof IDocumentExtension4) {
            boolean forNewLine;
            boolean bl = forNewLine = cmd.length == 0 && cmd.text != null && DoxygenSingleAutoEditStrategy.endsWithDelimiter(doc, cmd.text);
            if (forNewLine) {
                IDocumentExtension4 ext4 = (IDocumentExtension4)doc;
                DocumentRewriteSession drs = ext4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
                try {
                    this.customizeDocumentAfterNewLine(doc, cmd);
                }
                finally {
                    ext4.stopRewriteSession(drs);
                }
            }
        }
    }

    @Override
    public void customizeDocumentAfterNewLine(IDocument doc, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || doc.getLength() == 0) {
            return;
        }
        StringBuilder buf = new StringBuilder(c.text);
        try {
            boolean firstLineContainsText;
            IRegion line = doc.getLineInformationOfOffset(c.offset);
            String lineDelimiter = doc.getLineDelimiter(doc.getLineOfOffset(c.offset));
            int lineDelimiterLength = lineDelimiter.length();
            IRegion prefix = DoxygenSingleAutoEditStrategy.findPrefixRange(doc, line);
            String indentationWithPrefix = doc.get(prefix.getOffset(), prefix.getLength());
            String commentPrefix = this.getCommentPrefix(indentationWithPrefix);
            String commentContent = doc.get(prefix.getOffset() + prefix.getLength(), line.getLength() - prefix.getLength());
            String commentContentBehindCursor = doc.get(c.offset, line.getLength() - (c.offset - line.getOffset()));
            buf.append(indentationWithPrefix);
            boolean commentAtStart = prefix.getOffset() + prefix.getLength() <= c.offset;
            boolean commentFollows = false;
            boolean commentAhead = false;
            boolean bl = firstLineContainsText = commentContent.trim().length() > 0;
            if (commentAtStart) {
                if (line.getOffset() + line.getLength() + lineDelimiterLength < doc.getLength()) {
                    IRegion nextLine = doc.getLineInformationOfOffset(line.getOffset() + line.getLength() + lineDelimiterLength);
                    commentFollows = doc.get(nextLine.getOffset(), nextLine.getLength()).trim().startsWith(commentPrefix);
                    if (line.getOffset() >= 1) {
                        IRegion previousLine = doc.getLineInformationOfOffset(line.getOffset() - 1);
                        commentAhead = doc.get(previousLine.getOffset(), previousLine.getLength()).trim().startsWith(commentPrefix);
                    }
                }
                buf.append(" ");
            }
            c.shiftsCaret = false;
            c.caretOffset = c.offset + buf.length();
            if (commentAtStart && !commentFollows && !commentAhead) {
                try {
                    boolean contentAlreadyThere;
                    StringBuilder content = this.getDeclarationLines(doc, offset);
                    boolean bl2 = contentAlreadyThere = firstLineContainsText && content.toString().contains(commentContentBehindCursor.trim());
                    if (content == null || content.toString().trim().length() == 0 || contentAlreadyThere) {
                        buf.setLength(0);
                        buf.append(fgDefaultLineDelim);
                        buf.append(String.valueOf(indentationWithPrefix) + " ");
                        c.shiftsCaret = false;
                        c.caretOffset = c.offset + buf.length();
                    } else {
                        if (!firstLineContainsText) {
                            c.shiftsCaret = false;
                            c.caretOffset = c.offset + 1;
                            buf.setLength(0);
                            buf.append(" " + DoxygenSingleAutoEditStrategy.indent(content, String.valueOf(indentationWithPrefix) + " ", fgDefaultLineDelim).substring((String.valueOf(indentationWithPrefix) + " ").length()));
                        } else {
                            buf.append(fgDefaultLineDelim);
                            buf.append((CharSequence)DoxygenSingleAutoEditStrategy.indent(content, String.valueOf(indentationWithPrefix) + " ", fgDefaultLineDelim));
                        }
                        buf.setLength(buf.length() - fgDefaultLineDelim.length());
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private StringBuilder getDeclarationLines(IDocument doc, int offset) throws BadLocationException {
        IASTNodeSelector ans;
        IASTNode node;
        IASTDeclaration dec = null;
        IASTTranslationUnit ast = this.getAST();
        if (ast != null && (dec = DoxygenSingleAutoEditStrategy.findFollowingDeclaration(ast, offset)) == null && (node = (ans = ast.getNodeSelector(ast.getFilePath())).findEnclosingNode(offset, 0)) instanceof IASTDeclaration) {
            dec = (IASTDeclaration)node;
        }
        if (dec != null) {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)false);
            return this.customizeAfterNewLineForDeclaration(doc, dec, partition);
        }
        return null;
    }

    private String getCommentPrefix(String indent) throws BadLocationException {
        if (indent.endsWith(SLASH_COMMENT)) {
            return SLASH_COMMENT;
        }
        return EXCL_COMMENT;
    }

    protected static IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = DoxygenSingleAutoEditStrategy.findEndOfWhiteSpaceAt(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd - 2 && document.getChar(indentEnd) == '/' && document.getChar(indentEnd + 1) == '/' && (document.getChar(indentEnd + 2) == '/' || document.getChar(indentEnd + 2) == '!')) {
            indentEnd += 3;
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }
}

