/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.internal.core.StreamProgressMonitor;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class BuildRunnerHelper
implements Closeable {
    private static final String PROGRESS_MONITOR_QUALIFIER = "org.eclipse.cdt.core.progressMonitor";
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_STREAM_PROGRESS_MONITOR = 100;
    private static final int TICKS_EXECUTE_PROGRAM = 100;
    private static final int TICKS_PARSE_OUTPUT = 100;
    private IProject project;
    private IConsole console = null;
    private ErrorParserManager errorParserManager = null;
    private StreamProgressMonitor streamProgressMonitor = null;
    private OutputStream stdout = null;
    private OutputStream stderr = null;
    private OutputStream consoleOut = null;
    private OutputStream consoleInfo = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private QualifiedName progressPropertyName = null;
    private ICommandLauncher launcher;
    private IPath buildCommand;
    private String[] args;
    private URI workingDirectoryURI;
    String[] envp;
    private boolean isStreamsOpen = false;
    boolean isCancelled = false;

    public BuildRunnerHelper(IProject project) {
        this.project = project;
    }

    public void setLaunchParameters(ICommandLauncher launcher, IPath buildCommand, String[] args, URI workingDirectoryURI, String[] envp) {
        this.launcher = launcher;
        launcher.setProject(this.project);
        launcher.showCommand(true);
        this.buildCommand = buildCommand;
        this.args = args;
        this.workingDirectoryURI = workingDirectoryURI;
        this.envp = envp;
    }

    public void prepareStreams(ErrorParserManager epm, List<IConsoleParser> buildOutputParsers, IConsole con, IProgressMonitor monitor) throws CoreException {
        this.errorParserManager = epm;
        this.console = con;
        this.isStreamsOpen = true;
        this.consoleOut = this.console.getOutputStream();
        this.errorParserManager.setOutputStream(this.consoleOut);
        ArrayList<IConsoleParser> parsers = new ArrayList<IConsoleParser>();
        parsers.add(this.errorParserManager);
        if (buildOutputParsers != null) {
            parsers.addAll(buildOutputParsers);
        }
        Integer lastWork = null;
        if (this.buildCommand != null && this.project != null) {
            this.progressPropertyName = BuildRunnerHelper.getProgressPropertyName(this.buildCommand, this.args);
            lastWork = (Integer)this.project.getSessionProperty(this.progressPropertyName);
        }
        if (lastWork == null) {
            lastWork = 100;
        }
        this.streamProgressMonitor = new StreamProgressMonitor(monitor, null, lastWork);
        ConsoleOutputSniffer sniffer = new ConsoleOutputSniffer(this.streamProgressMonitor, this.streamProgressMonitor, parsers.toArray(new IConsoleParser[parsers.size()]));
        this.stdout = sniffer.getOutputStream();
        this.stderr = sniffer.getErrorStream();
    }

    public OutputStream getOutputStream() {
        return this.stdout;
    }

    public OutputStream getErrorStream() {
        return this.stderr;
    }

    public void removeOldMarkers(IResource rc, IProgressMonitor monitor) throws CoreException {
        block12: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask("", -1);
                try {
                    if (rc != null) {
                        monitor.subTask(CCorePlugin.getFormattedString("BuildRunnerHelper.removingMarkers", rc.getFullPath().toString()));
                        rc.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
                    }
                }
                catch (CoreException coreException) {}
                if (this.project == null) break block12;
                try {
                    IWorkspace workspace = this.project.getWorkspace();
                    IMarker[] markers = workspace.getRoot().findMarkers("org.eclipse.cdt.core.problem", true, 2);
                    String projectName = this.project.getName();
                    ArrayList<IMarker> markersList = new ArrayList<IMarker>();
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        if (projectName.equals(marker.getAttribute("sourceId"))) {
                            markersList.add(marker);
                        }
                        ++n2;
                    }
                    if (markersList.size() > 0) {
                        workspace.deleteMarkers(markersList.toArray(new IMarker[markersList.size()]));
                    }
                }
                catch (CoreException coreException) {}
            }
            finally {
                monitor.done();
            }
        }
    }

    public int build(IProgressMonitor monitor) throws CoreException, IOException {
        Assert.isNotNull((Object)this.launcher, (String)"Launch parameters must be set before calling this method");
        Assert.isNotNull((Object)this.errorParserManager, (String)"Streams must be created and connected before calling this method");
        int status = -1;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask("", 200);
                this.isCancelled = false;
                String pathFromURI = null;
                if (this.workingDirectoryURI != null) {
                    pathFromURI = EFSExtensionManager.getDefault().getPathFromURI(this.workingDirectoryURI);
                }
                if (pathFromURI == null) {
                    pathFromURI = System.getProperty("user.dir");
                }
                Path workingDirectory = new Path(pathFromURI);
                String errMsg = null;
                monitor.subTask(CCorePlugin.getFormattedString("BuildRunnerHelper.invokingCommand", BuildRunnerHelper.guessCommandLine(this.buildCommand.toString(), this.args)));
                Process p = this.launcher.execute(this.buildCommand, this.args, this.envp, (IPath)workingDirectory, monitor);
                monitor.worked(100);
                if (p != null) {
                    try {
                        p.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    status = this.launcher.waitAndRead(this.stdout, this.stderr, monitor);
                    monitor.worked(100);
                    if (status != 0) {
                        errMsg = this.launcher.getErrorMessage();
                    }
                } else {
                    errMsg = this.launcher.getErrorMessage();
                }
                if (errMsg != null && !errMsg.isEmpty()) {
                    this.stderr.write(errMsg.getBytes());
                }
                this.isCancelled = monitor.isCanceled();
                if (!this.isCancelled && this.project != null) {
                    this.project.setSessionProperty(this.progressPropertyName, (Object)new Integer(this.streamProgressMonitor.getWorkDone()));
                }
            }
            catch (Exception e) {
                CCorePlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    @Override
    public void close() throws IOException {
        block205: {
            if (!this.isStreamsOpen) {
                return;
            }
            try {
                try {
                    if (this.stdout != null) {
                        this.stdout.close();
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                    this.stdout = null;
                    try {
                        try {
                            if (this.stderr != null) {
                                this.stderr.close();
                            }
                        }
                        catch (Exception e2) {
                            CCorePlugin.log(e2);
                            this.stderr = null;
                            try {
                                try {
                                    if (this.streamProgressMonitor != null) {
                                        this.streamProgressMonitor.close();
                                    }
                                }
                                catch (Exception e3) {
                                    CCorePlugin.log(e3);
                                    this.streamProgressMonitor = null;
                                    try {
                                        try {
                                            if (this.consoleOut != null) {
                                                this.consoleOut.close();
                                            }
                                        }
                                        catch (Exception e4) {
                                            CCorePlugin.log(e4);
                                            this.consoleOut = null;
                                            break block205;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        this.consoleOut = null;
                                        throw throwable;
                                    }
                                    this.consoleOut = null;
                                    break block205;
                                }
                            }
                            catch (Throwable throwable) {
                                block207: {
                                    this.streamProgressMonitor = null;
                                    try {
                                        try {
                                            if (this.consoleOut != null) {
                                                this.consoleOut.close();
                                            }
                                        }
                                        catch (Exception e5) {
                                            CCorePlugin.log(e5);
                                            this.consoleOut = null;
                                            break block207;
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        this.consoleOut = null;
                                        throw throwable2;
                                    }
                                    this.consoleOut = null;
                                }
                                throw throwable;
                            }
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e6) {
                                    CCorePlugin.log(e6);
                                    this.consoleOut = null;
                                    break block205;
                                }
                            }
                            catch (Throwable throwable) {
                                this.consoleOut = null;
                                throw throwable;
                            }
                            this.consoleOut = null;
                            break block205;
                        }
                    }
                    catch (Throwable throwable) {
                        block211: {
                            this.stderr = null;
                            try {
                                try {
                                    if (this.streamProgressMonitor != null) {
                                        this.streamProgressMonitor.close();
                                    }
                                }
                                catch (Exception e7) {
                                    CCorePlugin.log(e7);
                                    this.streamProgressMonitor = null;
                                    try {
                                        try {
                                            if (this.consoleOut != null) {
                                                this.consoleOut.close();
                                            }
                                        }
                                        catch (Exception e8) {
                                            CCorePlugin.log(e8);
                                            this.consoleOut = null;
                                            break block211;
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        this.consoleOut = null;
                                        throw throwable3;
                                    }
                                    this.consoleOut = null;
                                    break block211;
                                }
                            }
                            catch (Throwable throwable4) {
                                block213: {
                                    this.streamProgressMonitor = null;
                                    try {
                                        try {
                                            if (this.consoleOut != null) {
                                                this.consoleOut.close();
                                            }
                                        }
                                        catch (Exception e9) {
                                            CCorePlugin.log(e9);
                                            this.consoleOut = null;
                                            break block213;
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        this.consoleOut = null;
                                        throw throwable5;
                                    }
                                    this.consoleOut = null;
                                }
                                throw throwable4;
                            }
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e10) {
                                    CCorePlugin.log(e10);
                                    this.consoleOut = null;
                                    break block211;
                                }
                            }
                            catch (Throwable throwable6) {
                                this.consoleOut = null;
                                throw throwable6;
                            }
                            this.consoleOut = null;
                        }
                        throw throwable;
                    }
                    this.stderr = null;
                    try {
                        try {
                            if (this.streamProgressMonitor != null) {
                                this.streamProgressMonitor.close();
                            }
                        }
                        catch (Exception e11) {
                            CCorePlugin.log(e11);
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e12) {
                                    CCorePlugin.log(e12);
                                    this.consoleOut = null;
                                    break block205;
                                }
                            }
                            catch (Throwable throwable) {
                                this.consoleOut = null;
                                throw throwable;
                            }
                            this.consoleOut = null;
                            break block205;
                        }
                    }
                    catch (Throwable throwable) {
                        block218: {
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e13) {
                                    CCorePlugin.log(e13);
                                    this.consoleOut = null;
                                    break block218;
                                }
                            }
                            catch (Throwable throwable7) {
                                this.consoleOut = null;
                                throw throwable7;
                            }
                            this.consoleOut = null;
                        }
                        throw throwable;
                    }
                    this.streamProgressMonitor = null;
                    try {
                        try {
                            if (this.consoleOut != null) {
                                this.consoleOut.close();
                            }
                        }
                        catch (Exception e14) {
                            CCorePlugin.log(e14);
                            this.consoleOut = null;
                            break block205;
                        }
                    }
                    catch (Throwable throwable) {
                        this.consoleOut = null;
                        throw throwable;
                    }
                    this.consoleOut = null;
                    break block205;
                }
            }
            catch (Throwable throwable) {
                block223: {
                    this.stdout = null;
                    try {
                        try {
                            if (this.stderr != null) {
                                this.stderr.close();
                            }
                        }
                        catch (Exception e) {
                            CCorePlugin.log(e);
                            this.stderr = null;
                            try {
                                try {
                                    if (this.streamProgressMonitor != null) {
                                        this.streamProgressMonitor.close();
                                    }
                                }
                                catch (Exception e15) {
                                    CCorePlugin.log(e15);
                                    this.streamProgressMonitor = null;
                                    try {
                                        try {
                                            if (this.consoleOut != null) {
                                                this.consoleOut.close();
                                            }
                                        }
                                        catch (Exception e16) {
                                            CCorePlugin.log(e16);
                                            this.consoleOut = null;
                                            break block223;
                                        }
                                    }
                                    catch (Throwable throwable8) {
                                        this.consoleOut = null;
                                        throw throwable8;
                                    }
                                    this.consoleOut = null;
                                    break block223;
                                }
                            }
                            catch (Throwable throwable9) {
                                block225: {
                                    this.streamProgressMonitor = null;
                                    try {
                                        try {
                                            if (this.consoleOut != null) {
                                                this.consoleOut.close();
                                            }
                                        }
                                        catch (Exception e17) {
                                            CCorePlugin.log(e17);
                                            this.consoleOut = null;
                                            break block225;
                                        }
                                    }
                                    catch (Throwable throwable10) {
                                        this.consoleOut = null;
                                        throw throwable10;
                                    }
                                    this.consoleOut = null;
                                }
                                throw throwable9;
                            }
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e18) {
                                    CCorePlugin.log(e18);
                                    this.consoleOut = null;
                                    break block223;
                                }
                            }
                            catch (Throwable throwable11) {
                                this.consoleOut = null;
                                throw throwable11;
                            }
                            this.consoleOut = null;
                            break block223;
                        }
                    }
                    catch (Throwable throwable12) {
                        block229: {
                            this.stderr = null;
                            try {
                                try {
                                    if (this.streamProgressMonitor != null) {
                                        this.streamProgressMonitor.close();
                                    }
                                }
                                catch (Exception e) {
                                    CCorePlugin.log(e);
                                    this.streamProgressMonitor = null;
                                    try {
                                        try {
                                            if (this.consoleOut != null) {
                                                this.consoleOut.close();
                                            }
                                        }
                                        catch (Exception e19) {
                                            CCorePlugin.log(e19);
                                            this.consoleOut = null;
                                            break block229;
                                        }
                                    }
                                    catch (Throwable throwable13) {
                                        this.consoleOut = null;
                                        throw throwable13;
                                    }
                                    this.consoleOut = null;
                                    break block229;
                                }
                            }
                            catch (Throwable throwable14) {
                                block231: {
                                    this.streamProgressMonitor = null;
                                    try {
                                        try {
                                            if (this.consoleOut != null) {
                                                this.consoleOut.close();
                                            }
                                        }
                                        catch (Exception e) {
                                            CCorePlugin.log(e);
                                            this.consoleOut = null;
                                            break block231;
                                        }
                                    }
                                    catch (Throwable throwable15) {
                                        this.consoleOut = null;
                                        throw throwable15;
                                    }
                                    this.consoleOut = null;
                                }
                                throw throwable14;
                            }
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e) {
                                    CCorePlugin.log(e);
                                    this.consoleOut = null;
                                    break block229;
                                }
                            }
                            catch (Throwable throwable16) {
                                this.consoleOut = null;
                                throw throwable16;
                            }
                            this.consoleOut = null;
                        }
                        throw throwable12;
                    }
                    this.stderr = null;
                    try {
                        try {
                            if (this.streamProgressMonitor != null) {
                                this.streamProgressMonitor.close();
                            }
                        }
                        catch (Exception e) {
                            CCorePlugin.log(e);
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e20) {
                                    CCorePlugin.log(e20);
                                    this.consoleOut = null;
                                    break block223;
                                }
                            }
                            catch (Throwable throwable17) {
                                this.consoleOut = null;
                                throw throwable17;
                            }
                            this.consoleOut = null;
                            break block223;
                        }
                    }
                    catch (Throwable throwable18) {
                        block236: {
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e) {
                                    CCorePlugin.log(e);
                                    this.consoleOut = null;
                                    break block236;
                                }
                            }
                            catch (Throwable throwable19) {
                                this.consoleOut = null;
                                throw throwable19;
                            }
                            this.consoleOut = null;
                        }
                        throw throwable18;
                    }
                    this.streamProgressMonitor = null;
                    try {
                        try {
                            if (this.consoleOut != null) {
                                this.consoleOut.close();
                            }
                        }
                        catch (Exception e) {
                            CCorePlugin.log(e);
                            this.consoleOut = null;
                            break block223;
                        }
                    }
                    catch (Throwable throwable20) {
                        this.consoleOut = null;
                        throw throwable20;
                    }
                    this.consoleOut = null;
                }
                throw throwable;
            }
            this.stdout = null;
            try {
                try {
                    if (this.stderr != null) {
                        this.stderr.close();
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                    this.stderr = null;
                    try {
                        try {
                            if (this.streamProgressMonitor != null) {
                                this.streamProgressMonitor.close();
                            }
                        }
                        catch (Exception e21) {
                            CCorePlugin.log(e21);
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e22) {
                                    CCorePlugin.log(e22);
                                    this.consoleOut = null;
                                    break block205;
                                }
                            }
                            catch (Throwable throwable) {
                                this.consoleOut = null;
                                throw throwable;
                            }
                            this.consoleOut = null;
                            break block205;
                        }
                    }
                    catch (Throwable throwable) {
                        block242: {
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e23) {
                                    CCorePlugin.log(e23);
                                    this.consoleOut = null;
                                    break block242;
                                }
                            }
                            catch (Throwable throwable21) {
                                this.consoleOut = null;
                                throw throwable21;
                            }
                            this.consoleOut = null;
                        }
                        throw throwable;
                    }
                    this.streamProgressMonitor = null;
                    try {
                        try {
                            if (this.consoleOut != null) {
                                this.consoleOut.close();
                            }
                        }
                        catch (Exception e24) {
                            CCorePlugin.log(e24);
                            this.consoleOut = null;
                            break block205;
                        }
                    }
                    catch (Throwable throwable) {
                        this.consoleOut = null;
                        throw throwable;
                    }
                    this.consoleOut = null;
                    break block205;
                }
            }
            catch (Throwable throwable) {
                block246: {
                    this.stderr = null;
                    try {
                        try {
                            if (this.streamProgressMonitor != null) {
                                this.streamProgressMonitor.close();
                            }
                        }
                        catch (Exception e) {
                            CCorePlugin.log(e);
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e25) {
                                    CCorePlugin.log(e25);
                                    this.consoleOut = null;
                                    break block246;
                                }
                            }
                            catch (Throwable throwable22) {
                                this.consoleOut = null;
                                throw throwable22;
                            }
                            this.consoleOut = null;
                            break block246;
                        }
                    }
                    catch (Throwable throwable23) {
                        block248: {
                            this.streamProgressMonitor = null;
                            try {
                                try {
                                    if (this.consoleOut != null) {
                                        this.consoleOut.close();
                                    }
                                }
                                catch (Exception e) {
                                    CCorePlugin.log(e);
                                    this.consoleOut = null;
                                    break block248;
                                }
                            }
                            catch (Throwable throwable24) {
                                this.consoleOut = null;
                                throw throwable24;
                            }
                            this.consoleOut = null;
                        }
                        throw throwable23;
                    }
                    this.streamProgressMonitor = null;
                    try {
                        try {
                            if (this.consoleOut != null) {
                                this.consoleOut.close();
                            }
                        }
                        catch (Exception e) {
                            CCorePlugin.log(e);
                            this.consoleOut = null;
                            break block246;
                        }
                    }
                    catch (Throwable throwable25) {
                        this.consoleOut = null;
                        throw throwable25;
                    }
                    this.consoleOut = null;
                }
                throw throwable;
            }
            this.stderr = null;
            try {
                try {
                    if (this.streamProgressMonitor != null) {
                        this.streamProgressMonitor.close();
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                    this.streamProgressMonitor = null;
                    try {
                        try {
                            if (this.consoleOut != null) {
                                this.consoleOut.close();
                            }
                        }
                        catch (Exception e26) {
                            CCorePlugin.log(e26);
                            this.consoleOut = null;
                            break block205;
                        }
                    }
                    catch (Throwable throwable) {
                        this.consoleOut = null;
                        throw throwable;
                    }
                    this.consoleOut = null;
                    break block205;
                }
            }
            catch (Throwable throwable) {
                block253: {
                    this.streamProgressMonitor = null;
                    try {
                        try {
                            if (this.consoleOut != null) {
                                this.consoleOut.close();
                            }
                        }
                        catch (Exception e) {
                            CCorePlugin.log(e);
                            this.consoleOut = null;
                            break block253;
                        }
                    }
                    catch (Throwable throwable26) {
                        this.consoleOut = null;
                        throw throwable26;
                    }
                    this.consoleOut = null;
                }
                throw throwable;
            }
            this.streamProgressMonitor = null;
            try {
                try {
                    if (this.consoleOut != null) {
                        this.consoleOut.close();
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                    this.consoleOut = null;
                    break block205;
                }
            }
            catch (Throwable throwable) {
                this.consoleOut = null;
                throw throwable;
            }
            this.consoleOut = null;
        }
        this.isStreamsOpen = false;
    }

    public void refreshProject(String configName, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask(CCorePlugin.getFormattedString("BuildRunnerHelper.refreshingProject", this.project.getName()), -1);
                monitor.subTask("");
                RefreshScopeManager refreshManager = RefreshScopeManager.getInstance();
                IWorkspaceRunnable runnable = refreshManager.getRefreshRunnable(this.project, configName);
                ResourcesPlugin.getWorkspace().run(runnable, null, 1, null);
            }
            catch (CoreException coreException) {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void greeting(int kind) {
        String msg = CCorePlugin.getFormattedString("BuildRunnerHelper.buildProject", new String[]{BuildRunnerHelper.buildKindToString(kind), this.project.getName()});
        this.greeting(msg);
    }

    public void greeting(int kind, String cfgName, String toolchainName, boolean isSupported) {
        this.greeting(BuildRunnerHelper.buildKindToString(kind), cfgName, toolchainName, isSupported);
    }

    public void greeting(String kind, String cfgName, String toolchainName, boolean isSupported) {
        String msg = CCorePlugin.getFormattedString("BuildRunnerHelper.buildProjectConfiguration", new String[]{kind, cfgName, this.project.getName()});
        this.greeting(msg);
        if (!isSupported) {
            String errMsg = CCorePlugin.getFormattedString("BuildRunnerHelper.unsupportedConfiguration", new String[]{cfgName, toolchainName});
            this.printLine(errMsg);
        }
    }

    public void greeting(String msg) {
        this.startTime = System.currentTimeMillis();
        if (this.consoleInfo == null) {
            try {
                this.consoleInfo = this.console.getInfoStream();
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        this.toConsole(String.valueOf(BuildRunnerHelper.timestamp(this.startTime)) + "**** " + msg + " ****");
    }

    public void goodbye() {
        Assert.isTrue((this.startTime != 0L ? 1 : 0) != 0, (String)"Start time must be set before calling this method.");
        Assert.isTrue((this.consoleInfo != null ? 1 : 0) != 0, (String)"consoleInfo must be open with greetings(...) call before using this method.");
        this.endTime = System.currentTimeMillis();
        String duration = BuildRunnerHelper.durationToString(this.endTime - this.startTime);
        String msg = this.isCancelled ? CCorePlugin.getFormattedString("BuildRunnerHelper.buildCancelled", duration) : CCorePlugin.getFormattedString("BuildRunnerHelper.buildFinished", duration);
        String goodbye = String.valueOf('\n') + BuildRunnerHelper.timestamp(this.endTime) + msg + '\n';
        try {
            this.toConsole(goodbye);
        }
        finally {
            block13: {
                try {
                    try {
                        this.consoleInfo.close();
                    }
                    catch (Exception e) {
                        CCorePlugin.log(e);
                        this.consoleInfo = null;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    this.consoleInfo = null;
                    throw throwable;
                }
                this.consoleInfo = null;
            }
        }
    }

    public void printLine(String msg) {
        Assert.isNotNull((Object)this.errorParserManager, (String)"Streams must be created and connected before calling this method");
        this.errorParserManager.processLine(msg);
    }

    private static String guessCommandLine(String command, String[] args) {
        StringBuffer buf = new StringBuffer(String.valueOf(command) + ' ');
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                buf.append(arg);
                buf.append(' ');
                ++n2;
            }
        }
        return buf.toString().trim();
    }

    private void toConsole(String msg) {
        Assert.isNotNull((Object)this.console, (String)"Streams must be created and connected before calling this method");
        try {
            this.consoleInfo.write((String.valueOf(msg) + "\n").getBytes());
        }
        catch (Exception e) {
            CCorePlugin.log(e);
        }
    }

    private static QualifiedName getProgressPropertyName(IPath buildCommand, String[] args) {
        String name = "buildCommand." + buildCommand.toString();
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                name = String.valueOf(name) + ' ' + arg;
                ++n2;
            }
        }
        return new QualifiedName(PROGRESS_MONITOR_QUALIFIER, name);
    }

    public static String[] envMapToEnvp(Map<String, String> envMap) {
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            strings.add(String.valueOf(entry.getKey()) + '=' + entry.getValue());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String[] getEnvp(ICConfigurationDescription cfgDescription) {
        IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable[] vars = mngr.getVariables(cfgDescription, true);
        ArrayList<String> strings = new ArrayList<String>(vars.length);
        IEnvironmentVariable[] iEnvironmentVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            strings.add(String.valueOf(var.getName()) + '=' + var.getValue());
            ++n2;
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static String durationToString(long duration) {
        long seconds;
        long minutes;
        long hours;
        String result = "";
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        if (days > 0L) {
            result = String.valueOf(result) + days + "d,";
        }
        if ((hours = TimeUnit.MILLISECONDS.toHours(duration) % 24L) > 0L) {
            result = String.valueOf(result) + hours + "h:";
        }
        if ((minutes = TimeUnit.MILLISECONDS.toMinutes(duration) % 60L) > 0L) {
            result = String.valueOf(result) + minutes + "m:";
        }
        if ((seconds = TimeUnit.MILLISECONDS.toSeconds(duration) % 60L) > 0L) {
            result = String.valueOf(result) + seconds + "s.";
        }
        long milliseconds = TimeUnit.MILLISECONDS.toMillis(duration) % 1000L;
        result = String.valueOf(result) + milliseconds + "ms";
        return result;
    }

    private static String timestamp(long time) {
        return String.valueOf(new SimpleDateFormat("HH:mm:ss").format(new Date(time))) + " ";
    }

    private static String buildKindToString(int kind) {
        switch (kind) {
            case 6: {
                return CCorePlugin.getResourceString("BuildRunnerHelper.build");
            }
            case 10: {
                return CCorePlugin.getResourceString("BuildRunnerHelper.incrementalBuild");
            }
            case 9: {
                return CCorePlugin.getResourceString("BuildRunnerHelper.autoBuild");
            }
            case 15: {
                return CCorePlugin.getResourceString("BuildRunnerHelper.cleanBuild");
            }
        }
        return CCorePlugin.getResourceString("BuildRunnerHelper.build");
    }
}

