/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.core.gputil.OSChecker;
import org.tizen.sbilib.for_cli.SBIAction;
import org.tizen.sbilib.for_cli.SBIBuildParamData;
import org.tizen.sbilib.for_cli.SBIExecute;
import org.tizen.sbilib.for_cli.SBIMacro;
import org.tizen.sbilib.for_cli.SBIModel;
import org.tizen.sbilib.for_cli.SBIParser;
import org.tizen.sbilib.for_cli.SBISysVar;
import org.tizen.sbilib.for_cli.sbiplugin.SBIPluginManager;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapManager;
import org.tizen.sbilib.for_cli.sbiplugin.SBIToolchainData;

public class SBIProcess {
    protected final Logger logger = LoggerFactory.getLogger(SBIProcess.class);
    private static final String SHELL_COMMAND_LINUX = "/bin/sh";
    private static final String SHELL_COMMAND_MINGW = "sh";
    private static final String SHELL_COMMAND_LINUX_PARAM = "-c";
    private static final String SHELL_COMMAND_WINDOW = "cmd";
    private static final String SHELL_COMMAND_WINDOW_PARAM = "/c";
    private static final String SHELL_WIN_PATH_NAME = "Path";
    private static final int CMDLINEMAX = 65535;
    private boolean validate = false;
    private SBIPluginManager sbiPlugins = null;
    private SBIToolchainData toolchain;
    private SBIRootstrapData rootstrap;
    private Map<String, SBIAction> actions = new HashMap<String, SBIAction>();
    private SBIMacro sbiMacro = new SBIMacro();
    private SBIModel sbiModel = null;
    private String sbiBuildConfFile;

    public SBIMacro getMacro() {
        return this.sbiMacro;
    }

    public SBIModel getModel() {
        return this.sbiModel;
    }

    public SBIToolchainData getToolchainData() {
        return this.toolchain;
    }

    public void setToolchainData(SBIToolchainData toolchain) {
        this.toolchain = toolchain;
    }

    public SBIRootstrapData getRootstrapData() {
        return this.rootstrap;
    }

    public void setRootstrapData(SBIRootstrapData rootstrap) {
        this.rootstrap = rootstrap;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public SBIModel loadBuildScript(String sbiBuildConfFile, String requireVersion) {
        if (this.sbiBuildConfFile != null && this.sbiBuildConfFile.equals(sbiBuildConfFile)) {
            return this.sbiModel;
        }
        SBIModel result = SBIParser.parseBuildScript(sbiBuildConfFile, requireVersion);
        if (result == null) {
            return null;
        }
        this.sbiModel = result;
        this.sbiBuildConfFile = sbiBuildConfFile;
        return result;
    }

    public SBIModel loadBuildScript(String sbiBuildConfFile) {
        return this.loadBuildScript(sbiBuildConfFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realizeBuildScript(SBIBuildParamData sysVarData, SBISysVar sysVarGetter) {
        Map<String, List<String>> rootstrapParam = null;
        String path = this.rootstrap.getProperty("DEV_PACKAGE_CONFIG_PATH");
        if (path != null) {
            if (OSChecker.isWindows()) {
                path = path.replace("/", "\\");
            }
            rootstrapParam = SBIRootstrapManager.getRootstrapParam(path);
        }
        this.sbiModel.getMacro().realizeAllMacros(sysVarData, sysVarGetter, this.toolchain, this.rootstrap, rootstrapParam);
        Map<String, String> sbimacros = this.sbiModel.getMacro().getMacros();
        String objsPath = sbimacros.get("PROJ_PATH") + "/" + sbimacros.get("BUILD_CONFIG") + "/objs";
        new File(objsPath).mkdirs();
        String incpath = null;
        BufferedWriter bw = null;
        try {
            List<String> incPaths = rootstrapParam.get("include_path");
            String rspath = sbimacros.get("ROOTSTRAP_PATH");
            bw = OSChecker.isWindows() && this.toolchain.getName().toLowerCase().contains("llvm") ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(objsPath + "/platform_incs_file.inc"), "UTF-16")) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(objsPath + "/platform_incs_file.inc")));
            for (int i = 0; i < incPaths.size(); ++i) {
                incpath = rspath + incPaths.get(i);
                incpath = "-I \"" + incpath + "\" ";
                bw.write(incpath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.sbiMacro = this.sbiModel.getMacro();
        this.actions = this.sbiModel.getActions();
        this.validate = true;
    }

    public SBIModel analisysBuildScript(String sbiBuildConfFile, SBIBuildParamData sysVarData, SBISysVar sysVarGetter, String requireVersion) {
        SBIModel result = this.loadBuildScript(sbiBuildConfFile, requireVersion);
        if (result == null) {
            return null;
        }
        this.realizeBuildScript(sysVarData, sysVarGetter);
        return result;
    }

    public SBIModel analisysBuildScript(String sbiBuildConfFile, SBIBuildParamData data, SBISysVar sysVarGetter) {
        return this.analisysBuildScript(sbiBuildConfFile, data, sysVarGetter, null);
    }

    public SBIAction getAction(String actionName) {
        return this.actions.get(actionName);
    }

    public static String[] getCommand(String[] commands, boolean isLinux) {
        String[] fullCommand;
        if (OSChecker.isWindows()) {
            if (isLinux) {
                fullCommand = new String[6 + commands.length];
                fullCommand[0] = SHELL_COMMAND_WINDOW;
                fullCommand[1] = SHELL_COMMAND_WINDOW_PARAM;
                fullCommand[2] = "\"";
                fullCommand[3] = SHELL_COMMAND_MINGW;
                fullCommand[4] = SHELL_COMMAND_LINUX_PARAM;
                System.arraycopy(commands, 0, fullCommand, 5, commands.length);
                int idx = 5 + commands.length;
                fullCommand[idx] = "\"";
            } else {
                fullCommand = new String[2 + commands.length];
                fullCommand[0] = SHELL_COMMAND_WINDOW;
                fullCommand[1] = SHELL_COMMAND_WINDOW_PARAM;
                System.arraycopy(commands, 0, fullCommand, 2, commands.length);
            }
        } else {
            fullCommand = new String[3];
            fullCommand[0] = SHELL_COMMAND_LINUX;
            fullCommand[1] = SHELL_COMMAND_LINUX_PARAM;
            String st = "";
            for (String cmd : commands) {
                if (!st.isEmpty()) {
                    st = st + " ";
                }
                st = st + cmd;
            }
            fullCommand[2] = st;
        }
        return fullCommand;
    }

    public static String[] getMinGWCommand(String command) {
        return new String[]{SHELL_COMMAND_WINDOW, SHELL_COMMAND_WINDOW_PARAM, SHELL_COMMAND_MINGW, SHELL_COMMAND_LINUX_PARAM, "\"" + command + "\""};
    }

    public static String[] getCommand(String command) {
        if (OSChecker.isWindows()) {
            return new String[]{SHELL_COMMAND_WINDOW, SHELL_COMMAND_WINDOW_PARAM, command};
        }
        return new String[]{SHELL_COMMAND_LINUX, SHELL_COMMAND_LINUX_PARAM, command};
    }

    public List<SBIRootstrapData> getRootstrapList() {
        return this.sbiPlugins.getRootstrapList();
    }

    public List<SBIToolchainData> getToolchainList() {
        return this.sbiPlugins.getToolchainList();
    }

    public void setMacroRunner(SBIMacro.Runner runner) {
        this.sbiMacro.setMacroRunner(runner);
    }

    public static ProcessBuilder genProcessBuilder(ProcessBuilder pb) {
        if (pb == null) {
            pb = new ProcessBuilder(new String[0]);
        }
        if (OSChecker.isWindows()) {
            String curEnv = System.getenv(SHELL_WIN_PATH_NAME);
            pb.environment().put(SHELL_WIN_PATH_NAME, curEnv);
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeProcess(ProcessBuilder pb, String[] cmds, Logger logger) {
        String sbiTrace = "[SBI] command : ";
        for (String c : cmds) {
            sbiTrace = sbiTrace + c + " ";
        }
        if (logger != null) {
            logger.info(sbiTrace);
        }
        pb.command(cmds);
        pb.redirectErrorStream(true);
        Process proc = null;
        BufferedReader input = null;
        try {
            proc = pb.start();
            InputStreamReader is = OSChecker.isWindows() ? new InputStreamReader(proc.getInputStream(), "utf-8") : new InputStreamReader(proc.getInputStream());
            input = new BufferedReader(is, 65535);
            if (logger != null) {
                String line = null;
                while ((line = input.readLine()) != null) {
                    logger.info(line);
                }
            }
            proc.waitFor();
        }
        catch (IOException e) {
            if (logger != null) {
                logger.error("IOException occurred:", (Throwable)e);
            }
            int n = -1;
            return n;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (proc != null) {
                proc.destroy();
            }
        }
        return proc.exitValue();
    }

    public int procAction(String actionName, String projPath, ProcessBuilder pb, Logger logger) {
        String actCurDir;
        int result = 0;
        SBIAction act = this.actions.get(actionName);
        if (act == null) {
            return -1;
        }
        if (pb == null) {
            pb = SBIProcess.genProcessBuilder(pb);
        }
        if ((actCurDir = this.sbiMacro.processValue(act.getCurDir())) == null || actCurDir.isEmpty()) {
            actCurDir = projPath;
        }
        int cmdCount = act.getExecCount();
        for (int i = 0; i < cmdCount; ++i) {
            File curDirFile;
            String[] cmds;
            SBIExecute exec = act.getExec(i);
            if (exec == null || (cmds = exec.getFullCommand()) == null && exec.isNecessary()) continue;
            List<String> echos = exec.getEchos();
            for (String echo : echos) {
                if (echo == null || echo.isEmpty()) continue;
                echo = this.sbiMacro.processValue(echo);
                logger.info("[SBI] " + echo);
            }
            exec.applyAllEnvs(pb.environment());
            if (cmds == null) continue;
            String[] fullCmd = SBIProcess.getCommand(cmds, exec.isLinux());
            boolean chgDir = false;
            String curDir = exec.getCurDir();
            if ((curDir = this.sbiMacro.processValue(curDir)) != null && !curDir.isEmpty() && (curDirFile = new File(curDir)).exists()) {
                pb.directory(curDirFile);
                chgDir = true;
            }
            if (!chgDir && actCurDir != null && !actCurDir.isEmpty() && (curDirFile = new File(actCurDir)).exists()) {
                pb.directory(curDirFile);
                chgDir = true;
            }
            if ((result = SBIProcess.executeProcess(pb, fullCmd, logger)) != 0 && exec.isNecessary()) break;
        }
        return result;
    }

    public void setPluginManager(SBIPluginManager sbiPlugins) {
        this.sbiPlugins = sbiPlugins;
    }

    public SBIPluginManager getPluginManager() {
        return this.sbiPlugins;
    }
}

