/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.rm.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.rm.model.ITizenRMFeature;
import org.tizen.nativecommon.rm.model.RMChangeListener;
import org.tizen.nativecommon.rm.model.ResConfig;
import org.tizen.nativecommon.rm.ui.view.TizenRMMessages;
import org.tizen.sdblib.util.StringUtil;

public class RMHandler
implements IResourceChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(RMHandler.class);
    private List<RMChangeListener> listenerList = new ArrayList<RMChangeListener>();
    private IProject project;
    private ResConfig resConfig;
    private String[] dialogButtonLabels = new String[]{"Remove", "Cancel"};

    public RMHandler(IProject project) {
        this.project = project;
        this.resConfig = new ResConfig(project);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public RMHandler(ResConfig resConfig) {
        this.resConfig = resConfig;
        this.project = resConfig.getProject();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void load() {
        this.resConfig.updateModel();
    }

    public void reset(IProject project) {
        this.project = project;
        this.resConfig = new ResConfig(project);
    }

    public boolean existsItem(Set<ITizenRMFeature> features) {
        String dir = this.resConfig.getDir(features);
        IFolder folder = this.project.getFolder(dir);
        return folder.exists();
    }

    public void addDefaultFeature() {
        IResource defaultRes = this.getDefaultItem().getResource();
        if (!defaultRes.exists()) {
            IFolder defaultEdjeFolder = this.project.getFolder(String.valueOf(defaultRes.getProjectRelativePath().toString()) + "/" + "edje_res");
            this.createDirectory((IFolder)defaultRes);
            this.createDirectory(defaultEdjeFolder);
            this.addBuildOptionForEdc((IFolder)defaultRes, defaultEdjeFolder);
        }
    }

    public boolean addFeatures(Set<ITizenRMFeature> features) {
        String dir = this.resConfig.getDir(features);
        if (StringUtil.isEmpty((CharSequence)dir)) {
            return false;
        }
        IFolder folder = this.project.getFolder(dir);
        IFolder edjeResFolder = this.project.getFolder(String.valueOf(dir) + "/" + "edje_res");
        this.addDefaultFeature();
        this.createDirectory(folder);
        this.createDirectory(edjeResFolder);
        this.addBuildOptionForEdc(folder, edjeResFolder);
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
        this.load();
        return true;
    }

    public void addBuildOptionForEdc(IFolder folder, IFolder edjeResFolder) {
        String value = String.format("\"${workspace_loc:/${ProjName}/%s}\"", edjeResFolder.getProjectRelativePath().toString());
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)folder);
        IResource defaultRes = this.getDefaultItem().getResource();
        boolean isNeededRemoveOption = !folder.equals((Object)defaultRes);
        String defaultEdjeResValue = "";
        if (isNeededRemoveOption) {
            IFolder defaultEdjeFolder = this.project.getFolder(String.valueOf(defaultRes.getProjectRelativePath().toString()) + "/" + "edje_res");
            defaultEdjeResValue = String.format("\"${workspace_loc:/${ProjName}/%s}\"", defaultEdjeFolder.getProjectRelativePath().toString());
        }
        IConfiguration[] iConfigurationArray = buildInfo.getDefaultConfiguration().getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            IFolderInfo info = config.createFolderInfo(folder.getProjectRelativePath());
            CommonConfigurationManager.setValueOfIDOptionToEDCCompiler(config, (IResourceInfo)info, value);
            CommonConfigurationManager.setValueOfSDOptionToEDCCompiler(config, (IResourceInfo)info, value);
            CommonConfigurationManager.setValueOfFDOptionToEDCCompiler(config, (IResourceInfo)info, value);
            if (isNeededRemoveOption) {
                CommonConfigurationManager.removeValueOfIDOptionToEDCCompiler(config, (IResourceInfo)info, defaultEdjeResValue);
                CommonConfigurationManager.removeValueOfSDOptionToEDCCompiler(config, (IResourceInfo)info, defaultEdjeResValue);
                CommonConfigurationManager.removeValueOfFDOptionToEDCCompiler(config, (IResourceInfo)info, defaultEdjeResValue);
            }
            ++n2;
        }
    }

    public void saveBuildOption() {
        ManagedBuildManager.saveBuildInfo((IProject)this.project, (boolean)true);
    }

    private void createDirectory(IFolder folder) {
        if (2 != folder.getType()) {
            return;
        }
        if (!folder.exists()) {
            FileUtil.createDirectory((String)folder.getLocation().toOSString());
        }
    }

    public boolean removeItem(ResConfig.Item item, boolean isForce) {
        String dir = item.getDir();
        IFolder folder = this.project.getFolder(dir);
        return this.removeDir(folder, isForce);
    }

    private boolean removeDir(IFolder folder, boolean isForce) {
        if (folder.exists()) {
            try {
                if (isForce) {
                    folder.delete(true, null);
                } else {
                    int result = 0;
                    result = new MessageDialog(SWTUtil.getActiveShell(), "Question", null, NLS.bind((String)TizenRMMessages.DIALOG_REMOVE_MESSAGE, (Object)folder.getFullPath().toString()), 3, this.dialogButtonLabels, 1).open();
                    switch (result) {
                        case 0: {
                            folder.delete(true, null);
                            break;
                        }
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        this.load();
        return true;
    }

    public boolean removeFeatures(Set<ITizenRMFeature> features, boolean isForce) {
        String dir = this.resConfig.getDir(features);
        IFolder folder = this.project.getFolder(dir);
        return this.removeDir(folder, isForce);
    }

    public ResConfig.Item getDefaultType() {
        return this.getDefaultItem();
    }

    public Set<ResConfig.Item> getSupportedType() {
        Set<ResConfig.Item> children = this.resConfig.getChildrenOfImage();
        return children;
    }

    public Set<ITizenRMFeature> getSupportedLocales() {
        Set<ResConfig.Item> children = this.resConfig.getChildrenOfImage();
        HashSet<ITizenRMFeature> supportedLocale = new HashSet<ITizenRMFeature>();
        for (ResConfig.Item child : children) {
            supportedLocale.add(child.getLocale());
        }
        return supportedLocale;
    }

    public static ITizenRMFeature[] getLocales() {
        return ResConfig.LOCALES;
    }

    public static ITizenRMFeature[] getDPIs() {
        return ResConfig.DPIS;
    }

    public ITizenRMFeature getFeature(String str) {
        ITizenRMFeature feature;
        ITizenRMFeature[] iTizenRMFeatureArray = ResConfig.LOCALES;
        int n = ResConfig.LOCALES.length;
        int n2 = 0;
        while (n2 < n) {
            feature = iTizenRMFeatureArray[n2];
            if (feature.toString().equals(str)) {
                return feature;
            }
            ++n2;
        }
        iTizenRMFeatureArray = ResConfig.DPIS;
        n = ResConfig.DPIS.length;
        n2 = 0;
        while (n2 < n) {
            feature = iTizenRMFeatureArray[n2];
            if (feature.toString().equals(str)) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    public void addListener(RMChangeListener lisnetner) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<RMChangeListener>();
        }
        this.listenerList.add(lisnetner);
    }

    public void removeListener(RMChangeListener lisnetner) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(lisnetner);
    }

    public void fireLocaleDirChangeEvent() {
        for (final RMChangeListener listener : this.listenerList) {
            SWTUtil.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.rmChagned();
                }
            });
        }
    }

    public void resourceChanged(IResourceChangeEvent changeEvent) {
        if (changeEvent.getType() != 1) {
            return;
        }
        if (changeEvent.getDelta().findMember(this.project.getFolder("res").getFullPath()) == null) {
            return;
        }
        this.fireLocaleDirChangeEvent();
    }

    protected void finalize() throws Throwable {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public IResource[] getKeys(ResConfig.Item item) {
        IResource itemRes = item.getResource();
        if (itemRes.getType() != 2) {
            return new IResource[0];
        }
        IFolder folder = (IFolder)itemRes;
        try {
            ArrayList<IResource> keyList = new ArrayList<IResource>();
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res.getType() == 1) {
                    keyList.add(res);
                }
                ++n2;
            }
            return keyList.toArray(new IResource[keyList.size()]);
        }
        catch (CoreException coreException) {
            return new IResource[0];
        }
    }

    public ResConfig.Key getResKey(String searchKey, Set<ITizenRMFeature> features) {
        ResConfig.Item item = this.getItem(features);
        ResConfig.Key key = this.searchKey(searchKey, item);
        if (key == null) {
            return this.searchKey(searchKey, this.getDefaultItem());
        }
        return key;
    }

    public ResConfig.Key getResSpecificKey(String searchKey, Set<ITizenRMFeature> features) {
        ResConfig.Item item = this.getItem(features);
        return this.searchKey(searchKey, item);
    }

    private ResConfig.Item getDefaultItem() {
        return this.resConfig.getDefaultImage();
    }

    public Set<ResConfig.Key> getDefaultKeys() {
        ResConfig.Item defaultItem = this.getDefaultItem();
        Set<ResConfig.Key> keys = defaultItem.getKey();
        return keys;
    }

    public Set<String> getDefaultKeysString() {
        Set<ResConfig.Key> defaultKeys = this.getDefaultKeys();
        HashSet<String> keysString = new HashSet<String>();
        for (ResConfig.Key defaultKey : defaultKeys) {
            this.getDefaultKeysString(defaultKey, keysString);
            if (!defaultKey.isKey()) continue;
            keysString.add(defaultKey.getKeyString());
        }
        return keysString;
    }

    private void getDefaultKeysString(ResConfig.Key parent, Set<String> keysString) {
        for (ResConfig.Key child : parent.getChildren()) {
            if (!child.getChildren().isEmpty()) {
                this.getDefaultKeysString(child, keysString);
            }
            if (!child.isKey()) continue;
            keysString.add(child.getKeyString());
        }
    }

    public Set<ResConfig.Key> getResKeys(Set<ITizenRMFeature> features) {
        if (features == null) {
            return this.getDefaultKeys();
        }
        ResConfig.Item item = this.getItem(features);
        HashSet<ResConfig.Key> allKeys = new HashSet<ResConfig.Key>();
        this.getKeys(item, allKeys);
        Set<ResConfig.Key> defaultAllKeys = this.getDefaultKeys();
        HashSet<ResConfig.Key> returnKeys = new HashSet<ResConfig.Key>();
        if (allKeys.isEmpty()) {
            return defaultAllKeys;
        }
        String defaultKeyString = "";
        block0: for (ResConfig.Key defaultKey : defaultAllKeys) {
            defaultKeyString = defaultKey.getKeyString();
            for (ResConfig.Key key : allKeys) {
                if (defaultKeyString.equals(key.getKeyString())) continue block0;
                returnKeys.add(defaultKey);
            }
        }
        returnKeys.addAll(allKeys);
        return returnKeys;
    }

    private void getKeys(Object item, Set<ResConfig.Key> allKeys) {
        block3: {
            block2: {
                if (!(item instanceof ResConfig.Item)) break block2;
                for (ResConfig.Key key : ((ResConfig.Item)item).getKey()) {
                    allKeys.add(key);
                    this.getKeys(key, allKeys);
                }
                break block3;
            }
            if (!(item instanceof ResConfig.Key)) break block3;
            for (ResConfig.Key key : ((ResConfig.Key)item).getChildren()) {
                allKeys.add(key);
                this.getKeys(key, allKeys);
            }
        }
    }

    private ResConfig.Key searchKey(String searchKey, Object item) {
        block5: {
            block4: {
                if (!(item instanceof ResConfig.Item)) break block4;
                for (ResConfig.Key key : ((ResConfig.Item)item).getKey()) {
                    if (key.getKeyString().equals(searchKey)) {
                        return key;
                    }
                    ResConfig.Key returnKey = this.searchKey(searchKey, key);
                    if (returnKey == null) continue;
                    return returnKey;
                }
                break block5;
            }
            if (!(item instanceof ResConfig.Key)) break block5;
            for (ResConfig.Key key : ((ResConfig.Key)item).getChildren()) {
                if (key.getKeyString().equals(searchKey)) {
                    return key;
                }
                ResConfig.Key returnKey = this.searchKey(searchKey, key);
                if (returnKey == null) continue;
                return returnKey;
            }
        }
        return null;
    }

    private ResConfig.Item getItem(Set<ITizenRMFeature> features) {
        Set<ResConfig.Item> children = this.resConfig.getChildrenOfImage();
        String dir = this.resConfig.getDir(features);
        for (ResConfig.Item child : children) {
            if (!dir.equals(child.getDir())) continue;
            return child;
        }
        return null;
    }

    public static boolean isSupportedProject(IProject project) {
        TizenProjectType type = ProjectUtil.getTizenProjectType(project);
        boolean isSuportedProject = RMHandler.isSupportedProjectType(type);
        if (isSuportedProject) {
            return RMHandler.isSupportedProjectVersion(project);
        }
        return isSuportedProject;
    }

    private static boolean isSupportedProjectVersion(IProject project) {
        IXMLStore xmlStore = ProjectUtil.getXmlStore(project);
        String apiVersion = xmlStore.getApiVersion();
        TizenProjectDescription desc = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)project);
        String projectVersion = desc.getVersion();
        if (!projectVersion.matches("((\\d+))(\\.\\d+)+")) {
            logger.error("project version is invalid: " + projectVersion + ", " + project);
            return false;
        }
        if (!apiVersion.matches("((\\d+))(\\.\\d+)+")) {
            logger.error("apiVersion is invalid: " + apiVersion + ", " + project);
            return false;
        }
        return apiVersion.compareTo("2.4") >= 0 && projectVersion.compareTo("2.4") >= 0;
    }

    private static boolean isSupportedProjectType(TizenProjectType type) {
        if (type == null) {
            return false;
        }
        if (type.isNativeApplicationProject()) {
            return true;
        }
        return type.isNativeSharedLibraryProject();
    }
}

