/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.tizen.nativecore.ext.manifest.Account;
import org.tizen.nativecore.ext.manifest.Author;
import org.tizen.nativecore.ext.manifest.Compatibility;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.Description;
import org.tizen.nativecore.ext.manifest.Dynamicbox;
import org.tizen.nativecore.ext.manifest.Feature;
import org.tizen.nativecore.ext.manifest.Font;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Ime;
import org.tizen.nativecore.ext.manifest.ImeApplication;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.ext.manifest.Livebox;
import org.tizen.nativecore.ext.manifest.Notifications;
import org.tizen.nativecore.ext.manifest.Privilege;
import org.tizen.nativecore.ext.manifest.Profile;
import org.tizen.nativecore.ext.manifest.ServiceApplication;
import org.tizen.nativecore.ext.manifest.Shortcut;
import org.tizen.nativecore.ext.manifest.UiApplication;
import org.tizen.nativecore.ext.manifest.WatchApplication;
import org.tizen.nativecore.ext.manifest.Widget;
import org.tizen.nativecore.ext.manifest.WidgetApplication;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.core.PrivilegeLevel;
import org.tizen.nativecore.misc.editor.ManifestSchemaValidator;
import org.tizen.nativecore.misc.utils.Constants;
import org.tizen.nativecore.misc.utils.PositionalXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Manifest {
    public static final String ELEMENT = "manifest";
    public static final String MANIFEST_MARKER_ID = "org.tizen.nativecore.misc.manifestProblem";
    public static final String ATTR_XMLNS = "xmlns";
    public static final String ATTR_STORECLIENT_ID = "storeclient-id";
    public static final String ATTR_INSTALL_LOCATION = "install-location";
    public static final String ATTR_PACKAGE = "package";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_ROOT_PATH = "root_path";
    public static final String ATTR_CSC_PATH = "csc_path";
    public static final String ATTR_APPSETTING = "appsetting";
    public static final String ATTR_NODISPLAY_SETTING = "nodisplay-setting";
    public static final String ATTR_URL = "url";
    public static final String ATTR_SUPPORT_DISABLE = "support-disable";
    public static final String ATTR_API_VERSION = "api-version";
    private String xmlns = "http://tizen.org/ns/packages";
    private String storeclient_id;
    private String install_location;
    private String package_name;
    private String type;
    private String version;
    private String size;
    private String root_path;
    private String csc_path;
    private String appsetting;
    private String nodisplay_setting;
    private String url;
    private String support_disable;
    private String api_version;
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();
    private List<Label> label_list = new ArrayList<Label>();
    private Icon icon;
    private Author author;
    private Description description;
    private String defaultDesc;
    private List<LocaledValue> descriptions = new ArrayList<LocaledValue>();
    private Compatibility compatibility;
    private Profile profile;
    private List<IApplication> application_list = new ArrayList<IApplication>();
    private List<Shortcut> shortcutList = new ArrayList<Shortcut>();
    private Livebox livebox;
    private List<Dynamicbox> dbox_list = new ArrayList<Dynamicbox>();
    private List<Account> account_list = new ArrayList<Account>();
    private Notifications notifications;
    private Font font;
    private Ime ime;
    private Map<String, Privilege> privilege_map = new HashMap<String, Privilege>();
    private TreeMap<String, String> feature_list = new TreeMap();
    private Map<String, Feature> feature_map = new HashMap<String, Feature>();
    private List<Widget> widgetList = new ArrayList<Widget>();

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.xmlns = element.getAttribute(ATTR_XMLNS);
        this.storeclient_id = element.getAttribute(ATTR_STORECLIENT_ID);
        this.install_location = element.getAttribute(ATTR_INSTALL_LOCATION);
        this.setPackageId(element.getAttribute(ATTR_PACKAGE));
        this.type = element.getAttribute(ATTR_TYPE);
        this.setVersion(element.getAttribute(ATTR_VERSION));
        this.size = element.getAttribute(ATTR_SIZE);
        this.root_path = element.getAttribute(ATTR_ROOT_PATH);
        this.csc_path = element.getAttribute(ATTR_CSC_PATH);
        this.appsetting = element.getAttribute(ATTR_APPSETTING);
        this.nodisplay_setting = element.getAttribute(ATTR_NODISPLAY_SETTING);
        this.url = element.getAttribute(ATTR_URL);
        this.support_disable = element.getAttribute(ATTR_SUPPORT_DISABLE);
        this.api_version = element.getAttribute(ATTR_API_VERSION);
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            if (this.isCustomAttribute(attr)) {
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
            }
            ++i;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            IApplication application;
            String nodeName = node.getNodeName();
            if (nodeName.equals("label")) {
                Label label = new Label();
                label.loadElement((Element)node);
                this.label_list.add(label);
            } else if (nodeName.equals("icon")) {
                this.setIcon(new Icon());
                this.getIcon().loadElement((Element)node);
            } else if (nodeName.equals("author")) {
                this.author = new Author();
                this.author.loadElement((Element)node);
            } else if (nodeName.equals("description")) {
                if (node.getAttributes().getLength() > 0) {
                    this.description = new Description();
                    this.description.loadElement((Element)node);
                    this.descriptions.add(new LocaledValue(this.description.getLang(), this.description.getValue()));
                } else {
                    this.defaultDesc = node.getTextContent();
                }
            } else if (nodeName.equals("compatibility")) {
                this.compatibility = new Compatibility();
                this.compatibility.loadElement((Element)node);
            } else if (nodeName.equals("profile")) {
                this.profile = new Profile();
                this.profile.loadElement((Element)node);
            } else if (nodeName.equals("widget-application")) {
                application = new WidgetApplication();
                ((WidgetApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("watch-application")) {
                application = new WatchApplication();
                ((WatchApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("service-application")) {
                application = new ServiceApplication();
                ((ServiceApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("ui-application")) {
                application = new UiApplication();
                ((UiApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("ime-application")) {
                application = new ImeApplication();
                ((ImeApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("shortcut-list")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 1) {
                        Shortcut shortCut = new Shortcut();
                        shortCut.loadElement((Element)child);
                        this.getShortCutList().add(shortCut);
                    }
                    child = child.getNextSibling();
                }
            } else if (nodeName.equals("livebox")) {
                this.livebox = new Livebox();
                this.livebox.loadElement((Element)node);
            } else if (nodeName.equals("dynamicbox")) {
                Dynamicbox dbox = new Dynamicbox();
                dbox.loadElement((Element)node);
                this.dbox_list.add(dbox);
            } else if (nodeName.equals("widget")) {
                Widget widget = new Widget();
                widget.loadElement((Element)node);
                this.widgetList.add(widget);
            } else if (nodeName.equals("account")) {
                Account account = new Account();
                account.loadElement((Element)node);
                this.account_list.add(account);
            } else if (nodeName.equals("notifications")) {
                this.notifications = new Notifications();
                this.notifications.loadElement((Element)node);
            } else if (nodeName.equals("privileges")) {
                NodeList pri = node.getChildNodes();
                int i2 = 0;
                while (i2 < pri.getLength()) {
                    Node p_item = pri.item(i2);
                    if (p_item.getNodeName().equals("privilege")) {
                        Privilege privilege = new Privilege();
                        privilege.loadElement((Element)p_item);
                        this.getPrivilege_map().put(privilege.getValue(), privilege);
                    }
                    ++i2;
                }
            } else if (nodeName.equals("font")) {
                this.font = new Font();
                this.font.loadElement((Element)node);
            } else if (nodeName.equals("ime")) {
                this.ime = new Ime();
                this.ime.loadElement((Element)node);
            } else if (nodeName.equals("feature")) {
                Feature feature = new Feature();
                feature.loadElement((Element)node);
                this.getFeature_map().put(feature.getKey(), feature);
            } else if (node.getNodeType() == 1) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)node);
                this.getCustomElementList().add(custom);
            }
            node = node.getNextSibling();
        }
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public void runChecker(IProject prj) throws CoreException, ParserConfigurationException, SAXException, IOException {
        if (prj == null) {
            return;
        }
        IFile res = prj.getFile("tizen-manifest.xml");
        assert (res.exists());
        res.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        IFile configFile = prj.getFile("tizen-manifest.xml");
        PositionalXmlParser parser = new PositionalXmlParser();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(res.getContents());
        ManifestSchemaValidator msv = new ManifestSchemaValidator();
        String schemaFile = "manifest_core.xsd";
        if (this.getApiVersion().equalsIgnoreCase("3.0")) {
            schemaFile = "manifest_3.0.xsd";
        } else if (this.getApiVersion().equalsIgnoreCase("2.4")) {
            schemaFile = "manifest_2.4.xsd";
        } else if (this.getApiVersion().equalsIgnoreCase("2.3.2")) {
            schemaFile = "manifest_2.3.2.xsd";
        } else if (this.getApiVersion().equalsIgnoreCase("2.3.1")) {
            schemaFile = "manifest_2.3.1.xsd";
        } else if (this.getApiVersion().equalsIgnoreCase("2.3")) {
            schemaFile = "manifest_2.3.xsd";
        }
        msv.validateConfigurationDocument(configFile, new String[]{"xml.xsd", schemaFile});
        this.validatePackage(doc, (IResource)res, parser);
    }

    private void validatePackage(Document doc, IResource res, PositionalXmlParser parser) throws CoreException {
        IMarker marker;
        PositionalXmlParser.NodePosition pos;
        PositionalXmlParser.NodePosition pos2;
        Element manifest = doc.getDocumentElement();
        String packName = manifest.getAttribute(ATTR_PACKAGE);
        if (packName.length() > Constants.MAX_PKGID_LENGTH || packName.length() < Constants.MIN_PKGID_LENGTH) {
            PositionalXmlParser.NodePosition pos3 = parser.getPosition(manifest);
            IMarker marker2 = res.createMarker(MANIFEST_MARKER_ID);
            marker2.setAttribute("message", (Object)Constants.pkgIDErrorMsg);
            marker2.setAttribute("severity", 2);
            if (pos3 != null) {
                marker2.setAttribute("lineNumber", pos3.getStartLine() + 1);
                marker2.setAttribute("charStart", pos3.getStart());
            } else {
                marker2.setAttribute("lineNumber", 1);
                marker2.setAttribute("charStart", 0);
            }
        }
        String version = manifest.getAttribute(ATTR_VERSION);
        boolean VersionError = false;
        if (version.isEmpty()) {
            VersionError = true;
        } else {
            String[] num = version.split("\\.");
            if (num.length < 3) {
                VersionError = true;
            } else {
                int majorVersion = Integer.parseInt(num[0]);
                int minorVersion = Integer.parseInt(num[1]);
                int minor_minor_Version = Integer.parseInt(num[2]);
                if (majorVersion < 0 || majorVersion > 255) {
                    VersionError = true;
                }
                if (minorVersion < 0 || minorVersion > 255) {
                    VersionError = true;
                }
                if (minor_minor_Version < 0 || minor_minor_Version > 65535) {
                    VersionError = true;
                }
            }
        }
        if (VersionError) {
            pos2 = parser.getPosition(manifest);
            IMarker marker3 = res.createMarker(MANIFEST_MARKER_ID);
            marker3.setAttribute("message", (Object)"Invalid Version Number");
            marker3.setAttribute("severity", 2);
            if (pos2 != null) {
                marker3.setAttribute("lineNumber", pos2.getStartLine() + 1);
                marker3.setAttribute("charStart", pos2.getStart());
            } else {
                marker3.setAttribute("lineNumber", 1);
                marker3.setAttribute("charStart", 0);
            }
        }
        if (packName.length() > Constants.MAX_PKGID_LENGTH || packName.length() < Constants.MIN_PKGID_LENGTH) {
            pos2 = parser.getPosition(manifest);
            IMarker marker4 = res.createMarker(MANIFEST_MARKER_ID);
            marker4.setAttribute("message", (Object)Constants.pkgIDErrorMsg);
            marker4.setAttribute("severity", 2);
            if (pos2 != null) {
                marker4.setAttribute("lineNumber", pos2.getStartLine() + 1);
                marker4.setAttribute("charStart", pos2.getStart());
            } else {
                marker4.setAttribute("lineNumber", 1);
                marker4.setAttribute("charStart", 0);
            }
        }
        NodeList uiApps = manifest.getElementsByTagName("ui-application");
        int i = 0;
        while (i < uiApps.getLength()) {
            String exe;
            IMarker marker5;
            Element e = (Element)uiApps.item(i);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                PositionalXmlParser.NodePosition pos4 = parser.getPosition(e);
                marker5 = res.createMarker(MANIFEST_MARKER_ID);
                marker5.setAttribute("message", (Object)"'appid' does not contain 'package' value");
                marker5.setAttribute("severity", 2);
                if (pos4 != null) {
                    marker5.setAttribute("lineNumber", pos4.getStartLine() + 1);
                    marker5.setAttribute("charStart", pos4.getStart());
                } else {
                    marker5.setAttribute("lineNumber", 1);
                    marker5.setAttribute("charStart", 0);
                }
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                PositionalXmlParser.NodePosition pos5 = parser.getPosition(e);
                marker5 = res.createMarker(MANIFEST_MARKER_ID);
                marker5.setAttribute("message", (Object)Constants.appIDErrorMsg);
                marker5.setAttribute("severity", 2);
                if (pos5 != null) {
                    marker5.setAttribute("lineNumber", pos5.getStartLine() + 1);
                    marker5.setAttribute("charStart", pos5.getStart());
                } else {
                    marker5.setAttribute("lineNumber", 1);
                    marker5.setAttribute("charStart", 0);
                }
            }
            if (!(exe = e.getAttribute("exec")).matches("[a-z0-9\\-_.]*") || exe.isEmpty()) {
                pos = parser.getPosition(e);
                marker = res.createMarker(MANIFEST_MARKER_ID);
                marker.setAttribute("message", (Object)"'exec' cannot contain uppercase letters or be empty");
                marker.setAttribute("severity", 2);
                if (pos != null) {
                    marker.setAttribute("lineNumber", pos.getStartLine() + 1);
                    marker.setAttribute("charStart", pos.getStart());
                } else {
                    marker.setAttribute("lineNumber", 1);
                    marker.setAttribute("charStart", 0);
                }
            }
            ++i;
        }
        NodeList serviceApps = manifest.getElementsByTagName("service-application");
        int i2 = 0;
        while (i2 < serviceApps.getLength()) {
            Element e = (Element)serviceApps.item(i2);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                pos = parser.getPosition(e);
                marker = res.createMarker(MANIFEST_MARKER_ID);
                marker.setAttribute("message", (Object)"'appid' does not contain 'package' value");
                marker.setAttribute("severity", 2);
                if (pos != null) {
                    marker.setAttribute("lineNumber", pos.getStartLine() + 1);
                    marker.setAttribute("charStart", pos.getStart());
                } else {
                    marker.setAttribute("lineNumber", 1);
                    marker.setAttribute("charStart", 0);
                }
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                pos = parser.getPosition(e);
                marker = res.createMarker(MANIFEST_MARKER_ID);
                marker.setAttribute("message", (Object)Constants.appIDErrorMsg);
                marker.setAttribute("severity", 2);
                if (pos != null) {
                    marker.setAttribute("lineNumber", pos.getStartLine() + 1);
                    marker.setAttribute("charStart", pos.getStart());
                } else {
                    marker.setAttribute("lineNumber", 1);
                    marker.setAttribute("charStart", 0);
                }
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                pos = parser.getPosition(e);
                marker = res.createMarker(MANIFEST_MARKER_ID);
                marker.setAttribute("message", (Object)"'exec' cannot contain uppercase letters");
                marker.setAttribute("severity", 2);
                if (pos != null) {
                    marker.setAttribute("lineNumber", pos.getStartLine() + 1);
                    marker.setAttribute("charStart", pos.getStart());
                } else {
                    marker.setAttribute("lineNumber", 1);
                    marker.setAttribute("charStart", 0);
                }
            }
            ++i2;
        }
        NodeList watchApps = manifest.getElementsByTagName("watch-application");
        int i3 = 0;
        while (i3 < watchApps.getLength()) {
            IMarker marker6;
            PositionalXmlParser.NodePosition pos6;
            Element e = (Element)watchApps.item(i3);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                pos6 = parser.getPosition(e);
                marker6 = res.createMarker(MANIFEST_MARKER_ID);
                marker6.setAttribute("message", (Object)"'appid' does not contain 'package' value");
                marker6.setAttribute("severity", 2);
                if (pos6 != null) {
                    marker6.setAttribute("lineNumber", pos6.getStartLine() + 1);
                    marker6.setAttribute("charStart", pos6.getStart());
                } else {
                    marker6.setAttribute("lineNumber", 1);
                    marker6.setAttribute("charStart", 0);
                }
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                pos6 = parser.getPosition(e);
                marker6 = res.createMarker(MANIFEST_MARKER_ID);
                marker6.setAttribute("message", (Object)Constants.appIDErrorMsg);
                marker6.setAttribute("severity", 2);
                if (pos6 != null) {
                    marker6.setAttribute("lineNumber", pos6.getStartLine() + 1);
                    marker6.setAttribute("charStart", pos6.getStart());
                } else {
                    marker6.setAttribute("lineNumber", 1);
                    marker6.setAttribute("charStart", 0);
                }
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                pos6 = parser.getPosition(e);
                marker6 = res.createMarker(MANIFEST_MARKER_ID);
                marker6.setAttribute("message", (Object)"'exec' cannot contain uppercase letters");
                marker6.setAttribute("severity", 2);
                if (pos6 != null) {
                    marker6.setAttribute("lineNumber", pos6.getStartLine() + 1);
                    marker6.setAttribute("charStart", pos6.getStart());
                } else {
                    marker6.setAttribute("lineNumber", 1);
                    marker6.setAttribute("charStart", 0);
                }
            }
            ++i3;
        }
        NodeList widgetApps = manifest.getElementsByTagName("widget-application");
        int i4 = 0;
        while (i4 < widgetApps.getLength()) {
            IMarker marker7;
            PositionalXmlParser.NodePosition pos7;
            Element e = (Element)widgetApps.item(i4);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                pos7 = parser.getPosition(e);
                marker7 = res.createMarker(MANIFEST_MARKER_ID);
                marker7.setAttribute("message", (Object)"'appid' does not contain 'package' value");
                marker7.setAttribute("severity", 2);
                if (pos7 != null) {
                    marker7.setAttribute("lineNumber", pos7.getStartLine() + 1);
                    marker7.setAttribute("charStart", pos7.getStart());
                } else {
                    marker7.setAttribute("lineNumber", 1);
                    marker7.setAttribute("charStart", 0);
                }
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                pos7 = parser.getPosition(e);
                marker7 = res.createMarker(MANIFEST_MARKER_ID);
                marker7.setAttribute("message", (Object)Constants.appIDErrorMsg);
                marker7.setAttribute("severity", 2);
                if (pos7 != null) {
                    marker7.setAttribute("lineNumber", pos7.getStartLine() + 1);
                    marker7.setAttribute("charStart", pos7.getStart());
                } else {
                    marker7.setAttribute("lineNumber", 1);
                    marker7.setAttribute("charStart", 0);
                }
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                pos7 = parser.getPosition(e);
                marker7 = res.createMarker(MANIFEST_MARKER_ID);
                marker7.setAttribute("message", (Object)"'exec' cannot contain uppercase letters");
                marker7.setAttribute("severity", 2);
                if (pos7 != null) {
                    marker7.setAttribute("lineNumber", pos7.getStartLine() + 1);
                    marker7.setAttribute("charStart", pos7.getStart());
                } else {
                    marker7.setAttribute("lineNumber", 1);
                    marker7.setAttribute("charStart", 0);
                }
            }
            ++i4;
        }
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        dom.appendChild(element);
        element.setAttribute(ATTR_XMLNS, this.xmlns);
        if (this.storeclient_id != null && this.storeclient_id.length() > 0) {
            element.setAttribute(ATTR_STORECLIENT_ID, this.storeclient_id);
        }
        if (this.install_location != null && this.install_location.length() > 0) {
            element.setAttribute(ATTR_INSTALL_LOCATION, this.install_location);
        }
        if (this.getPackageId() != null && this.getPackageId().length() > 0) {
            element.setAttribute(ATTR_PACKAGE, this.getPackageId());
        }
        if (this.type != null && this.type.length() > 0) {
            element.setAttribute(ATTR_TYPE, this.type);
        }
        if (this.getApiVersion() != null && this.getApiVersion().length() > 0) {
            element.setAttribute(ATTR_API_VERSION, this.getApiVersion());
        }
        if (this.getVersion() != null && this.getVersion().length() > 0) {
            element.setAttribute(ATTR_VERSION, this.getVersion());
        }
        if (this.size != null && this.size.length() > 0) {
            element.setAttribute(ATTR_SIZE, this.size);
        }
        if (this.root_path != null && this.root_path.length() > 0) {
            element.setAttribute(ATTR_ROOT_PATH, this.root_path);
        }
        if (this.csc_path != null && this.csc_path.length() > 0) {
            element.setAttribute(ATTR_CSC_PATH, this.csc_path);
        }
        if (this.appsetting != null && this.appsetting.length() > 0) {
            element.setAttribute(ATTR_APPSETTING, this.appsetting);
        }
        if (this.nodisplay_setting != null && this.nodisplay_setting.length() > 0) {
            element.setAttribute(ATTR_NODISPLAY_SETTING, this.nodisplay_setting);
        }
        if (this.url != null && this.url.length() > 0) {
            element.setAttribute(ATTR_URL, this.url);
        }
        if (this.support_disable != null && this.support_disable.length() > 0) {
            element.setAttribute(ATTR_SUPPORT_DISABLE, this.support_disable);
        }
        for (CustomAttribute c : this.getCustomAttrList()) {
            c.generateAttribute(element);
        }
        if (this.label_list.size() > 0) {
            int i = 0;
            while (i < this.label_list.size()) {
                this.label_list.get(i).generateElement(dom, element);
                ++i;
            }
        }
        if (this.getIcon() != null) {
            this.getIcon().generateElement(dom, element);
        }
        if (this.author != null) {
            this.author.generateElement(dom, element);
        }
        this.generateDescriptions(dom, element);
        if (this.compatibility != null) {
            this.compatibility.generateElement(dom, element);
        }
        if (this.profile != null) {
            this.profile.generateElement(dom, element);
        }
        if (this.getApplication_list().size() > 0) {
            int i = 0;
            while (i < this.getApplication_list().size()) {
                this.getApplication_list().get(i).generateElement(dom, element);
                ++i;
            }
        }
        if (this.getShortCutList().size() > 0) {
            Element shortcutList = dom.createElement("shortcut-list");
            int i = 0;
            while (i < this.getShortCutList().size()) {
                this.getShortCutList().get(i).generateElement(dom, shortcutList);
                ++i;
            }
            element.appendChild(shortcutList);
        }
        if (this.livebox != null) {
            this.livebox.generateElement(dom, element);
        }
        if (this.dbox_list != null && this.dbox_list.size() > 0) {
            int i = 0;
            while (i < this.dbox_list.size()) {
                this.dbox_list.get(i).generateElement(dom, element);
                ++i;
            }
        }
        if (this.widgetList != null && this.widgetList.size() > 0) {
            int i = 0;
            while (i < this.widgetList.size()) {
                this.widgetList.get(i).generateElement(dom, element);
                ++i;
            }
        }
        if (this.account_list != null && this.account_list.size() > 0) {
            int i = 0;
            while (i < this.account_list.size()) {
                this.account_list.get(i).generateElement(dom, element);
                ++i;
            }
        }
        if (this.notifications != null) {
            this.notifications.generateElement(dom, element);
        }
        if (this.getPrivilege_map().size() > 0) {
            Element privileges = dom.createElement("privileges");
            element.appendChild(privileges);
            Collection<Privilege> values = this.getPrivilege_map().values();
            Iterator<Privilege> Ir_values = values.iterator();
            while (Ir_values.hasNext()) {
                Ir_values.next().generateElement(dom, privileges);
            }
        }
        if (this.getFeature_map().size() > 0) {
            Collection<Feature> values = this.getFeature_map().values();
            Iterator<Feature> Ir_values = values.iterator();
            while (Ir_values.hasNext()) {
                Ir_values.next().generateElement(dom, element);
            }
        }
        if (this.font != null) {
            this.font.generateElement(dom, element);
        }
        if (this.ime != null) {
            this.ime.generateElement(dom, element);
        }
        for (CustomElement c : this.getCustomElementList()) {
            c.generateElement(dom, element);
        }
    }

    public IApplication getDefaultApp() {
        try {
            return this.application_list.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public List<IApplication> getApplication_list() {
        return this.application_list;
    }

    public void setApplication_list(List<IApplication> application_list) {
        this.application_list = application_list;
    }

    public void addPrivilege(String key) {
        Privilege priv = new Privilege(key);
        this.privilege_map.put(key, priv);
    }

    public void addPrivilege(String key, PrivilegeLevel level, String desc) {
        Privilege priv = new Privilege(key, level, desc);
        this.privilege_map.put(key, priv);
    }

    public boolean hasPrivilege(String p) {
        return this.privilege_map.containsKey(p);
    }

    public void removePrivilege(String privilege) {
        this.privilege_map.remove(privilege);
    }

    public TreeMap<String, String> getFeature_list() {
        return this.feature_list;
    }

    public String getFeature(String key) {
        Feature feature = this.feature_map.get(key);
        return feature.getValue();
    }

    public void setFeature_list(TreeMap<String, String> feature_list) {
        this.feature_list = feature_list;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackageId() {
        return this.package_name;
    }

    public void setPackageId(String package_name) {
        this.package_name = package_name;
    }

    public Map<String, Feature> getFeature_map() {
        return this.feature_map;
    }

    public void setFeature_map(Map<String, Feature> feature_map) {
        this.feature_map = feature_map;
    }

    public void addFeature(String key, String value) {
        this.feature_map.put(key, new Feature(key, value));
    }

    public void removeFeature(String key) {
        this.feature_map.remove(key);
    }

    public Map<String, Privilege> getPrivilege_map() {
        return this.privilege_map;
    }

    public void setPrivilege_map(Map<String, Privilege> privilege_map) {
        this.privilege_map = privilege_map;
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public void setXmlns(String xmlns) {
        this.xmlns = xmlns;
    }

    public String getStoreclient_id() {
        return this.storeclient_id;
    }

    public void setStoreclient_id(String storeclient_id) {
        this.storeclient_id = storeclient_id;
    }

    public String getInstall_location() {
        return this.install_location;
    }

    public void setInstall_location(String install_location) {
        this.install_location = install_location;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getRoot_path() {
        return this.root_path;
    }

    public void setRoot_path(String root_path) {
        this.root_path = root_path;
    }

    public String getCsc_path() {
        return this.csc_path;
    }

    public void setCsc_path(String csc_path) {
        this.csc_path = csc_path;
    }

    public String getNodisplay_setting() {
        return this.nodisplay_setting;
    }

    public void setNodisplay_setting(String nodisplay_setting) {
        this.nodisplay_setting = nodisplay_setting;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSupport_disable() {
        return this.support_disable;
    }

    public void setSupport_disable(String support_disable) {
        this.support_disable = support_disable;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public Compatibility getCompatibility() {
        return this.compatibility;
    }

    public void setCompatibility(Compatibility compatibility) {
        this.compatibility = compatibility;
    }

    public Notifications getNotifications() {
        return this.notifications;
    }

    public void setNotifications(Notifications notifications) {
        this.notifications = notifications;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getDefaultDesc() {
        return this.defaultDesc;
    }

    public void setDefaultDesc(String defaultDesc) {
        this.defaultDesc = defaultDesc;
    }

    public List<LocaledValue> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<LocaledValue> descriptions) {
        this.descriptions = descriptions;
    }

    private void generateDescriptions(Document dom, Element parent) {
        List<LocaledValue> desces = this.getDescriptions();
        if (desces.isEmpty() && this.getDefaultDesc() == null) {
            return;
        }
        if (this.getDefaultDesc() != null && this.getDefaultDesc().length() > 0) {
            Element eDesc = dom.createElement("description");
            eDesc.setTextContent(this.getDefaultDesc());
            parent.appendChild(eDesc);
        }
        for (LocaledValue lv : desces) {
            Element eDesc = dom.createElement("description");
            eDesc.setAttribute("xml:lang", lv.getLocale());
            eDesc.setTextContent(lv.getValue());
            parent.appendChild(eDesc);
        }
    }

    public void clear() {
        this.descriptions.clear();
        this.label_list.clear();
        IApplication app = this.getDefaultApp();
        if (app != null) {
            if (app.getAppServiceList() != null) {
                app.getAppServiceList().clear();
            }
            if (app.getBgCategoryList() != null) {
                app.getBgCategoryList().clear();
            }
        }
        this.application_list.clear();
        this.privilege_map.clear();
        this.feature_map.clear();
        this.account_list.clear();
        this.dbox_list.clear();
        this.widgetList.clear();
        this.shortcutList.clear();
        if (app instanceof WidgetApplication) {
            WidgetApplication widgetApp = (WidgetApplication)app;
            widgetApp.getSupportSizesMap().clear();
        }
        this.customElementList.clear();
        this.customAttrList.clear();
    }

    public String getApiVersion() {
        return this.api_version;
    }

    public void setApiVersion(String api_version) {
        this.api_version = api_version;
    }

    public List<Account> getAccounts() {
        return this.account_list;
    }

    public void setAccounts(Account account) {
        this.account_list.add(account);
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfileName(String profileName) {
        if (profileName == null) {
            return;
        }
        this.profile.setName(profileName);
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    private boolean isCustomAttribute(String attr) {
        if (attr.equals(ATTR_API_VERSION)) {
            return false;
        }
        if (attr.equals(ATTR_APPSETTING)) {
            return false;
        }
        if (attr.equals(ATTR_CSC_PATH)) {
            return false;
        }
        if (attr.equals(ATTR_INSTALL_LOCATION)) {
            return false;
        }
        if (attr.equals(ATTR_NODISPLAY_SETTING)) {
            return false;
        }
        if (attr.equals(ATTR_PACKAGE)) {
            return false;
        }
        if (attr.equals(ATTR_ROOT_PATH)) {
            return false;
        }
        if (attr.equals(ATTR_SIZE)) {
            return false;
        }
        if (attr.equals(ATTR_STORECLIENT_ID)) {
            return false;
        }
        if (attr.equals(ATTR_SUPPORT_DISABLE)) {
            return false;
        }
        if (attr.equals(ATTR_TYPE)) {
            return false;
        }
        if (attr.equals(ATTR_URL)) {
            return false;
        }
        if (attr.equals(ATTR_VERSION)) {
            return false;
        }
        return !attr.equals(ATTR_XMLNS);
    }

    public List<Shortcut> getShortCutList() {
        return this.shortcutList;
    }
}

