/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.templateengine.process;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.CreateFolder;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class TizenCreateSourceFolder
extends ProcessRunner {
    public static QualifiedName SOURCEDIR_KEY = new QualifiedName("RegistSrcDir", "RegistSrcDir");
    boolean alreadyRegist = false;

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        ProcessArgument[][] targetPathListInfo = args[1].getComplexArrayValue();
        ArrayList<String> targetPathList = new ArrayList<String>();
        ProcessArgument[][] processArgumentArray = targetPathListInfo;
        int n = targetPathListInfo.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument[] pathInfo = processArgumentArray[n2];
            String targetPath = pathInfo[0].getSimpleValue();
            if (targetPath != null && targetPath.length() > 0) {
                targetPathList.add(targetPath);
            }
            ++n2;
        }
        String value = "";
        try {
            if (processId.contains(" Process 1 ")) {
                IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                value = projectHandle.getPersistentProperty(SOURCEDIR_KEY);
                if (value == null) {
                    projectHandle.setPersistentProperty(SOURCEDIR_KEY, "true");
                    this.alreadyRegist = false;
                } else if (value.equals("true")) {
                    this.alreadyRegist = true;
                }
            }
            if (!this.alreadyRegist) {
                TizenCreateSourceFolder.createSourceFolders(projectName, targetPathList, monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void createSourceFolders(String projectName, List<String> targetPathList, IProgressMonitor monitor) throws ProcessFailureException {
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!projectHandle.exists()) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"CreateSourceFolder.0")) + projectName);
        }
        IPath projPath = projectHandle.getFullPath();
        for (String targetPath : targetPathList) {
            CreateFolder.createFolder((String)projectName, (String)targetPath, (IProgressMonitor)monitor);
        }
        try {
            ICProject cProject = CoreModel.getDefault().create(projectHandle);
            if (cProject != null) {
                if (CCorePlugin.getDefault().isNewStyleProject(cProject.getProject())) {
                    TizenCreateSourceFolder.createNewStyleProjectFolders(monitor, projectHandle, targetPathList);
                } else {
                    for (String targetPath : targetPathList) {
                        TizenCreateSourceFolder.createFolders(targetPath, monitor, projPath, cProject);
                    }
                }
            }
        }
        catch (WriteAccessException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"CreateSourceFolder.2")) + e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"CreateSourceFolder.2")) + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void createNewStyleProjectFolders(IProgressMonitor monitor, IProject projectHandle, List<String> targetPathList) throws CoreException, WriteAccessException {
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(projectHandle);
        ICConfigurationDescription[] configs = description.getConfigurations();
        ArrayList<CSourceEntry> newFolderList = new ArrayList<CSourceEntry>();
        for (String targetPath : targetPathList) {
            CSourceEntry newEntry = new CSourceEntry(projectHandle.getFolder(targetPath), null, 0);
            newFolderList.add(newEntry);
        }
        int i = 0;
        while (i < configs.length) {
            HashSet<ICSourceEntry> newSet = new HashSet<ICSourceEntry>();
            ICConfigurationDescription config = configs[i];
            ICSourceEntry[] entries = config.getSourceEntries();
            int j = 0;
            while (j < entries.length) {
                if (new Path(entries[j].getValue()).segmentCount() != 1) {
                    newSet.add(entries[j]);
                }
                ++j;
            }
            for (ICSourceEntry newFolder : newFolderList) {
                newSet.add(newFolder);
            }
            config.setSourceEntries(newSet.toArray(new ICSourceEntry[newSet.size()]));
            ++i;
        }
        CCorePlugin.getDefault().setProjectDescription(projectHandle, description, false, monitor);
    }

    private static void createFolders(String targetPath, IProgressMonitor monitor, IPath projPath, ICProject cProject) throws CModelException {
        IPathEntry[] entries = cProject.getRawPathEntries();
        ArrayList<Object> newEntries = new ArrayList<Object>(entries.length + 1);
        int projectEntryIndex = -1;
        IPath path = projPath.append(targetPath);
        int i = 0;
        while (i < entries.length) {
            IPathEntry curr = entries[i];
            if (path.equals((Object)curr.getPath())) {
                return;
            }
            if (projPath.equals((Object)curr.getPath())) {
                projectEntryIndex = i;
            }
            newEntries.add(curr);
            ++i;
        }
        ISourceEntry newEntry = CoreModel.newSourceEntry((IPath)path);
        if (projectEntryIndex != -1) {
            newEntries.set(projectEntryIndex, newEntry);
        } else {
            newEntries.add(CoreModel.newSourceEntry((IPath)path));
        }
        cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), monitor);
    }
}

