/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.tizen.common.ITizenProject;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecommon.TizenNativePackageInfoStore;
import org.tizen.nativecommon.build.CommonProjectDependentPackager;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecore.build.NativeCoreProjectDependentPackager;
import org.tizen.nativecore.cli.SetterUtil;
import org.tizen.nativecore.cli.model.ProjectDefFile;
import org.tizen.nativecore.manifest.CoreXmlStore;
import org.tizen.nativecore.util.PackageUtil;

public class ResourceFilterSetter {
    private IProject project;

    public ResourceFilterSetter(IProject project) {
        this.project = project;
    }

    public void setPackageExcludeList(ProjectDefFile projDef) {
        CommonProjectDependentPackager packager = ProjectTypeManager.getProjectPackagerInstance((IProject)this.project);
        NativeCoreProjectDependentPackager nativePackager = null;
        if (packager instanceof NativeCoreProjectDependentPackager) {
            nativePackager = (NativeCoreProjectDependentPackager)packager;
        }
        if (nativePackager == null) {
            return;
        }
        ITizenProject tProject = ProjectUtil.getTizenProject((IProject)this.project);
        TizenNativePackageInfoStore store = (TizenNativePackageInfoStore)tProject.getTizenPkgInfoStore();
        List<String> list = nativePackager.makeExcludeList(store);
        if (PackageUtil.getRefProjects(this.project).length > 0) {
            list.remove(CoreXmlStore.MANIFEST_FILE);
        }
        for (String path : list) {
            path = SetterUtil.isUnderProjectPath(this.project, path) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path));
            if (path.isEmpty()) continue;
            projDef.addPkgExcludeResource(path);
        }
    }
}

