/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover.doxygen;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.OSChecker;

public class DoxygenHandler {
    private static final Logger logger = LoggerFactory.getLogger(DoxygenHandler.class);
    private static final String APIHOVER_BUNDLENAME = "org.tizen.nativeapp";

    public static String getCSSParentPath() {
        String sdkpath = InstallPathConfig.getSDKPath();
        String csspath = "/docs/API_Document/slp/html";
        if (OSChecker.isWindows()) {
            sdkpath = sdkpath.replace("\\", "/");
        }
        return String.valueOf(sdkpath) + csspath;
    }

    public static String getAbsolutePath(String input) {
        String[] url = input.split("#");
        if (url.length != 2) {
            return input;
        }
        return url[0];
    }

    public static String getParentPath(String input) {
        String[] paths = input.split("/");
        if (paths.length > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < paths.length) {
                if (i == paths.length - 1) break;
                sb.append(paths[i]);
                if (i < paths.length - 2) {
                    sb.append("/");
                }
                ++i;
            }
            return sb.toString();
        }
        return DoxygenHandler.getAbsolutePath(input);
    }

    public static String getUrlId(String input) {
        String[] url = input.split("#");
        if (url.length != 2) {
            return input;
        }
        return url[1];
    }

    public static String getHtmlPrologue(String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/xhtml;charset=UTF-8\"/>\n");
        sb.append("<link href=\"" + url + "/tabs.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
        sb.append("<link href=\"" + url + "/doxygen.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
        sb.append("<body>\n");
        return sb.toString();
    }

    public static String getHtmlEpilogue() {
        StringBuilder sb = new StringBuilder();
        sb.append("</body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }

    public static String grepInputHtml(String html, String id) {
        if (html == null || id == null) {
            return null;
        }
        String doxytag = "<!-- doxytag: member=\"";
        int s = html.indexOf("<a class=\"anchor\" id=\"" + id + "\"></a>");
        if (s < 0) {
            return null;
        }
        StringBuilder headerTag = new StringBuilder();
        if ((s = html.indexOf(doxytag, s)) < 0) {
            return null;
        }
        int e = html.indexOf("::", s);
        int max = html.indexOf(">", s);
        if (e > 0 && e < max) {
            String headerfile = html.substring(s + doxytag.length(), e);
            if (headerfile.endsWith(".h")) {
                headerTag.append("<dl class=\"see\"><dt><b>Header files:</b></dt><dd>");
                headerTag.append(headerfile);
                headerTag.append("</dd></dl>");
            }
        } else {
            if ((s = html.lastIndexOf(doxytag, s - 1)) < 0) {
                return null;
            }
            if ((s = html.lastIndexOf("<a class=\"anchor\" id=\"", s)) < 0) {
                return null;
            }
            e = html.indexOf("\"", s + "<a class=\"anchor\" id=\"".length());
            String preid = html.substring(s + "<a class=\"anchor\" id=\"".length(), e);
            if (!id.equals(preid)) {
                DoxygenHandler.grepInputHtml(html, preid);
            }
        }
        if ((s = html.indexOf("<div class=\"memitem\">", s)) < 0) {
            return null;
        }
        String endTag = "</div>\n</div>";
        e = html.indexOf(endTag, s);
        if (e < 0) {
            e = html.indexOf("Copyright ", s);
            if (e < 0) {
                e = html.indexOf(endTag, s);
                if (s > e + endTag.length()) {
                    return null;
                }
                return html.substring(s, e + endTag.length());
            }
            return null;
        }
        if (e < 0) {
            return null;
        }
        if (headerTag.length() > 0) {
            StringBuilder retHtml = new StringBuilder();
            if (s > e) {
                return null;
            }
            retHtml.append(html.substring(s, e));
            retHtml.append((CharSequence)headerTag);
            retHtml.append(endTag);
            return retHtml.toString();
        }
        return html.substring(s, e);
    }

    public static String grepBodyHtml(String html) {
        if (html == null) {
            return null;
        }
        int s = html.indexOf("<body");
        int e = 0;
        if (s < 0) {
            return null;
        }
        e = (s = html.indexOf("<div class=\"header\">", s)) > 0 ? html.indexOf("body>", s) : html.indexOf("body>", "<body".length());
        if (e < 0) {
            return null;
        }
        return html.substring(s, e);
    }

    public static String getJavaScript(String jsname) {
        String jsStr = null;
        Bundle bundle = Platform.getBundle((String)APIHOVER_BUNDLENAME);
        File js = null;
        try {
            URL indexFileURL = bundle.getEntry(jsname);
            if (indexFileURL != null) {
                indexFileURL = FileLocator.toFileURL((URL)indexFileURL);
                js = new File(indexFileURL.toURI());
            } else {
                js = FileLocator.getBundleFile((Bundle)bundle);
            }
            jsStr = FileUtil.readTextFile((File)js, null);
        }
        catch (IOException e) {
            logger.error("Unknown error occurred", (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error("Unknown error occurred", (Throwable)e);
        }
        return jsStr;
    }
}

