/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.sa;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;

public class TizenSATool {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File fTool;
    private File fOutDir;
    private List<String> checkTypes;
    private List<String> selectedCheckTypes;
    private String outType;
    public static final String TOOL_NAME;
    public static final String MAKE_COMMAND = "make";
    public static final String OUT_DIR_OPTION_FORMAT = " -o %s";
    public static final String OUT_TYPE_OPTION_FORMAT = " -analyzer-output=%s";
    public static final String[] OUT_TYPE;
    public static final String OUT_DEFAULT_DIR_NAME = "TizenSAResult";

    static {
        OUT_TYPE = new String[]{"html", "xml"};
        TOOL_NAME = OSChecker.isWindows() ? "clangFnMapGen.exe" : "clangFnMapGen";
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    public void setOutDir(File outDir) {
        this.fOutDir = outDir;
    }

    public String getBuildCommand() {
        return String.valueOf(TOOL_NAME) + " " + this.getArgs();
    }

    public String getToolName() {
        return TOOL_NAME;
    }

    public String getArgs() {
        StringBuilder buildCommand = new StringBuilder(MAKE_COMMAND);
        if (!StringUtil.isEmpty((CharSequence)this.outType) && this.fOutDir != null && !this.fOutDir.isFile()) {
            try {
                String outputDir = this.fOutDir.getCanonicalPath();
                buildCommand.append(String.format(OUT_TYPE_OPTION_FORMAT, this.outType));
                buildCommand.append(String.format(OUT_DIR_OPTION_FORMAT, outputDir));
            }
            catch (IOException e) {
                this.logger.warn("Failed to make arguments of " + TOOL_NAME, (Throwable)e);
                return MAKE_COMMAND;
            }
        }
        return buildCommand.toString();
    }

    public static boolean isInstalledTool(IProject project) {
        String path = String.valueOf(CommonConfigurationManager.getCompilerToolchainBinPath(project)) + "/" + TOOL_NAME;
        return new File(path).exists();
    }
}

