/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class IncludeExportPatterns {
    private final Pattern includeExportPattern;
    private final Pattern includeBeginExportsPattern;
    private final Pattern includeEndExportsPattern;

    public IncludeExportPatterns(String exportPattern, String beginExportsPattern, String endExportsPattern) {
        this.includeExportPattern = this.compilePattern(exportPattern);
        this.includeBeginExportsPattern = this.compilePattern(beginExportsPattern);
        this.includeEndExportsPattern = this.compilePattern(endExportsPattern);
    }

    private Pattern compilePattern(String pattern) {
        try {
            return pattern == null ? null : Pattern.compile(pattern);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    public Pattern getIncludeExportPattern() {
        return this.includeExportPattern;
    }

    public Pattern getIncludeBeginExportsPattern() {
        return this.includeBeginExportsPattern;
    }

    public Pattern getIncludeEndExportsPattern() {
        return this.includeEndExportsPattern;
    }
}

