/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.util.ASTNodes;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.cdt.internal.core.util.TextUtil;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.corext.codemanipulation.StyledInclude;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeCreationContext;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludePreferences;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeUtil;
import org.eclipse.cdt.internal.ui.refactoring.rename.ASTManager;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameCSourceFolderChange;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.ui.refactoring.CTextFileChange;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class HeaderFileReferenceAdjuster {
    private static final int PARSE_MODE = 167;
    private final Map<IFile, IFile> movedFiles;
    private final Map<String, IPath> movedFilesByLocation;
    private final Map<IContainer, IContainer> renamedContainers;
    private ASTManager astManager;
    private IIndex index;
    private int indexLockCount;

    public HeaderFileReferenceAdjuster(Map<IFile, IFile> movedFiles, Map<IContainer, IContainer> renamedContainers, RefactoringProcessor processor) {
        this.movedFiles = movedFiles;
        this.movedFilesByLocation = new HashMap<String, IPath>();
        for (Map.Entry<IFile, IFile> entry : movedFiles.entrySet()) {
            this.movedFilesByLocation.put(entry.getKey().getLocation().toString(), entry.getValue().getLocation());
        }
        this.renamedContainers = renamedContainers;
        this.astManager = HeaderFileReferenceAdjuster.getASTManager(processor);
    }

    public Change createChange(CheckConditionsContext context, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        CompositeChange change = null;
        HashSet<IFile> affectedFiles = new HashSet<IFile>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.lockIndex();
        ASTManager sharedASTManager = this.astManager;
        if (this.astManager == null) {
            this.astManager = new ASTManager(null);
        }
        try {
            for (Map.Entry<IFile, IFile> entry : this.movedFiles.entrySet()) {
                IIndexFile[] indexFiles;
                IFile newFile;
                IFile oldFile = entry.getKey();
                if (HeaderFileReferenceAdjuster.areIncludeGuardsAffected(oldFile, newFile = entry.getValue())) {
                    affectedFiles.add(oldFile);
                }
                IIndexFileLocation indexFileLocation = IndexLocationFactory.getWorkspaceIFL((IFile)oldFile);
                IIndexFile[] iIndexFileArray = indexFiles = this.index.getFiles(indexFileLocation);
                int n = indexFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexInclude[] includes;
                    IIndexFile indexFile = iIndexFileArray[n2];
                    IIndexInclude[] iIndexIncludeArray = includes = this.index.findIncludedBy(indexFile);
                    int n3 = includes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource;
                        IIndexInclude include = iIndexIncludeArray[n4];
                        IIndexFileLocation includeLocation = include.getIncludedByLocation();
                        String path = includeLocation.getFullPath();
                        if (path != null && (resource = workspaceRoot.findMember(path)).getType() == 1) {
                            IFile includer = (IFile)resource;
                            affectedFiles.add(includer);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            IWorkingCopyManager workingCopyManager = CUIPlugin.getDefault().getWorkingCopyManager();
            IWorkingCopy[] workingCopies = workingCopyManager.getSharedWorkingCopies();
            progress.worked(1);
            progress = SubMonitor.convert((IProgressMonitor)progress.newChild(9), (int)(workingCopies.length + affectedFiles.size()));
            ArrayList<Change> changes = new ArrayList<Change>();
            ValidateEditChecker checker = (ValidateEditChecker)context.getChecker(ValidateEditChecker.class);
            IWorkingCopy[] iWorkingCopyArray = workingCopies;
            int n = workingCopies.length;
            int indexFiles = 0;
            while (indexFiles < n) {
                IWorkingCopy tu = iWorkingCopyArray[indexFiles];
                this.addFileChange((ITranslationUnit)tu, changes, checker, (IProgressMonitor)progress.newChild(1));
                ++indexFiles;
            }
            CoreModel coreModel = CoreModel.getDefault();
            for (IFile file : affectedFiles) {
                ITranslationUnit tu = (ITranslationUnit)coreModel.create(file);
                if (tu == null || workingCopyManager.findSharedWorkingCopy(tu) != null) continue;
                this.addFileChange(tu, changes, checker, (IProgressMonitor)progress.newChild(1));
            }
            if (!changes.isEmpty()) {
                change = new CompositeChange("", changes.toArray(new Change[changes.size()]));
                change.markAsSynthetic();
            }
        }
        finally {
            if (this.astManager != sharedASTManager) {
                this.astManager.dispose();
                this.astManager = null;
            }
            this.unlockIndex();
            pm.done();
        }
        return change;
    }

    private void addFileChange(ITranslationUnit tu, List<Change> changes, ValidateEditChecker checker, IProgressMonitor pm) throws CoreException {
        TextEditGroup editGroup = this.createEdit(tu, pm);
        if (editGroup != null) {
            CTextFileChange fileChange = new CTextFileChange(tu.getElementName(), tu);
            TextEdit[] edits = editGroup.getTextEdits();
            if (edits.length == 1) {
                fileChange.setEdit(edits[0]);
            } else {
                fileChange.setEdit((TextEdit)new MultiTextEdit());
                TextEdit[] textEditArray = edits;
                int n = edits.length;
                int n2 = 0;
                while (n2 < n) {
                    TextEdit edit = textEditArray[n2];
                    fileChange.addEdit(edit);
                    ++n2;
                }
            }
            fileChange.addTextEditGroup(editGroup);
            changes.add((Change)fileChange);
            checker.addFile(fileChange.getFile());
        }
    }

    private TextEditGroup createEdit(ITranslationUnit tu, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        HeaderFileReferenceAdjuster.checkCanceled(monitor);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IASTTranslationUnit ast = this.astManager.getAST(this.index, tu.getFile(), 167, false);
        progress.setWorkRemaining(1);
        if (ast == null) {
            return null;
        }
        return this.createEdit(ast, tu, (IProgressMonitor)progress.newChild(1));
    }

    /*
     * WARNING - void declaration
     */
    private TextEditGroup createEdit(IASTTranslationUnit ast, ITranslationUnit tu, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IASTPreprocessorIncludeStatement[] existingIncludes;
        String contents;
        MultiTextEdit rootEdit;
        IncludeCreationContext context = new IncludeCreationContext(tu, this.index);
        IFile movedFile = this.movedFiles.get(tu.getFile());
        if (movedFile != null) {
            context.setTranslationUnitLocation(movedFile.getLocation());
        }
        int numIncludeGuardEdits = (rootEdit = this.createIncludeGuardEdit(ast, tu, contents = context.getSourceContents())) == null ? 0 : rootEdit.getChildrenSize();
        IdentityHashMap<IASTPreprocessorIncludeStatement, Object> affectedIncludes = new IdentityHashMap<IASTPreprocessorIncludeStatement, Object>();
        IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = existingIncludes = ast.getIncludeDirectives();
        int n = existingIncludes.length;
        int n2 = 0;
        while (n2 < n) {
            block41: {
                void var15_20;
                Object newLocation;
                IASTPreprocessorIncludeStatement include;
                block43: {
                    block42: {
                        include = iASTPreprocessorIncludeStatementArray[n2];
                        if (!include.isPartOfTranslationUnitFile()) break block41;
                        if (!include.isActive()) break block42;
                        String n4 = include.getPath();
                        if (n4.isEmpty()) break block41;
                        if (File.separatorChar == '\\') {
                            String string = new Path(n4).toString();
                        }
                        break block43;
                    }
                    String name = new String(include.getName().getSimpleID());
                    IncludeInfo includeInfo = new IncludeInfo(name, include.isSystemInclude());
                    IPath path = context.resolveInclude(includeInfo);
                    if (path == null) break block41;
                    String string = path.toString();
                }
                if ((newLocation = this.movedFilesByLocation.get(var15_20)) != null) {
                    affectedIncludes.put(include, newLocation);
                }
            }
            ++n2;
        }
        if (!affectedIncludes.isEmpty()) {
            void var15_29;
            IPath header;
            NodeCommentMap commentedNodeMap = ASTCommenter.getCommentedNodeMap((IASTTranslationUnit)ast);
            IRegion includeRegion = IncludeUtil.getSafeIncludeReplacementRegion(contents, ast, commentedNodeMap);
            IncludePreferences preferences = context.getPreferences();
            if (rootEdit == null) {
                rootEdit = new MultiTextEdit();
            }
            context.addHeadersIncludedPreviously(existingIncludes);
            if (preferences.allowReordering) {
                void var20_41;
                Object include;
                ArrayList<Object> modifiedIncludes = new ArrayList<Object>();
                for (Map.Entry entry : affectedIncludes.entrySet()) {
                    IASTPreprocessorIncludeStatement existingInclude = (IASTPreprocessorIncludeStatement)entry.getKey();
                    if (!IncludeUtil.isContainedInRegion((IASTNode)existingInclude, includeRegion)) continue;
                    header = (IPath)entry.getValue();
                    IncludeGroupStyle style = context.getIncludeStyle(header);
                    IncludeInfo includeInfo = context.createIncludeInfo(header, style);
                    include = new StyledInclude(header, includeInfo, style, existingInclude);
                    modifiedIncludes.add(include);
                }
                Collections.sort(modifiedIncludes, preferences);
                List<StyledInclude> list = IncludeUtil.getIncludesInRegion(existingIncludes, includeRegion, context);
                ArrayDeque<DeleteEdit> deletes = new ArrayDeque<DeleteEdit>();
                int deleteOffset = -1;
                boolean emptyLineEncountered = false;
                int j = 0;
                boolean bl = false;
                while (var20_41 < list.size()) {
                    include = list.get((int)var20_41);
                    IASTPreprocessorIncludeStatement existingInclude = ((StyledInclude)include).getExistingInclude();
                    int offset = ASTNodes.offset((IASTNode)existingInclude);
                    boolean previousLineBlank = TextUtil.isPreviousLineBlank((String)contents, (int)offset);
                    if (affectedIncludes.containsKey(existingInclude)) {
                        if (deleteOffset < 0) {
                            deleteOffset = offset;
                        } else if (!emptyLineEncountered && previousLineBlank) {
                            deletes.add(new DeleteEdit(deleteOffset, offset - deleteOffset));
                            deleteOffset = -1;
                        }
                        emptyLineEncountered |= previousLineBlank;
                    } else {
                        if (deleteOffset >= 0) {
                            if (!emptyLineEncountered && previousLineBlank) {
                                offset = TextUtil.getPreviousLineStart((String)contents, (int)offset);
                            }
                            deletes.add(new DeleteEdit(deleteOffset, offset - deleteOffset));
                            deleteOffset = -1;
                        }
                        emptyLineEncountered = false;
                        if (j < var20_41) {
                            list.set(j, (StyledInclude)include);
                        }
                        ++j;
                    }
                    ++var20_41;
                }
                while (j < list.size()) {
                    list.remove(list.size() - 1);
                }
                if (deleteOffset >= 0) {
                    deletes.add(new DeleteEdit(deleteOffset, includeRegion.getOffset() + includeRegion.getLength() - deleteOffset));
                }
                for (StyledInclude styledInclude : modifiedIncludes) {
                    if (!IncludeUtil.isContainedInRegion((IASTNode)styledInclude.getExistingInclude(), includeRegion)) continue;
                    int i2 = list.size();
                    while (--i2 >= 0 && preferences.compare(styledInclude, list.get(i2)) < 0) {
                    }
                    list.add(i2 + 1, styledInclude);
                }
                int n3 = includeRegion.getOffset();
                StringBuilder text = new StringBuilder();
                StyledInclude previousInclude = null;
                for (StyledInclude include3 : list) {
                    int n4;
                    IASTPreprocessorIncludeStatement existingInclude = include3.getExistingInclude();
                    if (affectedIncludes.containsKey(existingInclude)) {
                        if (previousInclude != null) {
                            IASTPreprocessorIncludeStatement previousNode = previousInclude.getExistingInclude();
                            if (!affectedIncludes.containsKey(previousNode)) {
                                n4 = ASTNodes.skipToNextLineAfterNode((String)contents, (IASTNode)previousNode);
                                this.flushEditBuffer(n4, text, deletes, rootEdit);
                                if (contents.charAt(n4 - 1) != '\n') {
                                    text.append(context.getLineDelimiter());
                                }
                            }
                            if (HeaderFileReferenceAdjuster.isBlankLineNeededBetween(previousInclude, include3, preferences)) {
                                if (TextUtil.isLineBlank((String)contents, (int)n4)) {
                                    int oldOffset = n4;
                                    if ((n4 = TextUtil.skipToNextLine((String)contents, (int)n4)) == oldOffset || contents.charAt(n4 - 1) != '\n') {
                                        text.append(context.getLineDelimiter());
                                    }
                                } else {
                                    text.append(context.getLineDelimiter());
                                }
                            }
                        }
                        text.append(include3.getIncludeInfo().composeIncludeStatement());
                        List comments = commentedNodeMap.getTrailingCommentsForNode((IASTNode)existingInclude);
                        for (IASTComment comment : comments) {
                            text.append(ASTNodes.getPrecedingWhitespaceInLine((String)contents, (IASTNode)comment));
                            text.append(comment.getRawSignature());
                        }
                        text.append(context.getLineDelimiter());
                    } else {
                        if (previousInclude != null && affectedIncludes.containsKey(previousInclude.getExistingInclude()) && HeaderFileReferenceAdjuster.isBlankLineNeededBetween(previousInclude, include3, preferences) && TextUtil.findBlankLine((String)contents, (int)this.skipDeletedRegion(n4, deletes), (int)ASTNodes.offset((IASTNode)existingInclude)) < 0) {
                            text.append(context.getLineDelimiter());
                        }
                        this.flushEditBuffer(n4, text, deletes, rootEdit);
                    }
                    previousInclude = include3;
                }
                if (includeRegion.getLength() == 0 && !TextUtil.isLineBlank((String)contents, (int)includeRegion.getOffset())) {
                    text.append(context.getLineDelimiter());
                }
                int n5 = includeRegion.getOffset() + includeRegion.getLength();
                this.flushEditBuffer(n5, text, deletes, rootEdit);
            }
            IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray2 = existingIncludes;
            int n6 = existingIncludes.length;
            boolean bl = false;
            while (var15_29 < n6) {
                IASTPreprocessorIncludeStatement existingInclude = iASTPreprocessorIncludeStatementArray2[var15_29];
                header = (IPath)affectedIncludes.get(existingInclude);
                if (!(header == null || preferences.allowReordering && IncludeUtil.isContainedInRegion((IASTNode)existingInclude, includeRegion))) {
                    IncludeGroupStyle style = context.getIncludeStyle(header);
                    IncludeInfo includeInfo = context.createIncludeInfo(header, style);
                    IASTName name = existingInclude.getName();
                    int offset = ASTNodes.offset((IASTNode)name) - 1;
                    int length = ASTNodes.endOffset((IASTNode)name) + 1 - offset;
                    rootEdit.addChild((TextEdit)new ReplaceEdit(offset, length, includeInfo.toString()));
                }
                ++var15_29;
            }
        }
        if (rootEdit == null) {
            return null;
        }
        int numEdits = rootEdit.getChildrenSize();
        String message = numEdits == numIncludeGuardEdits ? RenameMessages.HeaderReferenceAdjuster_update_include_guards : (numIncludeGuardEdits == 0 ? RenameMessages.HeaderReferenceAdjuster_update_includes : RenameMessages.HeaderReferenceAdjuster_update_include_guards_and_includes);
        TextEditGroup editGroup = new TextEditGroup(message, (TextEdit)rootEdit);
        return editGroup;
    }

    private static boolean isBlankLineNeededBetween(StyledInclude include1, StyledInclude include2, IncludePreferences preferences) {
        return include2.getStyle().isBlankLineNeededAfter(include1.getStyle(), preferences.includeStyles);
    }

    private MultiTextEdit createIncludeGuardEdit(IASTTranslationUnit ast, ITranslationUnit tu, String contents) {
        IResource resource = tu.getResource();
        IFile newFile = this.movedFiles.get(resource);
        if (newFile == null) {
            return null;
        }
        boolean guardsAffected = HeaderFileReferenceAdjuster.areIncludeGuardsAffected((IFile)resource, newFile);
        if (!guardsAffected) {
            return null;
        }
        ArrayList<IRegion> includeGuardPositions = new ArrayList<IRegion>();
        String oldGuard = IncludeUtil.findIncludeGuard(contents, ast, includeGuardPositions);
        if (oldGuard == null) {
            return null;
        }
        if (!oldGuard.equals(StubUtility.generateIncludeGuardSymbol(resource, tu.getCProject()))) {
            return null;
        }
        String guard = this.generateNewIncludeGuardSymbol(resource, newFile, tu.getCProject());
        if (guard == null || guard.equals(oldGuard)) {
            return null;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        for (IRegion region : includeGuardPositions) {
            rootEdit.addChild((TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), guard));
        }
        return rootEdit;
    }

    private String generateNewIncludeGuardSymbol(IResource resource, IFile newFile, ICProject cProject) {
        switch (HeaderFileReferenceAdjuster.getIncludeGuardScheme(cProject.getProject())) {
            case 2: {
                IPath path;
                ISourceRoot[] roots;
                IProject newProject = newFile.getProject();
                if (newProject.exists() && (cProject = CoreModel.getDefault().create(newProject)) == null) break;
                try {
                    roots = cProject.getAllSourceRoots();
                }
                catch (CModelException cModelException) {
                    break;
                }
                IContainer base = null;
                ISourceRoot[] iSourceRootArray = roots;
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    ISourceRoot root = iSourceRootArray[n2];
                    if ((root = this.getModifiedSourceRoot(cProject, root)).isOnSourceEntry((IResource)newFile)) {
                        base = root.getResource();
                        break;
                    }
                    ++n2;
                }
                if (base == null || (path = PathUtil.makeRelativePath((IPath)newFile.getFullPath(), (IPath)base.getFullPath())) == null) break;
                return StubUtility.generateIncludeGuardSymbolFromFilePath(path.toString());
            }
            case 0: {
                return StubUtility.generateIncludeGuardSymbolFromFilePath(newFile.getName());
            }
        }
        return null;
    }

    protected ISourceRoot getModifiedSourceRoot(ICProject cProject, ISourceRoot root) {
        IContainer container = root.getResource();
        ICSourceEntry sourceEntry = ((SourceRoot)root).getSourceEntry();
        for (Map.Entry<IContainer, IContainer> entry : this.renamedContainers.entrySet()) {
            IPath oldFolderPath = entry.getKey().getFullPath();
            IPath newFolderPath = entry.getValue().getFullPath();
            sourceEntry = RenameCSourceFolderChange.renameSourceEntry(sourceEntry, oldFolderPath, newFolderPath);
        }
        IContainer newContainer = this.getModifiedContainer(container);
        return new SourceRoot((ICElement)cProject, (IResource)newContainer, sourceEntry);
    }

    private IContainer getModifiedContainer(IContainer container) {
        Path relativePath = Path.EMPTY;
        IContainer ancestor = container;
        while (ancestor.getType() != 8) {
            IContainer newContainer = this.renamedContainers.get(ancestor);
            if (newContainer != null) {
                if (relativePath.isEmpty()) {
                    return newContainer;
                }
                return newContainer.getFolder((IPath)relativePath);
            }
            relativePath = new Path(ancestor.getName()).append((IPath)relativePath);
            ancestor = ancestor.getParent();
        }
        return container;
    }

    private void flushEditBuffer(int offset, StringBuilder text, Deque<DeleteEdit> deletes, MultiTextEdit edit) {
        this.consumeDeletesUpTo(offset, deletes, edit);
        if (text.length() != 0) {
            edit.addChild((TextEdit)new InsertEdit(offset, text.toString()));
            text.delete(0, text.length());
        }
    }

    private void consumeDeletesUpTo(int offset, Deque<DeleteEdit> deletes, MultiTextEdit rootEdit) {
        while (!deletes.isEmpty()) {
            DeleteEdit edit = deletes.peek();
            if (edit.getOffset() > offset) break;
            deletes.remove();
            rootEdit.addChild((TextEdit)edit);
        }
    }

    private int skipDeletedRegion(int offset, Deque<DeleteEdit> deletes) {
        for (DeleteEdit edit : deletes) {
            if (edit.getOffset() > offset) break;
            offset = edit.getExclusiveEnd();
        }
        return offset;
    }

    private void lockIndex() throws CoreException, OperationCanceledException {
        if (this.indexLockCount == 0) {
            if (this.index == null) {
                ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
                this.index = CCorePlugin.getIndexManager().getIndex(projects, 1024);
            }
            try {
                this.index.acquireReadLock();
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        ++this.indexLockCount;
    }

    private void unlockIndex() {
        if (--this.indexLockCount <= 0) {
            if (this.index != null) {
                this.index.releaseReadLock();
            }
            this.index = null;
        }
    }

    private static ASTManager getASTManager(RefactoringProcessor processor) {
        if (processor instanceof CRenameProcessor) {
            return ((CRenameProcessor)processor).getAstManager();
        }
        return null;
    }

    private static void checkCanceled(IProgressMonitor pm) throws OperationCanceledException {
        if (pm != null && pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static boolean areIncludeGuardsAffected(IFile oldfile, IFile newFile) {
        String filename;
        IProject project = oldfile.getProject();
        if (!CoreModel.isValidHeaderUnitName((IProject)project, (String)(filename = oldfile.getLocation().lastSegment()))) {
            return false;
        }
        switch (HeaderFileReferenceAdjuster.getIncludeGuardScheme(project)) {
            case 2: {
                return true;
            }
            case 0: {
                return !filename.equals(newFile.getName());
            }
        }
        return false;
    }

    private static int getIncludeGuardScheme(IProject project) {
        IPreferencesService preferences = Platform.getPreferencesService();
        IScopeContext[] scopes = PreferenceConstants.getPreferenceScopes(project);
        int scheme = preferences.getInt("org.eclipse.cdt.ui", "codetemplates.includeGuardGenerationScheme", 0, scopes);
        return scheme;
    }
}

