/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.IOException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.common.ui.dialog.LinkDialog;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.LocalPortChecker;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.Activator;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.TizenNativeLaunchConfiguration;
import org.tizen.nativecommon.ui.preferences.TizenNativeDebugPreferencePage;
import org.tizen.sdblib.Arch;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class LaunchUtils {
    public static final String[] ARCHITECTURE_86 = CommonConfigurationManager.ARCHGROUP_X86;
    public static final String[] ARCHITECTURE_ARM = CommonConfigurationManager.ARCHGROUP_ARM;
    public static final String[] ARCHITECTURE_X86_64 = CommonConfigurationManager.ARCHGROUP_X86_64;
    public static final String[] ARCHITECTURE_ARM_64 = CommonConfigurationManager.ARCHGROUP_ARM_64;
    public static final String ARCH_86_SYMBOL = ARCHITECTURE_86[0];
    public static final String ARCH_ARM_SYMBOL = ARCHITECTURE_ARM[0];
    public static final String ARCH_X86_64_SYMBOL = ARCHITECTURE_X86_64[0];
    public static final String ARCH_ARM_64_SYMBOL = ARCHITECTURE_ARM_64[0];
    public static final String PORT_CHECK = "netstat -an | grep 0.0.0.0:%s | awk '{print $6}'";
    public static final String LISTEN_PORT_CHECK = "\"netstat -an | grep 0.0.0.0:%s | grep LISTEN | wc -l\"";
    public static final String PORT_STATE_LISTEN = "LISTEN";
    public static final int MIN_PORTNO = 26101;
    public static final int MAX_PORTNO = 26150;
    public static final int[] RESERVED_PORTNO = new int[]{26101, 26103, 26111, 26113, 26121, 26123, 26131, 26133, 26141, 26143};
    private static Logger logger = LoggerFactory.getLogger(LaunchUtils.class);

    public static boolean isVerboseMode(ILaunchConfiguration configuration) {
        boolean verboseMode = false;
        try {
            verboseMode = configuration.getAttribute("org.tizen.nativecommon.ATTR_LAUNCH_VERBOSE_CONSOLE", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return verboseMode;
    }

    public static boolean isUpdateMode(ILaunchConfiguration configuration) {
        block4: {
            if (configuration == null) {
                return false;
            }
            try {
                IProject project = ProjectUtil.getProject(configuration);
                if (!RdsPreferencePage.isRdsMode((IProject)project)) break block4;
                return false;
            }
            catch (CoreException e) {
                logger.error("Failed to read update mode option", (Throwable)e);
                return false;
            }
        }
        return configuration.getAttribute("org.tizen.nativecommon.ATTR_LAUNCH_UPDATE_MODE", false);
    }

    public static String getPkgId(String appId, SdbCommand sdbCommand) throws Exception {
        String key = "Package: ";
        String command = String.format(TizenPlatformConstants.PKG_TOOL_APPID_CHECK_COMMAND, appId, key);
        try {
            sdbCommand.runCommand(command);
        }
        catch (Exception e) {
            logger.error("Failed to run a command " + command, (Throwable)e);
            throw e;
        }
        String[] lines = sdbCommand.getResultLineStrings();
        String result = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(key)) {
                result = line.substring(key.length());
                break;
            }
            ++n2;
        }
        return result;
    }

    public static void verifyExecutableBinary(IProject project, IPath exePath) throws CoreException {
        boolean found = false;
        ICProject cproject = CoreModel.getDefault().create(project);
        if (cproject != null) {
            IBinary[] bins = cproject.getBinaryContainer().getBinaries();
            int j = 0;
            while (j < bins.length) {
                if (bins[j].isExecutable() && ProjectUtil.isApplicationProject(project) && exePath.equals((Object)bins[j].getPath())) {
                    found = true;
                    break;
                }
                ++j;
            }
        }
        if (!found) {
            LaunchUtils.newCoreException(NLS.bind((String)TizenLaunchMessages.CANNOT_RECOGNIZE_EXECUTABLE, (Object)exePath.toOSString()), null);
        }
    }

    public static void verifyExecutableProject(IProject project) throws CoreException {
        if (project != null) {
            if (ProjectUtil.isApplicationProject(project)) {
                return;
            }
            if (ProjectUtil.isSharedLibraryProject(project) || ProjectUtil.isStaticLibraryProject(project)) {
                LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_LIBRARY_PROJECT, null);
            }
        }
        LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_UNSUPPORTED_PROJECT, null);
    }

    public static void newCoreException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.tizen.nativecommon", message, exception);
        throw new CoreException((IStatus)status);
    }

    public static void newCoreException(int severity, String message, Throwable exception) throws CoreException {
        Status status = new Status(severity, "org.tizen.nativecommon", message, exception);
        throw new CoreException((IStatus)status);
    }

    public static void setStopAtMain(ILaunchConfigurationWorkingCopy configuration, IProject proj) {
        try {
            String projectName;
            if (proj == null && (projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "")).length() > 0) {
                proj = ProjectUtil.getProject(projectName);
            }
            if (proj != null) {
                if (ProjectUtil.isDebuggableProject(proj)) {
                    IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                    configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", store.getBoolean(TizenNativeDebugPreferencePage.KEY_STOP_AT_MAIN));
                    configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", store.getString(TizenNativeDebugPreferencePage.KEY_STOP_AT_MAIN_SYMBOL));
                }
            } else {
                configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", TizenNativeDebugPreferencePage.VALUE_STOP_AT_MAIN_DEFAULT);
            }
        }
        catch (CoreException coreException) {
            configuration.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", TizenNativeDebugPreferencePage.VALUE_STOP_AT_MAIN_DEFAULT);
        }
    }

    public static boolean isX86(String arch) {
        return LaunchUtils._isSame(ARCHITECTURE_86, arch);
    }

    public static boolean isArm(String arch) {
        return LaunchUtils._isSame(ARCHITECTURE_ARM, arch);
    }

    public static boolean isX86_64(String arch) {
        return LaunchUtils._isSame(ARCHITECTURE_X86_64, arch);
    }

    public static boolean isArm_64(String arch) {
        return LaunchUtils._isSame(ARCHITECTURE_ARM_64, arch);
    }

    private static boolean _isSame(String[] archTypes, String arch) {
        if (ArrayUtil.isEmpty((Object[])archTypes)) {
            return false;
        }
        if (StringUtil.isEmpty((CharSequence)arch)) {
            return false;
        }
        String[] stringArray = archTypes;
        int n = archTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.contains(arch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isSameArch(IDevice device, String arch) {
        if (LaunchUtils.isX86(arch)) {
            return device.getArch() == Arch.X86;
        }
        if (LaunchUtils.isArm(arch)) {
            return device.getArch() == Arch.ARM;
        }
        if (LaunchUtils.isArm_64(arch)) {
            return device.getArch() == Arch.AARCH;
        }
        if (LaunchUtils.isX86_64(arch)) {
            return device.getArch() == Arch.X86_64;
        }
        return false;
    }

    public static String getArch(String arch) {
        if (LaunchUtils.isX86(arch)) {
            return ARCH_86_SYMBOL;
        }
        if (LaunchUtils.isArm(arch)) {
            return ARCH_ARM_SYMBOL;
        }
        if (LaunchUtils.isX86_64(arch)) {
            return ARCH_X86_64_SYMBOL;
        }
        if (LaunchUtils.isArm_64(arch)) {
            return ARCH_ARM_64_SYMBOL;
        }
        return "";
    }

    @Deprecated
    public static IDevice getCurrentDeployDevice(IProject project) throws CoreException {
        return null;
    }

    public static IDevice getCurrentDeployDevice() {
        return ConnectionPlugin.getDefault().getCurrentDevice();
    }

    private static ILaunchConfiguration setAvailablePort(IDevice device, int gdbPort, ILaunchConfiguration config) throws CoreException {
        String localPort = Integer.valueOf(gdbPort).toString();
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", localPort);
        wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, localPort);
        ILaunchConfiguration newConfiguration = wc.doSave();
        gdbPort = Integer.parseInt(localPort);
        return newConfiguration;
    }

    public static ILaunchConfiguration createForward(ILaunchConfiguration config, IDevice device) throws CoreException, NumberFormatException, TimeoutException, SdbCommandRejectedException, IOException {
        int gdbPort = 0;
        int gdbserverPort = 0;
        ILaunchConfiguration newConfiguration = config;
        gdbserverPort = gdbPort = Integer.parseInt(config.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102"));
        if (!LocalPortChecker.isPortAvailable((int)gdbPort)) {
            gdbPort = LaunchUtils.getDefaultDebugPort(device);
            if (gdbPort < 0) {
                LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_SET_DEBUG_LOCAL_PORT_TO_NEGATIVE, null);
            }
            newConfiguration = LaunchUtils.setAvailablePort(device, gdbPort, config);
        }
        try {
            device.createForward(gdbPort, gdbserverPort);
            return newConfiguration;
        }
        catch (Exception exception) {
            logger.error("Failed port forwarding. Re-try port forwarding through " + (gdbPort += 5));
            if (gdbPort < 0) {
                LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_SET_DEBUG_LOCAL_PORT_TO_NEGATIVE, null);
            }
            newConfiguration = LaunchUtils.setAvailablePort(device, gdbPort, config);
            device.createForward(gdbPort, gdbserverPort);
            return newConfiguration;
        }
    }

    public static boolean isRemotePortAvailable(IDevice device, int port) {
        boolean result = false;
        SdbCommand sdbCommand = new SdbCommand(device, null);
        String command = String.format(LISTEN_PORT_CHECK, port);
        String output = sdbCommand.returnExecuteCommand(command);
        if (output != null && !output.isEmpty()) {
            if (output.equals("0")) {
                result = true;
            } else {
                logger.error(String.valueOf(port) + " is already using.");
            }
        } else {
            logger.error("Command " + command + " failed...");
        }
        return result;
    }

    public static int getDefaultDebugPort(IDevice currentDevice) {
        int debugPort = 0;
        int debugPortBase = Integer.valueOf("26102");
        if (currentDevice != null && !currentDevice.isEmulator()) {
            debugPortBase += 100;
        }
        debugPort = debugPortBase;
        while (debugPort < 65535 && !LocalPortChecker.isPortAvailable((int)debugPort)) {
            debugPort += 10;
        }
        if (LocalPortChecker.isPortAvailable((int)debugPort)) {
            return debugPort;
        }
        return -1;
    }

    public static String getChangingArch(String arch, IDevice device) {
        String changingArch = device.getArch().getArch();
        return changingArch;
    }

    private static IXMLStore getXMLStore(ILaunchConfiguration config) {
        IXMLStore store = null;
        try {
            IProject project = ProjectUtil.getProject(config);
            if (project != null) {
                store = ProjectUtil.getXmlStore(project);
            }
        }
        catch (CoreException e) {
            logger.error("Failed to get a project", (Throwable)e);
        }
        return store;
    }

    public static boolean isImeCategory(ILaunchConfiguration config) {
        IXMLStore store = LaunchUtils.getXMLStore(config);
        return store != null ? store.isImeCategory() : false;
    }

    public static boolean isSubMode(ILaunchConfiguration config) {
        IXMLStore store = LaunchUtils.getXMLStore(config);
        return store != null ? store.isSubMode() : false;
    }

    public static boolean isLaunchOnBoot(ILaunchConfiguration config) {
        IXMLStore store = LaunchUtils.getXMLStore(config);
        return store != null ? store.isLaunchOnBoot() : false;
    }

    public static boolean isROApp(IProject project, SdbCommand sdbCommand) throws CoreException {
        String[] lines;
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(project);
        String pkgId = manifest.getPackageName();
        String command = String.format(TizenPlatformConstants.PKG_TOOL_ROAPP_CHECK_COMMAND, pkgId);
        try {
            sdbCommand.runCommand(command);
        }
        catch (Exception e) {
            logger.error("Failed to run a command " + command, (Throwable)e);
            return false;
        }
        String[] stringArray = lines = sdbCommand.getResultLineStrings();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (TizenPlatformConstants.ROAPP_RESULT.equals(line)) {
                return true;
            }
            if (TizenPlatformConstants.RWAPP_RESULT.equals(line)) {
                return false;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isOspCompat(ILaunchConfiguration config) {
        IXMLStore store = LaunchUtils.getXMLStore(config);
        return store != null ? store.isOspCompat() : false;
    }

    public static String getDeviceId(IDevice device) {
        return device.getSerialNumber();
    }

    public static IDevice getDeviceFromLaunchConfiguration(ILaunchConfiguration configuration) {
        IDevice[] devices = SmartDevelopmentBridge.getBridge().getDevices();
        return LaunchUtils.getDeviceFromLaunchConfiguration(configuration, devices);
    }

    public static IDevice getDeviceFromLaunchConfiguration(ILaunchConfiguration configuration, IDevice[] devices) {
        TizenNativeLaunchConfiguration nativeconfig = new TizenNativeLaunchConfiguration(configuration);
        return nativeconfig.getDeviceFromLaunchConfiguration(devices);
    }

    public static void setDeviceToLaunchConfiguration(ILaunchConfigurationWorkingCopy wc, IDevice device) {
        TizenNativeLaunchConfiguration nativeconfig = new TizenNativeLaunchConfiguration((ILaunchConfiguration)wc);
        nativeconfig.setDeviceToLaunchConfiguration(device);
    }

    public static String getGdbserverPort(ILaunchConfiguration config) {
        String gdbserverPort = "26102";
        try {
            gdbserverPort = config.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPort);
        }
        catch (CoreException coreException) {
            logger.error("Failed to get gdbserver port from launch configuration");
        }
        return gdbserverPort;
    }

    public static void touchExecutableFile(IProject project) {
        String[] configs;
        String defaultConfig = ManagedBuildManager.getBuildInfo((IResource)project).getConfigurationName();
        String[] stringArray = configs = ManagedBuildManager.getBuildInfo((IResource)project).getConfigurationNames();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            String config = stringArray[n2];
            if (!config.equals(defaultConfig)) {
                String exeFileName = String.valueOf(ProjectUtil.getArtefactName(project)) + "." + ProjectUtil.getArtifactExtension(project);
                IFile exeFile = project.getFolder(config).getFile(exeFileName);
                if (exeFile.exists()) {
                    try {
                        exeFile.touch(null);
                    }
                    catch (CoreException e) {
                        logger.error("Failed to touch an executable file - " + exeFile.getLocation(), (Throwable)e);
                    }
                }
            }
            ++n2;
        }
    }

    public static boolean setAvailableGdbServerPort(ILaunch launch, ILaunchConfiguration config, IDevice currentDevice) throws NumberFormatException, CoreException {
        int gdbserverPort = Integer.parseInt(config.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102"));
        boolean isRemotePortAvailable = LaunchUtils.isRemotePortAvailable(currentDevice, gdbserverPort);
        boolean isReserved = false;
        if (!isRemotePortAvailable) {
            while (gdbserverPort++ != 26150) {
                isReserved = false;
                int[] nArray = RESERVED_PORTNO;
                int n = RESERVED_PORTNO.length;
                int n2 = 0;
                while (n2 < n) {
                    int reserved = nArray[n2];
                    if (reserved == gdbserverPort) {
                        isReserved = true;
                        break;
                    }
                    ++n2;
                }
                if (isReserved) {
                    logger.debug("The GDBServer port number (" + gdbserverPort + ") is already reserved.");
                    continue;
                }
                isRemotePortAvailable = LaunchUtils.isRemotePortAvailable(currentDevice, gdbserverPort);
                if (isRemotePortAvailable) {
                    logger.debug("The GDBServer port number (" + gdbserverPort + ") has reset.");
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", String.valueOf(gdbserverPort));
                    wc.doSave();
                    break;
                }
                logger.debug("The GDBServer port number (" + gdbserverPort + ") is already in use.");
            }
        }
        if (!isRemotePortAvailable) {
            logger.error("There is no available gdbserver port.");
            String title = TizenLaunchMessages.LAUNCH_ERROR;
            String message = TizenLaunchMessages.GDBSERVER_PORT_NO_AVAILABLE;
            LaunchUtils.openLinkDialog(null, title, message);
        }
        return isRemotePortAvailable;
    }

    public static void openLinkDialog(final SelectionListener listener, final String title, final String message) {
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                LinkDialog dialog = new LinkDialog(SWTUtil.getShell(), listener, title, message);
                dialog.open();
            }
        });
    }
}

