/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.manifest.Messages;
import org.tizen.nativecore.ext.manifest.UiApplication;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ManifestHandler {
    public void parse(File file, Manifest manifest) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(file);
            dom.normalizeDocument();
            dom.getDocumentElement().normalize();
            manifest.loadElement(dom.getDocumentElement());
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (ParserConfigurationException e3) {
            e3.printStackTrace();
        }
    }

    public void save(File file, Manifest manifest) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.newDocument();
            manifest.generateElement(dom, null);
            String buff = this.write(dom);
            if (buff == null) {
                return;
            }
            if (file.exists()) {
                FileUtil.writeTextFile((File)file, (String)buff, (String)"utf-8");
            } else {
                FileUtil.createTextFile((File)file, (String)buff, (String)"utf-8");
            }
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            DialogUtil.openErrorDialog((String)(String.valueOf(Messages.MANIFESTHANDLER_ERR) + (e2.getMessage() != null ? e2.getMessage() : "")));
        }
    }

    public boolean parseXml(String xmlString, Manifest manifest) {
        if (manifest != null) {
            manifest.clear();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new InputSource(new StringReader(xmlString)));
                manifest.loadElement(dom.getDocumentElement());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    public String getXml(Manifest manifest) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        String buff = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.newDocument();
            manifest.generateElement(dom, null);
            buff = this.write(dom);
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        return buff;
    }

    public void merge(Manifest manifestBase, Manifest manifestSub) {
        manifestBase.getApplication_list().addAll(manifestSub.getApplication_list());
        manifestBase.getPrivilege_map().putAll(manifestSub.getPrivilege_map());
        manifestBase.getFeature_map().putAll(manifestSub.getFeature_map());
        manifestBase.getAccounts().addAll(manifestSub.getAccounts());
        if (manifestBase.getDefaultApp() instanceof UiApplication && manifestSub.getDefaultApp() instanceof UiApplication) {
            manifestBase.getShortCutList().addAll(manifestSub.getShortCutList());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String write(Document dom) {
        TransformerFactory factory = TransformerFactory.newInstance();
        StringWriter sw = null;
        String resStr = null;
        try {
            try {
                sw = new StringWriter();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(4));
                transformer.transform(new DOMSource(dom), new StreamResult(sw));
                resStr = sw.getBuffer().toString();
                return resStr;
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
                if (sw == null) return resStr;
                try {
                    sw.close();
                    return resStr;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return resStr;
            }
            catch (TransformerException e) {
                e.printStackTrace();
                if (sw == null) return resStr;
                try {
                    sw.close();
                    return resStr;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return resStr;
            }
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

