/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.tizen.core.gputil.MacroUtil;

public class ToolchainData {
    public static final String START_LITER = "${";
    public static final String END_LITER = "}";
    private String id;
    private String name;
    private String version;
    private String architecture;
    private String path;
    private Properties prop = new Properties();
    private Map<String, ToolData> tools = new HashMap<String, ToolData>();

    public ToolchainData(String id, String name, String version, String architecture, String path) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.architecture = architecture;
        this.path = path;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getPath() {
        return this.path;
    }

    public void addProperty(String key, String value) {
        this.prop.put(key, value);
    }

    public String getProperty(String key) {
        return this.prop.getProperty(key);
    }

    public void addTool(String name, String version, String path) {
        this.tools.put(name, new ToolData(name, version, path));
    }

    public Collection<ToolData> getToolList() {
        return this.tools.values();
    }

    public ToolData getTool(String name) {
        return this.tools.get(name);
    }

    public void processMacro(Map<String, String> macros, String startLiter, String endLiter) {
        this.path = MacroUtil.processMacro((String)this.path, macros, (String)startLiter, (String)endLiter);
        Set<String> propList = this.prop.stringPropertyNames();
        for (String name : propList) {
            String value = this.prop.getProperty(name);
            this.prop.put(name, MacroUtil.processMacro((String)value, macros, (String)startLiter, (String)endLiter));
        }
        Collection<ToolData> toolList = this.tools.values();
        for (ToolData tool : toolList) {
            tool.path = MacroUtil.processMacro((String)tool.path, macros, (String)startLiter, (String)endLiter);
        }
    }

    public void processMacro(Map<String, String> macros) {
        this.processMacro(macros, START_LITER, END_LITER);
    }

    public class ToolData {
        public String name;
        public String version;
        public String path;

        public ToolData(String name, String version, String path) {
            this.name = name;
            this.version = version;
            this.path = path;
        }
    }
}

