/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli.sbiplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.tizen.core.gputil.OSChecker;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SBIRootstrapManager {
    public static List<SBIRootstrapData> getRootstrapDataList(String sbiHomePath) {
        if (OSChecker.isWindows()) {
            sbiHomePath = sbiHomePath.replace("/", "\\");
        }
        File sbiHomeFile = new File(sbiHomePath, "plugins");
        File[] xmlFiles = sbiHomeFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        String xpath = "/extension[@point='rootstrapDefinition']";
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath expr = xpathFactory.newXPath();
        if (xmlFiles != null) {
            ArrayList<SBIRootstrapData> ids = new ArrayList<SBIRootstrapData>();
            for (File xmlFile : xmlFiles) {
                try {
                    Document doc = XMLUtil.readXML((InputStream)new FileInputStream(xmlFile));
                    NodeList nodes = null;
                    Object nodeset = null;
                    try {
                        nodeset = expr.evaluate(xpath, doc, XPathConstants.NODESET);
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (nodeset == null || !(nodeset instanceof NodeList)) continue;
                    nodes = (NodeList)nodeset;
                    int size = nodes.getLength();
                    for (int i = 0; i < size; ++i) {
                        Node node = nodes.item(i);
                        if (!(node instanceof Element)) continue;
                        NodeList rootStraps = ((Element)node).getElementsByTagName("rootstrap");
                        int rootstrapSize = rootStraps.getLength();
                        for (int j = 0; j < rootstrapSize; ++j) {
                            Element propElem;
                            int k;
                            Element element = (Element)rootStraps.item(j);
                            String id = element.getAttribute("id");
                            String name = element.getAttribute("name");
                            String version = element.getAttribute("version");
                            String architecture = element.getAttribute("architecture");
                            String path = element.getAttribute("path");
                            SBIRootstrapData rootStrapData = new SBIRootstrapData(id, name, version, architecture, path);
                            rootStrapData.addProperty("id", id);
                            rootStrapData.addProperty("name", name);
                            rootStrapData.addProperty("version", version);
                            rootStrapData.addProperty("architecture", architecture);
                            rootStrapData.addProperty("path", path);
                            NodeList childNodes = element.getElementsByTagName("property");
                            int elemSize = childNodes.getLength();
                            for (k = 0; k < elemSize; ++k) {
                                propElem = (Element)childNodes.item(k);
                                rootStrapData.addProperty(propElem.getAttribute("key"), propElem.getAttribute("value"));
                            }
                            childNodes = element.getElementsByTagName("toolchain");
                            elemSize = childNodes.getLength();
                            for (k = 0; k < elemSize; ++k) {
                                propElem = (Element)childNodes.item(k);
                                rootStrapData.addToolchain(propElem.getAttribute("name"), propElem.getAttribute("version"), Boolean.valueOf(propElem.getAttribute("default")));
                            }
                            childNodes = element.getElementsByTagName("tool");
                            elemSize = childNodes.getLength();
                            for (k = 0; k < elemSize; ++k) {
                                propElem = (Element)childNodes.item(k);
                                rootStrapData.addTool(propElem.getAttribute("name"), propElem.getAttribute("version"), propElem.getAttribute("path"));
                            }
                            ids.add(rootStrapData);
                        }
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                    return null;
                }
            }
            return ids;
        }
        return null;
    }

    public static SBIRootstrapData getRootstrap(List<SBIRootstrapData> rootstrapList, String rootstrapId) {
        if (rootstrapId == null) {
            return null;
        }
        for (SBIRootstrapData rootstrap : rootstrapList) {
            if (!rootstrapId.equals(rootstrap.getId())) continue;
            return rootstrap;
        }
        return null;
    }

    public static SBIRootstrapData getRootstrap(List<SBIRootstrapData> rootstrapList, String platformName, String architecture) {
        if (platformName == null || architecture == null) {
            return null;
        }
        for (SBIRootstrapData rootstrap : rootstrapList) {
            if (!platformName.equals(rootstrap.getPlatformName()) || !architecture.equals(rootstrap.getArchitecture())) continue;
            return rootstrap;
        }
        return null;
    }

    public static Map<String, List<String>> getRootstrapParam(String rootStrapPath) {
        Document doc = null;
        doc = XMLUtil.readXML((File)new File(rootStrapPath));
        if (doc == null) {
            return null;
        }
        String xpath = "/PackageInfo/DevPackage";
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath expr = xpathFactory.newXPath();
        Object nodeset = null;
        try {
            nodeset = expr.evaluate(xpath, doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<String> arg1 = new ArrayList<String>();
        ArrayList<String> arg2 = new ArrayList<String>();
        ArrayList<String> arg3 = new ArrayList<String>();
        if (nodeset instanceof NodeList) {
            NodeList nodes = (NodeList)nodeset;
            int size = nodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                List itemElems = XMLUtil.getElementsByTag((Element)((Element)node), (String)"include_path");
                for (Element elm : itemElems) {
                    arg1.add(elm.getTextContent());
                }
                itemElems = XMLUtil.getElementsByTag((Element)((Element)node), (String)"library_path");
                for (Element elm : itemElems) {
                    arg2.add(elm.getTextContent());
                }
                itemElems = XMLUtil.getElementsByTag((Element)((Element)node), (String)"library");
                for (Element elm : itemElems) {
                    String txt = elm.getTextContent();
                    if (!txt.startsWith("lib")) continue;
                    if (txt.endsWith(".so")) {
                        arg3.add(txt.substring(3, txt.length() - 3));
                        continue;
                    }
                    if (!txt.endsWith(".a")) continue;
                    arg3.add(txt.substring(3, txt.length() - 2));
                }
            }
        }
        HashMap<String, List<String>> prop = new HashMap<String, List<String>>();
        if (!arg1.isEmpty()) {
            prop.put("include_path", arg1);
        }
        if (arg2.isEmpty()) {
            arg2.add("/usr/lib");
        }
        prop.put("library_path", arg2);
        if (!arg3.isEmpty()) {
            prop.put("library", arg3);
        }
        return prop;
    }
}

